/* Ustawienie katalogu domowego (katalogu instalacji oprogramowania) */
%default HOME `echo \$HOME/Software/`

REGISTER $HOME/pig/build/ivy/lib/Pig/avro-1.5.3.jar
REGISTER $HOME/pig/build/ivy/lib/Pig/json-simple-1.1.jar
REGISTER $HOME/pig/contrib/piggybank/java/piggybank.jar

DEFINE AvroStorage org.apache.pig.piggybank.storage.avro.AvroStorage();

/* Biblioteki i konfiguracja MongoDB */
REGISTER $HOME/mongo-hadoop/mongo-2.10.1.jar
REGISTER $HOME/mongo-hadoop/core/target/mongo-hadoop-core-1.1.0-SNAPSHOT.jar
REGISTER $HOME/mongo-hadoop/pig/target/mongo-hadoop-pig-1.1.0-SNAPSHOT.jar

/* Wyłączenie wykonania spekulatywnego, żeby nie ryzykować zduplikowanych rekordów w MongoDB */
set mapred.map.tasks.speculative.execution false
set mapred.reduce.tasks.speculative.execution false
define MongoStorage com.mongodb.hadoop.pig.MongoStorage(); /* Shortcut */

rmf /tmp/sent_counts.txt

/* Wczytanie e-maili w formacie Avro za pomocą modułu AvroStorage z Piggybanku */
messages = LOAD '/me/Data/test_mbox' USING AvroStorage();

/* Odfiltrowanie pustych, nie przydadzą się */
messages = FILTER messages BY (from IS NOT NULL) AND (tos IS NOT NULL);

/* Odbiorcami wiadomości może być więcej osób; funkcja FLATTEN() dokona projekcji par from-to dla każdego istniejącego 'to' */
addresses = FOREACH messages GENERATE from.address AS from, FLATTEN(tos.(address)) AS to;

/* Ujednolicenie wielkości liter w adresach, żeby nie uznawać adresów różniących się tylko wielkością liter za różne */
lowers = FOREACH addresses GENERATE LOWER(from) AS from, LOWER(to) AS to;

/* Grupowanie wszystkich par from/to i zliczenie zawartości grup ($1 oznacza drugie pole).
   Odpowiednik zapytania SQL:  SELECT from, to, COUNT(*) FROM lowers GROUP BY (from, to);
   UWAGA: COUNT_STAR różni się od COUNT tym, że zlicza również puste wartości */
by_from_to = GROUP lowers BY (from, to);
sent_counts = FOREACH by_from_to GENERATE FLATTEN(group) AS (from, to), COUNT_STAR(lowers) AS total;

/* Posortowanie par, od najczęściej występujących */
sent_counts = ORDER sent_counts BY total DESC;
STORE sent_counts INTO '/tmp/sent_counts.txt';
STORE sent_counts INTO 'mongodb://jack:OpenSesame@testola-rjurney-data-0.azva.dotcloud.net:40961/agile_data.sent_counts' using MongoStorage();
