/* Ustawienie katalogu domowego (katalogu instalacji oprogramowania) */
%default HOME `echo \$HOME/Software/`

/* Avro używa json-simple i jest w bibliotekach piggybank; od wersji Pig 0.12 AvroStorage i TrevniStorage są elementami wbudowanymi */
REGISTER $HOME/pig/build/ivy/lib/Pig/avro-1.5.3.jar
REGISTER $HOME/pig/build/ivy/lib/Pig/json-simple-1.1.jar
REGISTER $HOME/pig/contrib/piggybank/java/piggybank.jar

DEFINE AvroStorage org.apache.pig.piggybank.storage.avro.AvroStorage();
DEFINE substr org.apache.pig.piggybank.evaluation.string.SUBSTRING();
DEFINE tohour org.apache.pig.piggybank.evaluation.datetime.truncate.ISOToHour();

/* Biblioteki i konfiguracja MongoDB */
REGISTER $HOME/mongo-hadoop/mongo-2.10.1.jar
REGISTER $HOME/mongo-hadoop/core/target/mongo-hadoop-core-1.1.0-SNAPSHOT.jar
REGISTER $HOME/mongo-hadoop/pig/target/mongo-hadoop-pig-1.1.0-SNAPSHOT.jar

DEFINE MongoStorage com.mongodb.hadoop.pig.MongoStorage();

set default_parallel 5
set mapred.map.tasks.speculative.execution false
set mapred.reduce.tasks.speculative.execution false

rmf /tmp/related_addresses.txt

emails = load '/me/Data/test_mbox' using AvroStorage();
/* Musimy uznać adresy z reply_to jako pełnoprawne adresy nadawców, inaczej ryzykujemy występowanie wiadomości bez nadawców */
split emails into has_reply_to if (reply_tos is not null), just_froms if (reply_tos is null);

/* Jeśli wiadomość ma ustawione pola from i reply_to, zliczamy oba adresy */
reply_tos = foreach has_reply_to generate FLATTEN(reply_tos.address) as from, tos, ccs, bccs;
reply_to_froms = foreach has_reply_to generate from.address as from, tos, ccs, bccs;
/* Wiadomości bez pola reply_to traktujemy normalnie */
just_froms = foreach just_froms generate from.address as from, tos, ccs, bccs;
/* Wystarczy już wyznaczyć unię poszczególnych podzbiorów aby otrzymać wynikowy zbiór danych */
all_froms = union reply_tos, reply_to_froms, just_froms;
/* Teraz sparujemy adresy nadawców (from/reply_to) z wszystkimi typami odbiorców, 
   i złączymy je do jednej listy połączeń nadawca-odbiorca. */
tos = foreach all_froms generate flatten(from) as from, flatten(tos.address) as to;
ccs = foreach all_froms generate flatten(from) as from, flatten(ccs.address) as to;
bccs = foreach all_froms generate flatten(from) as from, flatten(bccs.address) as to;
pairs = union tos, ccs, bccs;

counts = foreach (group pairs by (from, to)) generate flatten(group) as (from, to), 
                                                      COUNT(pairs) as total;

top_pairs = foreach (group counts by from) {
  filtered = filter counts by (to is not null);
  sorted = order filtered by total desc;
  top_8 = limit sorted 8;
  generate group as address, top_8.(to) as related_addresses;
}

store top_pairs into '/tmp/related_addresses.txt';
store top_pairs into 'mongodb://localhost/agile_data.related_addresses' using MongoStorage();
