# -*- coding: utf-8 -*-
import RPi.GPIO as GPIO
import time

GPIO.setmode(GPIO.BCM)

in_1_pin = 23     # (1)
in_2_pin = 24
in_3_pin = 25
in_4_pin = 18

GPIO.setup(in_1_pin, GPIO.OUT)
GPIO.setup(in_2_pin, GPIO.OUT)
GPIO.setup(in_3_pin, GPIO.OUT)
GPIO.setup(in_4_pin, GPIO.OUT)

period = 0.02

def step_forward(steps, period):    # (2)
  for i in range(0, steps):
    set_coils(1, 0, 0, 1)
    time.sleep(period)
    set_coils(1, 0, 1, 0)
    time.sleep(period)
    set_coils(0, 1, 1, 0)
    time.sleep(period)
    set_coils(0, 1, 0, 1)
    time.sleep(period)

def step_reverse(steps, period):   
  for i in range(0, steps):
    set_coils(0, 1, 0, 1)
    time.sleep(period)
    set_coils(0, 1, 1, 0)
    time.sleep(period)
    set_coils(1, 0, 1, 0)
    time.sleep(period)
    set_coils(1, 0, 0, 1)
    time.sleep(period)

  
def set_coils(in1, in2, in3, in4):     # (3)
  GPIO.output(in_1_pin, in1)
  GPIO.output(in_2_pin, in2)
  GPIO.output(in_3_pin, in3)
  GPIO.output(in_4_pin, in4)
  

try:
    print('Polecenie w formie litery oraz liczby');
    print('p20 - 20 ms przerwy pomiędzy kolejnymi krokami (prędkość obrotowa)');
    print('f100 - 100 kroków w przód');
    print('r100 - 100 kroków w tył');
    
    while True:      # (4)
        command = raw_input('Wprowadź polecenie: ')
        parameter_str = command[1:] # od znaku nr 1 do końca
        parameter = int(parameter_str)     # (5)
        if command[0] == 'p':     # (6)
            period = parameter / 1000.0
        elif command[0] == 'f':
            step_forward(parameter, period)
        elif command[0] == 'r':
            step_reverse(parameter, period)

finally:
    print('Czyszczenie')
    GPIO.cleanup()