#!/usr/bin/env python
# -*- coding: utf-8 -*-

import time, random
from neopixel import *

# Taśma diod LED
LED_COUNT      = 30      # Liczba pikseli (diod LED).
LED_PIN        = 18      # Pin GPIO, do którego podłączone są diody (pin ten musi obsługiwać technologię PWM!).
LED_FREQ_HZ    = 800000  # Częstotliwość sygnału sterującego pracą diod LED wyrażona w hercach (zwykle 800kHz).
LED_DMA        = 5       # Kanał DMA używany do generowania sygnału (wypróbuj kanał nr 5).
LED_BRIGHTNESS = 255     # Najciemniejszy efekt uzyskasz przy wartości 0, a najjaśniejszy przy wartości 255.
LED_INVERT     = True    # Wartość logiczna True powinna być użyta w celu odwrócenia sygnału (przy konwersji poziomu sygnału za pomocą tranzystora NPN).

# Inicjalizuj wyświetlacz.       
strip = Adafruit_NeoPixel(LED_COUNT, LED_PIN, LED_FREQ_HZ, LED_DMA, LED_INVERT, LED_BRIGHTNESS)
strip.begin()

while True:
    for i in range(strip.numPixels()):
        red = random.randint(0, 255)
        green = random.randint(0, 255)
        blue = random.randint(0, 255)
        strip.setPixelColor(i, Color(red, green, blue))
        strip.show()
    time.sleep(0.1)


