package com.allendowney.thinkdast;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import org.jfree.data.xy.XYSeries;

import com.allendowney.thinkdast.Profiler.Timeable;

public class ProfileListAdd {
   
   /**
    * @param args
    */
   public static void main(String[] args) {
      profileArrayListAddEnd();
      //profileArrayListAddBeginning();
      //profileLinkedListAddBeginning();
      //profileLinkedListAddEnd();
   }

   /**
    * Określanie czasu wykonania operacji dodawania na końcu listy będącej obiektem klasy ArrayList
    */
   public static void profileArrayListAddEnd() {
      Timeable timeable = new Timeable() {
         List<String> list;

         public void setup(int n) {
            list = new ArrayList<String>();
         }

         public void timeMe(int n) {
            for (int i=0; i<n; i++) {
               list.add("łańcuch znakowy");
            }
         }
      };
      int startN = 4000;
      int endMillis = 1000;
      runProfiler("Klasa ArrayList, dodawanie na końcu", timeable, startN, endMillis);
   }
   
   /**
    * Określanie czasu wykonania operacji dodawania na początku listy będącej obiektem klasy ArrayList
    */
   public static void profileArrayListAddBeginning() {
      // TODO: UZUPEŁNIJ TEN KOD!
   }

   /**
    * Określanie czasu wykonania operacji dodawania na początku listy będącej obiektem klasy LinkedList
    */
   public static void profileLinkedListAddBeginning() {
      // TODO: UZUPEŁNIJ TEN KOD!
   }

   /**
    * Określanie czasu wykonania operacji dodawania na końcu listy będącej obiektem klasy LinkedList
    */
   public static void profileLinkedListAddEnd() {
      // TODO: UZUPEŁNIJ TEN KOD!
   }

   /**
    * Wykonuje profilowanie i wyświetla wyniki.
    * 
    * @param timeable
    * @param startN
    * @param endMillis
    */
   private static void runProfiler(String title, Timeable timeable, int startN, int endMillis) {
      Profiler profiler = new Profiler(title, timeable);
      XYSeries series = profiler.timingLoop(startN, endMillis);
      profiler.plotResults(series);
   }
}