/**
 *
 */
package com.allendowney.thinkdast;

import java.util.List;
import java.util.Map;

/**
 * Implementacja interfejsu Map wykorzystująca kolekcję MyLinearMap
 * i zmieniająca rozmiar, gdy pojawia się zbyt wiele wpisów.
 *
 * @author downey
 * @param <K>
 * @param <V>
 *
 */
public class MyHashMap<K, V> extends MyBetterMap<K, V> implements Map<K, V> {

   // średnia liczba wpisów przypadających na podmapę przed ponownym mieszaniem
   protected static final double FACTOR = 1.0;

   @Override
   public V put(K key, V value) {
      V oldValue = super.put(key, value);

      //System.out.println("Umieść " + key + " w " + map + " obecny rozmiar " + map.size());

      // sprawdza, czy liczba elementów przypadających na podmapę przekracza wartość graniczną
      if (size() > maps.size() * FACTOR) {
         rehash();
      }
      return oldValue;
   }

   /**
    * Podwaja liczbę map i rehaszuje istniejące wpisy.
    */
   /**
    *
    */
   protected void rehash() {
      // zachowaj istniejące wpisy
      List<MyLinearMap<K, V>> oldMaps = maps;

      // utwórz więcej map
      int newK = maps.size() * 2;
      makeMaps(newK);
      
      //System.out.println("Rehaszowanie, n wynosi teraz " + newN);
      
      // umieść wpisy w nowej mapie
      for (MyLinearMap<K, V> map: oldMaps) {
         for (Map.Entry<K, V> entry: map.getEntries()) {
            put(entry.getKey(), entry.getValue());
         }
      }
   }

   /**
    * @param args
    */
   public static void main(String[] args) {
      Map<String, Integer> map = new MyHashMap<String, Integer>();
      for (int i=0; i<10; i++) {
         map.put(new Integer(i).toString(), i);
      }
      Integer value = map.get("3");
      System.out.println(value);
   }
}