/**
 * 
 */
package com.allendowney.thinkdast;

import java.util.Arrays;

/**
 * @author downey
 *
 */
public class SelectionSort {

   /**
    * Zamienia miejscami elementy spod indeksów i oraz j.
    */
   public static void swapElements(int[] array, int i, int j) {
      int temp = array[i];
      array[i] = array[j];
      array[j] = temp;
   }

   /**
    * Znajduje indeks najmniejszej wartości,
    * zaczynając od początkowego indeksu (włącznie)
    * i poruszając się aż do końca tablicy.
    */
   public static int indexLowest(int[] array, int start) {
      int lowIndex = start;
      for (int i = start; i < array.length; i++) {
         if (array[i] < array[lowIndex]) {
            lowIndex = i;
         }
      }
      return lowIndex;
   }

   /**
    * Sortuje elementy (w miejscu), używając sortowania przez wybieranie.
    */
   public static void selectionSort(int[] array) {
      for (int i = 0; i < array.length; i++) {
         int j = indexLowest(array, i);
         swapElements(array, i, j);
      }
   }

   /**
    * @param args
    */
   public static void main(String[] args) {
      int[] array = {2, 5, 6, 1, 3};
      selectionSort(array);
      System.out.println(Arrays.toString(array));
   }

} 
