/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BasicRedisPipeline;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Client;
import redis.clients.jedis.ClusterPipeline;
import redis.clients.jedis.MultiKeyBinaryRedisPipeline;
import redis.clients.jedis.MultiKeyCommandsPipeline;
import redis.clients.jedis.PipelineBase;
import redis.clients.jedis.Response;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.ZParams;

public abstract class MultiKeyPipelineBase
extends PipelineBase
implements BasicRedisPipeline,
MultiKeyBinaryRedisPipeline,
MultiKeyCommandsPipeline,
ClusterPipeline {
    protected Client client = null;

    @Override
    public Response<List<String>> brpop(String ... args) {
        this.client.brpop(args);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<List<String>> brpop(int timeout, String ... keys) {
        this.client.brpop(timeout, keys);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<List<String>> blpop(String ... args) {
        this.client.blpop(args);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<List<String>> blpop(int timeout, String ... keys) {
        this.client.blpop(timeout, keys);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<Map<String, String>> blpopMap(int timeout, String ... keys) {
        this.client.blpop(timeout, keys);
        return this.getResponse(BuilderFactory.STRING_MAP);
    }

    @Override
    public Response<List<byte[]>> brpop(byte[] ... args) {
        this.client.brpop(args);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    public Response<List<String>> brpop(int timeout, byte[] ... keys) {
        this.client.brpop(timeout, keys);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<Map<String, String>> brpopMap(int timeout, String ... keys) {
        this.client.blpop(timeout, keys);
        return this.getResponse(BuilderFactory.STRING_MAP);
    }

    @Override
    public Response<List<byte[]>> blpop(byte[] ... args) {
        this.client.blpop(args);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    public Response<List<String>> blpop(int timeout, byte[] ... keys) {
        this.client.blpop(timeout, keys);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<Long> del(String ... keys) {
        this.client.del(keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> del(byte[] ... keys) {
        this.client.del(keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> exists(String ... keys) {
        this.client.exists(keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> exists(byte[] ... keys) {
        this.client.exists(keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Set<String>> keys(String pattern) {
        this.getClient(pattern).keys(pattern);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    @Override
    public Response<Set<byte[]>> keys(byte[] pattern) {
        this.getClient(pattern).keys(pattern);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<List<String>> mget(String ... keys) {
        this.client.mget(keys);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<List<byte[]>> mget(byte[] ... keys) {
        this.client.mget(keys);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<String> mset(String ... keysvalues) {
        this.client.mset(keysvalues);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> mset(byte[] ... keysvalues) {
        this.client.mset(keysvalues);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> msetnx(String ... keysvalues) {
        this.client.msetnx(keysvalues);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> msetnx(byte[] ... keysvalues) {
        this.client.msetnx(keysvalues);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> rename(String oldkey, String newkey) {
        this.client.rename(oldkey, newkey);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> rename(byte[] oldkey, byte[] newkey) {
        this.client.rename(oldkey, newkey);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> renamenx(String oldkey, String newkey) {
        this.client.renamenx(oldkey, newkey);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> renamenx(byte[] oldkey, byte[] newkey) {
        this.client.renamenx(oldkey, newkey);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> rpoplpush(String srckey, String dstkey) {
        this.client.rpoplpush(srckey, dstkey);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> rpoplpush(byte[] srckey, byte[] dstkey) {
        this.client.rpoplpush(srckey, dstkey);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<Set<String>> sdiff(String ... keys) {
        this.client.sdiff(keys);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    @Override
    public Response<Set<byte[]>> sdiff(byte[] ... keys) {
        this.client.sdiff(keys);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Long> sdiffstore(String dstkey, String ... keys) {
        this.client.sdiffstore(dstkey, keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> sdiffstore(byte[] dstkey, byte[] ... keys) {
        this.client.sdiffstore(dstkey, keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Set<String>> sinter(String ... keys) {
        this.client.sinter(keys);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    @Override
    public Response<Set<byte[]>> sinter(byte[] ... keys) {
        this.client.sinter(keys);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Long> sinterstore(String dstkey, String ... keys) {
        this.client.sinterstore(dstkey, keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> sinterstore(byte[] dstkey, byte[] ... keys) {
        this.client.sinterstore(dstkey, keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> smove(String srckey, String dstkey, String member) {
        this.client.smove(srckey, dstkey, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> smove(byte[] srckey, byte[] dstkey, byte[] member) {
        this.client.smove(srckey, dstkey, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> sort(String key, SortingParams sortingParameters, String dstkey) {
        this.client.sort(key, sortingParameters, dstkey);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        this.client.sort(key, sortingParameters, dstkey);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> sort(String key, String dstkey) {
        this.client.sort(key, dstkey);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> sort(byte[] key, byte[] dstkey) {
        this.client.sort(key, dstkey);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Set<String>> sunion(String ... keys) {
        this.client.sunion(keys);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    @Override
    public Response<Set<byte[]>> sunion(byte[] ... keys) {
        this.client.sunion(keys);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Long> sunionstore(String dstkey, String ... keys) {
        this.client.sunionstore(dstkey, keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> sunionstore(byte[] dstkey, byte[] ... keys) {
        this.client.sunionstore(dstkey, keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> watch(String ... keys) {
        this.client.watch(keys);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> watch(byte[] ... keys) {
        this.client.watch(keys);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> zinterstore(String dstkey, String ... sets) {
        this.client.zinterstore(dstkey, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zinterstore(byte[] dstkey, byte[] ... sets) {
        this.client.zinterstore(dstkey, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zinterstore(String dstkey, ZParams params, String ... sets) {
        this.client.zinterstore(dstkey, params, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        this.client.zinterstore(dstkey, params, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zunionstore(String dstkey, String ... sets) {
        this.client.zunionstore(dstkey, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zunionstore(byte[] dstkey, byte[] ... sets) {
        this.client.zunionstore(dstkey, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zunionstore(String dstkey, ZParams params, String ... sets) {
        this.client.zunionstore(dstkey, params, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        this.client.zunionstore(dstkey, params, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> bgrewriteaof() {
        this.client.bgrewriteaof();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> bgsave() {
        this.client.bgsave();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<List<String>> configGet(String pattern) {
        this.client.configGet(pattern);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<String> configSet(String parameter, String value) {
        this.client.configSet(parameter, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> brpoplpush(String source, String destination, int timeout) {
        this.client.brpoplpush(source, destination, timeout);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> brpoplpush(byte[] source, byte[] destination, int timeout) {
        this.client.brpoplpush(source, destination, timeout);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<String> configResetStat() {
        this.client.configResetStat();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> save() {
        this.client.save();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> lastsave() {
        this.client.lastsave();
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> publish(String channel, String message) {
        this.client.publish(channel, message);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> publish(byte[] channel, byte[] message) {
        this.client.publish(channel, message);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> randomKey() {
        this.client.randomKey();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> randomKeyBinary() {
        this.client.randomKey();
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<String> flushDB() {
        this.client.flushDB();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> flushAll() {
        this.client.flushAll();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> info() {
        this.client.info();
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> info(String section) {
        this.client.info(section);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<List<String>> time() {
        this.client.time();
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<Long> dbSize() {
        this.client.dbSize();
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> shutdown() {
        this.client.shutdown();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> ping() {
        this.client.ping();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> select(int index) {
        this.client.select(index);
        Response<String> response = this.getResponse(BuilderFactory.STRING);
        this.client.setDb(index);
        return response;
    }

    @Override
    public Response<Long> bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        this.client.bitop(op, destKey, srcKeys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> bitop(BitOP op, String destKey, String ... srcKeys) {
        this.client.bitop(op, destKey, srcKeys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> clusterNodes() {
        this.client.clusterNodes();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> clusterMeet(String ip, int port) {
        this.client.clusterMeet(ip, port);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> clusterAddSlots(int ... slots) {
        this.client.clusterAddSlots(slots);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> clusterDelSlots(int ... slots) {
        this.client.clusterDelSlots(slots);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> clusterInfo() {
        this.client.clusterInfo();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<List<String>> clusterGetKeysInSlot(int slot, int count) {
        this.client.clusterGetKeysInSlot(slot, count);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<String> clusterSetSlotNode(int slot, String nodeId) {
        this.client.clusterSetSlotNode(slot, nodeId);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> clusterSetSlotMigrating(int slot, String nodeId) {
        this.client.clusterSetSlotMigrating(slot, nodeId);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> clusterSetSlotImporting(int slot, String nodeId) {
        this.client.clusterSetSlotImporting(slot, nodeId);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        this.client.pfmerge(destkey, sourcekeys);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> pfmerge(String destkey, String ... sourcekeys) {
        this.client.pfmerge(destkey, sourcekeys);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> pfcount(String ... keys) {
        this.client.pfcount(keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> pfcount(byte[] ... keys) {
        this.client.pfcount(keys);
        return this.getResponse(BuilderFactory.LONG);
    }
}

