<?php

require("BD.php");
require("uprawnienia.klasy.inc");

$sql = new Bd("localhost", "", "", "uprawnienia");
$sql->otworz();

   /***************************************************************************

   uzytkownikuprawnienia.php

   Christopher Scollo   scollo@taurix.com

   ***************************************************************************/


function wyswietlZaznaczanieUzytkownika($a_uzytkownicy)
{
    // generuj stron z list uytkownikw

    echo("<?xml version=\"1.0\"?>\n");
?>
    <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
                          "DTD/xhtml1-transitional.dtd">
    <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
      <head>
        <title>Uytkownicy i ich przywileje</title>
      </head>
      <body>
        <form method="post" action="uzytkownikuprawnienia.php">
          <select name="identyfikator">
            <?php
            foreach ($a_uzytkownicy as $s_identyfikator => $s_pelnaNazwa) {
                echo(
                    "<option value=\"$s_identyfikator\">" .
                    stripslashes(htmlspecialchars($s_pelnaNazwa)) .
                    "</option>\n"
                );
            }
            ?>
          </select>
          <br />
          <br />
          <input type="submit" name="s_akcja" value="Przegladaj" />
          <input type="submit" name="s_akcja" value="Wyjscie" />
        </form>
      </body>
    </html>
<?php
} // koniec funkcji wyswietlZaznaczanieUzytkownika()


function wyswietlUprawnienia($o_uzytkownik, $a_uprawnienia) 
{
    // generuj stron przydzielania uprawnie

    echo("<?xml version=\"1.0\"?>\n");
?>
    <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" 
                          "DTD/xhtml1-transitional.dtd">
    <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
      <head>
        <title>Uprawnienia Uytkownika</title>
      </head>
      <body>
        <h1>
          Uprawnienia uytkownika
          <?php 
          echo(stripslashes(htmlspecialchars($o_uzytkownik->pobierzPelnaNazwe()))); ?>
        </h1>
        <form method="post" action="uzytkownikuprawnienia.php">
          <input type="hidden" name="identyfikator" 
                 value="<?php echo($o_uzytkownik->pobierzIdentyfikator()); ?>" />
          <?php
          foreach ($a_uprawnienia as $i_idUprawnienia => $s_Opis) {
              echo(
                  "<input type=\"checkbox\" name=\"id_uprawnienia[]\"
                          value=\"$i_idUprawnienia\"" .
                  // zaznacz pole wyboru, jeeli uytkownik posiada dane uprawnienie
                  ($o_uzytkownik->posiadaUprawnienie($i_idUprawnienia) ? " 
                  checked=\"checked\"" : "") .
                  " />" . stripslashes(htmlspecialchars($s_Opis)) .
                  "<br />\n"
              );
          }
          ?>
          <br />
          <br />
          <input type="submit" name="s_akcja" value="Zapisz" />
          <input type="submit" name="s_akcja" value="Anuluj" />
        </form>
      </body>
    </html>
<?php
} // koniec funkcji wyswietlUprawnienia()

function pobierzUzytkownikow() 
{
    // zwraca tablic zawierajc wszytskich uytkownikw systemu

    global $sql;

    $a_zwracana = array();

    $sql->zapytaj("SELECT identyfikator, pelna_nazwa FROM Uzytkownik");

    while ($wiersz = $sql->pobierzObiekt()) {
        $a_zwracana[$wiersz->identyfikator] = $wiersz->pelna_nazwa;
    }
    return $a_zwracana;
} // koniec funkcji pobierzUzytkownikow()

function pobierzUprawnienia() 
{
    // zwraca tablic uprawnie zdefiniowanych w systemie

    global $sql;

    $a_zwracana = array();

    $sql->zapytaj("SELECT * FROM Uprawnienie ORDER BY id_uprawnienia");

    while ($wiersz = $sql->pobierzObiekt()) {
        $a_zwracana[(int)$wiersz->id_uprawnienia] = $wiersz->opis;
    }
    return $a_zwracana;
} // koniec funkcji pobierzUprawnienia()


function sprawdz() 
{
    // sprawd dane uytkownika i utwrz reprezentujcy go obiekt globalny

    global $id_uzytkownika, $identyfikator, $o_uzytkownik;

    if ($identyfikator) {
        // upewnij si, czy podany identyfikator jest ident. dopuszczalnym:
        $o_uzytkownik = new Uzytkownik(addslashes($identyfikator));
        if (!$o_uzytkownik->uzytkownikIstnieje) return 0;
        if ($id_uprawnienia) {
            if (is_array($id_uprawnienia)) {
                foreach ($id_uprawnienia as $i_idUzytkownika) {
                    // sprawd, czy uprawnienie naley do zbioru uprawnie:
                    $o_uprawnienie = new Uprawnienie((int)$i_idUprawnienia);
                    if (!$o_uprawnienie->uprawnienieIstnieje) return 0;
                }
            } else {
                return 0;
            }
        } else {
            $id_uprawnienia = array();
        }
    }
    return 1;
} // koniec funkcji sprawdz()
  
function zapisz()
{
    // zapisz biece ustawienia

    global $id_uprawnienia, $o_uzytkownik, $sql;

    $b_zwracany = 1;

    // usu wszystkie uprawnienia uytkownika
    $s_identyfikator = $o_uzytkownik->pobierzIdentyfikator();
    $sql->zapytaj("DELETE FROM UzytkownikUprawnienie WHERE identyfikator='$s_identyfikator'");

    // dodaj z powrotem zaznaczone uprawnienia
    foreach ($id_uprawnienia as $i_idUprawnienia) {
        if (!$o_uzytkownik->dodajUprawnienie($i_idUprawnienia)) $b_zwracany = 0;
    }

    return $b_zwracany;
} // koniec funkcji zapisz()


function glowna($s_akcja) 
{
    // sterowanie przepywem programu

    if (!sprawdz()) return;

    switch ($s_akcja) {
    case "":
        // pierwsze adowanie strony
        
    case "Anuluj":
        wyswietlZaznaczanieUzytkownika(pobierzUzytkownikow());
        break;

    case "Wyjscie":
        header("Location: indeks.php");
        exit;

    case "Przegladaj":
        if ($o_uzytkownik = $GLOBALS["o_uzytkownik"]) {
            wyswietlUprawnienia($o_uzytkownik, pobierzUprawnienia());
        }
        break;

    case "Zapisz":
        zapisz();
        wyswietlZaznaczanieUzytkownika(pobierzUzytkownikow());
        break;

    default:
        // niedozwolona akcja
        proba_wlamania();

    }

} // koniec funkcji glowna()

glowna($s_akcja);
?>