<?php

require("BD.php");
require("uprawnienia.klasy.inc");

$sql = new BD("localhost", "", "", "uprawnienia");
$sql->otworz();

   /***************************************************************************

   uprawnienia.php

   Christopher Scollo   scollo@taurix.com

   ***************************************************************************/

//   deklaracje funkcji:


function wyswietlZaznaczanie($a_uprawnienia) 
{
    // wywietl list uprawnie do wyboru

    echo("<?xml version=\"1.0\"?>\n");
?>

    <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "DTD/xhtml1-transitional.dtd">
    <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
      <head>
        <title>Uprawnienia</title>
      </head>
      <body>
        <form method="post" action="uprawnienia.php">
          <select name="id_uprawnienia">
            <?php
            foreach ($a_uprawnienia as $i_idUprawnienia => $s_Opis) {
                echo(
                    "<option value=\"$i_idUprawnienia\">" .
                    stripslashes(htmlspecialchars($s_Opis)) .
                    "</option>\n"
                );
            }
            ?>
          </select>
          <br />
          <br />
          <input type="submit" name="s_akcja" value="Dodaj" />
          <input type="submit" name="s_akcja" value="Zmien" />
          <input type="submit" name="s_akcja" value="Wyjscie" />
        </form>
      </body>
    </html>

<?php

} // koniec funkcji wyswietlZaznaczanie()


function wyswietlSzczegoly($o_uprawnienie) 
{
    // generuj stron dla wybranego uprawnienia

    echo("<?xml version=\"1.0\"?>\n");
?>

    <!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "DTD/xhtml1-transitional.dtd">
    <html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en">
      <head>
        <title>Uprawnienia</title>
      </head>
      <body>
        <form method="post" action="uprawnienia.php">
          <input type="hidden" name="id_uprawnienia" 
                 value="<?php echo($o_uprawnienie->pobierzIdUprawnienia()); ?>" />
          <h3>Opis:</h3>
          <input
            type="text"
            name="opis"
            value="<?php echo(stripslashes(htmlspecialchars(
                              $o_uprawnienie->pobierzOpis()))); ?>"
            size="50"
            maxlength="50"
          />
          <br />
          <br />
          <input type="submit" name="s_akcja" value="Zapisz" />
          <input type="submit" name="s_akcja" value="Usun" />
          <input type="submit" name="s_akcja" value="Anuluj" />
        </form>
      </body>
    </html>

<?php

} // koniec funkcji wyswietlSzczegoly()


function pobierzUprawnienia() 
{
    // zwraca tablic zawierajc wszystkie uprawnienia

    global $sql;

    $a_zwracana = array();

    $sql->zapytaj("SELECT * FROM Uprawnienie ORDER BY id_uprawnienia");

    while ($wiersz = $sql->pobierzObiekt()) {
        $a_zwracana[(int)$wiersz->id_uprawnienia] = $wiersz->opis;
    }

    return $a_zwracana;
} // koniec funkcji pobierzUprawnienia()


function sprawdz() 
{
    // sprawd poprawno danych formularza

    global $id_uprawnienia, $opis, $o_uprawnienie;

    if ($id_uprawnienia) {
        // sprawd poprawno identyfikatora uprawnienia
        $o_uprawnienie = new Uprawnienie((int)$id_uprawnienia);
        if (!$o_uprawnienie->uprawnienieIstnieje) return 0;
    } else {
        $id_uprawnienia = 0;
        $o_uprawnienie = new Uprawnienie();
    }
    return 1;

} // koniec funkcji sprawdz()


function zapisz()
{
    // zapisz uprawnienie

    global $o_uprawnienie, $opis;
    $o_uprawnienie->ustawOpis(addslashes($opis));
    
    if ($o_uprawnienie->uprawnienieIstnieje) {
        if (!$o_uprawnienie->aktualizuj()) return 0;
    } else {
        if (!$o_uprawnienie->tworz()) return 0;
    }
    return 1;

} // koniec funkcji zapisz()


function usun($o_uprawnienie)
{
    // usun wybrane uprawnienie

    if ($o_uprawnienie->uprawnienieIstnieje) {
        return $o_uprawnienie->usun();
    }
    return 0;

} // koniec funkcji usun()


function glowna($s_akcja) 
{
    // przepyw sterowania programem

    if (!sprawdz()) return;


    switch($s_akcja) {


    case "":

    case "Anuluj":
        wyswietlZaznaczanie(pobierzUprawnienia());
        break;

    case "Wyjscie":
        header("Location: indeks.php");
        exit;

    case "Dodaj":
        $o_uprawnienie = new Uprawnienie();
        wyswietlSzczegoly($o_uprawnienie);
        break;

    case "Zmien":
        wyswietlSzczegoly($GLOBALS["o_uprawnienie"]);
        break;

    case "Zapisz":
        zapisz();
        wyswietlZaznaczanie(pobierzUprawnienia());
        break;

    case "Usun":
        usun($GLOBALS["o_uprawnienie"]);
        wyswietlZaznaczanie(pobierzUprawnienia());
        break;

    default:
        // niepoprawny parametr $s_akcja
        proba_wlamania();
    }

} // koniec funkcji glowna()


glowna($s_akcja);
?>