<?php

/***************************************************************************

      Christopher Scollo  scollo@taurix.com

uprawnienia.klasy.inc

   Klasy:
   Uprawnienie
   Uzytkownik

***************************************************************************/

class Uprawnienie
{
    // deklaracje skadowych:

    var $idUprawnienia;
    var $opis;
    var $uprawnienieIstnieje = 0;

    // deklaracje metod:

    function Uprawnienie($i_idUprawnienia = 0) 
    {
        // konstruktor

        if ($i_idUprawnienia) $this->wypelnijUprawnienie($i_idUprawnienia);
    } // koniec metody Uprawnienie()


    function wypelnijUprawnienie($i_idUprawnienia) 
    {
        // wypenij dane uprawnienia

        global $sql;

        $sql->zapytaj("SELECT * FROM Uprawnienie WHERE id_uprawnienia=$i_idUprawnienia");

        $wiersz = $sql->pobierzObiekt();

        $this->ustawOpis($wiersz->opis);
        $this->uprawnienieIstnieje = 1;
        
        $this->ustawIdUprawnienia($i_idUprawnienia);
        return $this->uprawnienieIstnieje;

    } // koniec metody wypelnijUprawnienie()


    function tworz() 
    {
        // dodaj nowe uprawnienie do bazy danych

        global $sql;

        $s_Opis = $this->pobierzOpis();
        $sql->zapytaj("INSERT INTO Uprawnienie (opis) VALUES ('$s_Opis')");
    } // koniec metody tworz()


    function usun() 
    {
        // usu uprawnienie z bazy danych

        global $sql;
 
        $i_idUprawnienia = $this->pobierzIdUprawnienia();
        if (!$i_idUprawnienia) return;

        // najpierw usu wpis kojarzcy z tabeli UzytkownikUprawnienie
        $sql->zapytaj("DELETE FROM UzytkownikUprawnienie WHERE id_uprawnienia=$i_idUprawnienia");

        // usu wpis z tabeli uprawnienie
        $sql->zapytaj("DELETE FROM Uprawnienie WHERE id_uprawnienia = $i_idUprawnienia");

        $this->uprawnienieIstnieje= 0;
    } // koniec metody usun()


    function aktualizuj()
    {
        // modyfikuj wpis uprawnienia w bazie danych

        global $sql;

        $i_idUprawnienia = $this->pobierzIdUprawnienia();
        $s_Opis = $this->pobierzOpis();
        if (!$i_idUprawnienia) return 0;

        $sql->zapytaj("UPDATE Uprawnienie SET opis='$s_Opis' WHERE id_uprawnienia = $i_idUprawnienia");
    } // koniec metody aktualizuj()


    function pobierzIdUprawnienia() 
    {
        // zwraca warto skadowej

        return $this->idUprawnienia;
    } // koniec metody pobierzIdUprawnienia()


    function ustawIdUprawnienia($i_wartosc) 
    {
        // ustawia warto skadowej

        $this->idUprawnienia = (int) $i_wartosc;
        return 1;
    } // koniec metody ustawIdUprawnienia()


    function pobierzOpis() 
    {
        // zwraca warto skadowej

        return $this->opis;
    } // koniec metody pobierzOpis()


    function ustawOpis($s_wartosc)
    {
        // ustaw warto skadowej

        if (strlen ($s_wartosc) > 50) return 0;
        $this->opis = $s_wartosc;
        return 1;
    } // koniec metody ustawOpis()


} // koniec klasy Uprawnienie

/***************************************************************************/

class Uzytkownik
{
   // deklaracje skadowych:

    var $identyfikator;
    var $pelnaNazwa;
    var $uprawnienia;
    var $uzytkownikIstnieje = 0;


   // deklaracje metod:


    function Uzytkownik($s_identyfikator = "") 
    {
        // konstruktor

        if ($s_identyfikator) $this->wypelnijUzytkownika($s_identyfikator);
    } // koniec metody Uzytkownik()


    function wypelnijUzytkownika($s_identyfikator) 
    {
        // zainicjuj wartoci skadowych obiektu

        global $sql;

        $sql->zapytaj("SELECT * FROM Uzytkownik WHERE identyfikator='$s_identyfikator'");

        $wiersz = $sql->pobierzObiekt();

        $this->ustawPelnaNazwe($wiersz->pelna_nazwa);
        $this->uzytkownikIstnieje = 1;

        $this->ustawIdentyfikator($s_identyfikator);
        return $this->uzytkownikIstnieje;

    } // koniec metody wypelnijUzytkownika()


    function wypelnijUprawnienia()
    {
        // wypenij tabel uprawnie uytkownika

        global $sql;

        $sql->zapytaj("SELECT id_uprawnienia FROM UzytkownikUprawnienie WHERE identyfikator='" . $this->pobierzIdentyfikator() . "'");
        
        $this->uprawnienia = array(); // usu ew. istniejce elementy tablicy
        
        while ($wiersz = $sql->pobierzObiekt()) {
            $this->uprawnienia[] = $wiersz->id_uprawnienia;
        }
    } // koniec metody wypelnijUprawnienia()


    function dodajUprawnienie($i_idUprawnienia)
    {
        // przyznaj uytkownikowi nowe uprawnienie

        global $sql;

        // upewnij si, czy uytkownik nie ma ju danego uprawnienia:
        if ($this->posiadaUprawnienie($i_idUprawnienia)) return;

        // upewnij si, e uprawnienie jest poprawne:
        $o_uprawnienie = new Uprawnienie($i_idUprawnienia);
        if (!$o_uprawnienie->uprawnienieIstnieje) return;

        // dodaj uprawnienie:
        $s_identyfikator = $this->pobierzIdentyfikator();

        $sql->zapytaj("INSERT INTO UzytkownikUprawnienie VALUES ('$s_identyfikator', $i_idUprawnienia)");

        $this->uprawnienia[] = $i_idUprawnienia;
    } // koniec metody dodajUprawnienie()


    function usunUprawnienie($i_idUprawnienia)
    {
        // odbierz uprawnienie uytkownikowi

        global $sql;

        // upewnij si, czy uytkownik posiada odbierane uprawnienie:
        if (!$this->posiadaUprawnienie($i_idUprawnienia)) return;

        $s_identyfikator = $this->pobierzIdentfikator();
        $sql->zapytaj("DELETE from UzytkownikUprawnienie WHERE id_uprawnieniea=$i_idUprawnienia AND identyfikator='$s_identyfikator'");

        $i_indeks = array_search($i_idUprawnienia, $this->uprawnienia);
        unset($this->uprawnienia[$i_indeks]);
    } // koniec metody usunUprawnienie()


    function posiadaUprawnienie($i_idUprawnienia)
    {
        // sprawd, czy uytkownik posiada uprawnienie

        // zainicjuj uprawnienia:
        if (!is_array($this->uprawnienia)) $this->wypelnijUprawnienia();

        return in_array($i_idUprawnienia, $this->uprawnienia);
    } // koniec metody posiadaUprawnienie()


    function tworz() 
    {
        // dodaj nowego uytkownika do bazy danych

        global $sql;

        $s_identyfikator = $this->pobierzIdentyfikator();
        $s_pelnaNazwa = $this->pobierzPelnaNazwe();

        $sql->zapytaj("INSERT INTO Uzytkownik VALUES ('$s_identyfikator', '$s_pelnaNazwa')");
    } // koniec metody tworz()


    function aktualizuj() 
    {
        // aktualizuj wpis uytkownika w bazie danych

        global $sql;

        $s_identyfikator = $this->pobierzIdentyfikator();
        $s_pelnaNazwa = $this->pobierzPelnaNazwe();

        $sql->zapytaj("UPDATE Uzytkownik SET pelna_nazwa='$s_pelnaNazwa' WHERE identyfikator='$s_identyfikator'");
    } // koniec metody aktualizuj()


    function usun() 
    {
        // usu uytkownika z bazy danych

        global $sql;

        $s_identyfikator = $this->pobierzIdentyfikator();

        // po pierwsze usu wpis z tabeli UzytkownikUprawnienie
        $sql->zapytaj("DELETE FROM UzytkownikUprawnienie WHERE identyfikator='$s_identyfikator'");

        // usu wpis z tabeli Uzytkownik
        $sql->zapytaj("DELETE FROM Uzytkownik WHERE identyfikator='$s_identyfikator'");

        $this->uzytkownikIstnieje = 0; 
    } // koniec metody usun()


    function pobierzIdentyfikator() 
    {
        // zwraca warto skadowej

        return $this->identyfikator;
    } // koniec metody pobierzIdentyfikator()


    function ustawIdentyfikator($s_wartosc) 
    {
        // ustaw warto skadowej

        // Dopuszczalne s znaki alfanumeryczne i podkrelenia, dugo cigu od 5 do 10 znakw
        if (!ereg("^[a-zA-Z0-9_]{5,10}$", $s_wartosc)) return 0;
        $this->identyfikator = $s_wartosc;
        return 1;
    } // koniec metody ustawIdentyfikator()


    function pobierzPelnaNazwe() 
    {
        // zwraca warto skadowej

        return $this->pelnaNazwa;
    } // koniec metody pobierzPelnaNazwe()


    function ustawPelnaNazwe($s_wartosc) 
    {
        // ustaw warto skadowej

        if (strlen($s_wartosc) > 50) return 0;
        $this->pelnaNazwa = $s_wartosc;
        return 1;
    } // koniec metody ustawPelnaNazwe()

} // koniec klasy Uzytkownik

?>
