<?php

function zliczOdwiedziny($nazwaPliku) 
{
    //po pierwsze sprawd, czy mona otworzy plik rejestru odwiedzin
    if (!$plik = fopen($nazwaPliku, "r+")) {
        echo("Bd otwarcia pliku $nazwaPliku\n");
        exit;
    }

    //pobierz liczb odwiedzin z pliku
    if (!$odwiedziny = fread($plik, filesize($nazwaPliku))) {
        echo("Bd odczytu liczby odwiedzin z pliku $nazwaPliku\n");
        exit;
    }

    //zwiksz liczb odwiedzin
    $odwiedziny++;

    //cofnij si do pocztku pliku
    if (rewind($plik) == 0) {
        echo("Nie mog przewin pliku");
        exit;
    }

    //zapisz now warto licznika do pliku
    //skorzystaj z funkcji flock(), aby upewni si, e aden 
    //inny proces nie prbuje w tej samej chwili modyfikowa pliku
    if (flock($plik, 2)) {
        if (!fwrite($plik, $odwiedziny, strlen($odwiedziny))) {
            echo("Nie mona zapisa nowej wartoci licznika odwiedzin w pliku $nazwaPliku");
            exit;
        }
    }

    flock($plik, 3);

    //twrz rysunek
    $rysunek = makeImage($odwiedziny);

    //twrz znacznik <img> strony
    //uwzgldnij przegldarki nie wywietlajce rysunkw
    $licznik = "<img src=\"$rysunek\" alt=\"Liczba odwiedzin: $odwiedziny\">";

    return $licznik;
}

function makeImage($liczba) 
{
    $rysunek = "./odwiedziny.png";

    //ustaw zmienne okrelajce szeroko i wysoko rysunku
    $odwDlugosc = strlen($liczba);
    $wysZnaku = ImageFontHeight(5);
    $szerZnaku = ImageFontWidth(5);
    $szerNapisu = $szerZnaku * $odwDlugosc;

    //rozszerz rysunek tak, aby nie obejmowa zbyt ciasno napisu
    $szerRysunku = $szerNapisu + 10;
    $wysRysunku = $wysZnaku + 10;

    //poszukaj punktu rodkowego rysunku
    $srodekX = $szerRysunku / 2;
    $srodekY = $wysRysunku / 2;

    //utwrz nowy rysunek i przypisz jego identyfikator do zmiennej $i
    $i = ImageCreate($szerRysunku, $wysRysunku);

    //ustaw dla rysunku kilka kolorw
    //$bialy najpierw - bdzie on kolorem ta rysunku
    //Napis bdzie mia kolor czarny, otoczka - czerwony
    $bialy = ImageColorAllocate($i, 255, 255, 255);
    $czerwony = ImageColorAllocate($i, 255, 0, 0);
    $czarny = ImageColorAllocate($i, 0, 0, 0);

    //efekt cienia uzyskany za porednictwem dwch prostoktw
    ImageFilledRectangle($i, 3, 3, $szerRysunku, $wysRysunku, $czarny);
    ImageFilledRectangle($i, 0, 0, $szerRysunku - 3, $wysRysunku - 3, $czerwony);

    //wyszukaj pozycj pocztkow napisu
    $napisX = $srodekX - ($szerNapisu/ 2) + 1;
    $napisY = $srodekY - ($wysZnaku / 2);

    //umie napis na rysunku
    ImageString($i, 4, $napisX, $napisY, $liczba, $czarny);

    //zapisz rysunke w pliku PNG
    ImagePng($i, $rysunek);

    //zwr ciek dla znacznika <img>
    return $rysunek;
}
?>