<?php

function formatuj($liczba) 
{
    //umie tabeli parametrw lokalizacyjnych w zmiennych lokalnych funkcji
    extract(localeconv());

    // rozpocznij od sformatowania liczby bez znaku
    $l = number_format(abs($liczba),
                            $frac_digits,
                            $mon_decimal_point,
                            $mon_thousands_sep);

    if ($liczba < 0) {
        $znak = $negative_sign;
        //ponisze wyraenia zwracaj wartoci logiczne jako liczby cakowite
        $n_cs_precedes  = intval($n_cs_precedes  == true);
        $n_sep_by_space = intval($n_sep_by_space == true);
        $klucz = $n_cs_precedes . $n_sep_by_space . $n_sign_posn;
    } else {
        $znak = $positive_sign;
        $p_cs_precedes  = intval($p_cs_precedes  == true);
        $p_sep_by_space = intval($p_sep_by_space == true);
        $klucz = $p_cs_precedes . $p_sep_by_space . $p_sign_posn;
    }

    $formaty = array(
        // Symbol waluty za liczb
        // brak spacji pomidzy wartoci a znakiem.
        '000' => '(%s' . $currency_symbol . ')',
        '001' => $znak . '%s ' . $currency_symbol,
        '002' => '%s' . $currency_symbol . $znak,
        '003' => '%s' . $znak . $currency_symbol,
        '004' => '%s' . $znak . $currency_symbol,

        // jedna spacja pomidzy wartoci a znakiem.
        '010' => '(%s ' . $currency_symbol . ')',
        '011' => $znak . '%s ' . $currency_symbol,
        '012' => '%s ' . $currency_symbol . $znak,
        '013' => '%s ' . $znak . $currency_symbol,
        '014' => '%s ' . $znak . $currency_symbol,

        // Symbol waluty przez wartoci 
        // Bez spacji pomidzy wartoci a znakiem.
        '100' => '(' . $currency_symbol . '%s)',
        '101' => $znak . $currency_symbol . '%s',
        '102' => $currency_symbol . '%s' . $sign,
        '103' => $znak . $currency_symbol . ' %s',
        '104' => $currency_symbol . $znak . '%s',

        // Jedna spacja pomidzy wartoci a znakiem.
        '110' => '(' . $currency_symbol . ' %s)',
        '111' => $znak . $currency_symbol . ' %s',
        '112' => $currency_symbol . ' %s' . $znak,
        '113' => $znak . $currency_symbol . ' %s',
        '114' => $currency_symbol . ' ' . $znak . '%s');

    // wyszukiwanie w tablicy wedug klucza.
    return sprintf($formaty[$klucz], $l);

}

setlocale("LC_ALL", $locale);
echo(formatuj(123.45));
?>
