<?php

class Aplikacja
{
    var $wyjscie;
    var $dostepne_jezyki;

    //Konstruktor inicjalizuje tablic dostpnych jzykw i wybiera najlepiej pasujcy. 
    function Aplikacja() 
    {
        $this->dostepne_jezyki = array('en', 'pl', 'da');
        $this->ustawJezyk($this->najlepszyJezyk());
    }

    // W zalenoci od zawartoci tablicy $dostepne_jezyki i wartoci pola Accept-Language,
    // funkcja zwraca kod jzyka najlepiej przystosowanego do oczekiwa przegldarki.
    function najlepszyJezyk() 
    {
        $akceptowane_jezyki = explode(', ', $GLOBALS['HTTP_ACCEPT_LANGUAGE']);

        while (list($klucz, $jezyk) = each($akceptowane_jezyki)) {
            if (in_array($jezyk, $this->dostepne_jezyki)) {
                return $jezyk;
            }
        }
        return reset($this->dostepne_jezyki);
    }

    // przeczenie jzyka przez utworzenie nowego obiektu wyjciowego.
    function ustawJezyk($nowy_jezyk = '') 
    {
        switch ($nowy_jezyk) {
        case 'en':
            $this->wyjscie = new WyjscieAngielski();
            break;
       
        case 'da':
            $this->wyjscie = new WyjscieDunski();
            break;
       
        case 'pl':
            $this->wyjscie = new WyjsciePolski();
            break;
       
        default:
            $this->ustawJezyk($this->najlepszyJezyk);
            break;
        }
    }
}

// klasa bazowa klasy wyjciowej.
class Wyjscie
{
    var $ciagi;

    function _($ciag)
    {
        if (isset($this->ciagi[$ciag])) {
            return $this->ciagi[$ciag];
        } else {
            return $ciag;
        }
    }

    function gettext($ciag)
    {
        return $this->_($ciag);
    }

    // Podstawowa wersja metody wyswietlLiczbePlikow().
    function wyswietlLiczbePlikow($liczba) 
    {
        if ($liczba == 0) {
            return $this->gettext("No files.");
        } elseif ($liczba == 1) {
            return $this->gettext("1 file.");
        } else {
            return sprintf($this->gettext("%s files."), $liczba);
        }
    } 

    // zwraca zestaw znakw.
    function zestawZnakow() 
    {
        return $this->ciagi['charset'];
    }
}

class WyjscieAngielski extends Wyjscie
{
    // Konstruktor inicjalizuje tablic $ciagi odpowiednimi
    // zestawami znakw. Pozostae cigi zdefiniowane s w Wyjscie.
    function WyjscieAngielski() 
    {
        $this->ciagi = array(
            'charset' => 'ISO-8859-1');
    }
}

class WyjscieDunski extends Wyjscie
{
    function WyjscieDunski() 
    {
        $this->ciagi = array(
            'No files.' => 'Ingen filer.',
            '1 file.'   => '1 fil.',
            '%s files.' => '%s filer.',
            'charset'   => 'ISO-8859-1');
    }
}

class WyjsciePolski extends Wyjscie
{
    function WyjsciePolski()
    {
        $this->ciagi = array(
            'charset' => 'ISO-8859-2');
    }

    function wyswiwetlLiczbePlikow($liczba) 
    {
        if ($liczba == 0) {
            return "Nie ma plikw.";
        } elseif ($liczba == 1) {
            return "1 plik.";
        } elseif ($liczba <= 4) {
            return "$liczba pliki.";
        } elseif ($liczba <= 21) {
            return "$liczba plikw.";
        } else {
            $ostatnie_cyfra = substr($liczba, -1);
            if ($ostatnie_cyfra >= 2 && $ostatnia_cyfra <= 4) {
                return "$liczba pliki.";
            } else {
                return "$liczba plikw.";
            }
        }
    }
}

$obiekt = new Aplikacja();

header('Content-Type: text/html; charset=' . $obiekt->wyjscie->zestawZnakow());
?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN"
             "http://www.w3.org/TR/REC-html40/loose.dtd">
<html>
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=<?php
    echo($obiekt->wyjscie->zestawZnakow()); ?>">
    <title>Aplikacja</title>
  </head>
  <body>

  <?php
  echo("<p>" . $obiekt->wyjscie->wyswietlLiczbePlikow(7) . "</p>\n");
  ?>

  </body>
</html>
