<?php

$diag = 1; // Ustawienie na 1 wcza diagnostyk, 0 - wycza.
?>

<html>
  <head>
    <title>Demonstracja dziaania SAX API</title>
  </head>
  <body>
    <h1>Oferty biura podry</h1>
    <table border="0" cellpadding="0">

      <?php
      //Lokalizacja dokumentu XML
      $plik = "./podroze.xml";
      
      //zmienne 'biezace' identyfikuj aktualnie parsowany znacznik (atrybut)
      $biezacyZnacznik = "";
      $biezaceAtrybuty = "";

      function znacznikOtwierajacy($parser, $nazwa, $atrybuty) 
      {
          global $biezacyZnacznik, $biezaceAtrybuty;
          $biezacyZnacznik = $nazwa;
    
          $biezaceAtrybuty = $atrybuty;
          //przypisanie znacznikw HTML do znacznikw XML.
          switch ($nazwa) {
          case "OfertyPodrozy":
              break;
    
          case "Oferta":
              while (list ($klucz, $wartosc) = each ($atrybuty)) {
                  echo("<tr><td>$klucz: $wartosc</td></tr>\n");
              }
              break;

          case "Turnus":
              break;

          default:
              echo("<tr><td>$nazwa</td><td>\n");
              break;
          }
      }

      function znacznikZamykajacy($parser, $nazwa) 
      {
          global $biezacyZnacznik;
          //zamykajce znaczniki HTML
          switch ($nazwa) {
          case "Oferta":
              echo("<tr><td colspan=\"2\"><hr></td></tr>\n");
              break;

          default:
              echo("</td></tr>\n");
              break;
          }
          //zerowanie zmiennych "biecych"
          $biezacyZnacznik = "";
          $biezaceAtrybuty = "";
      }

      //przetwarzanie danych znajdujcych si pomidzy znacznikami
      function daneZnakowe($parser, $dane) 
      {
          global $biezacyZnacznik;
          //dodaj do wartoci znaczniki HTML
          switch ($biezacyZnacznik) {
          case "Kraj":
              echo("<a href=\"#\">$dane</a>\n");
              break;
          default:
              echo($dane);
              break;
          }
      }

     //inicjalizuj parser
     $xmlParser = xml_parser_create();

     $wielkieLitery =  xml_parser_get_option($xmlParser, XML_OPTION_CASE_FOLDING);
     $kodowanie = xml_parser_get_option($xmlParser, XML_OPTION_TARGET_ENCODING);

      if ($diag > 0) {
          echo("Diagnostyka: $diag<br>\n");
          echo("Due litery: $wielkieLitery<br>\n");
          echo("Kodowanie: $kodowanie<br>\n");
      }
      //wycz duze litery
      if ($wielkieLitery == 1) {
          xml_parser_set_option($xmlParser, XML_OPTION_CASE_FOLDING, false);
      }

      //funkcje obsugi
      xml_set_element_handler($xmlParser, "znacznikOtwierajacy", "znacznikZamykajacy");
      xml_set_character_data_handler($xmlParser, "daneZnakowe");

      //otwrz plik XML
      if (!($p = fopen($plik, "r"))) {
          die("Nie mona otworzy pliku rdowego XML: $plik");
      }

      //wczytaj i parsuj zawarto pliku
      while ($dane = fread($p, 4096)) {
          //obsuga bdw
          if (!xml_parse($xmlParser, $dane, feof($p))) {
              die(sprintf("Bd XML: %s w wierszu %d",
                          xml_error_string(xml_get_error_code($xmlParser)),
                          xml_get_current_line_number($xmlParser)));
              xml_parser_free($xmlParser);
          }
      }
      //zwolnij parser
      xml_parser_free($xmlParser);
      ?>
    </table>
  </body>
</html>
