<?php

//Ustaw zmienn diag na 0, jeeli nie chcesz wywietla wszystkich 
// komunikatw przetwarzania albo na 1 jeeli chcesz oglda wszystkie te komunikaty
$diag = "1";
global $diag;
?>

<html>
  <head>
    <title>PRAX - Demonstracja Dziaania</title>
  </head>
  <body>
    <?php
    print("<h1>Oferty podry</h1>\n");

    //Wczenie do kodu biblioteki PRAX
    include("PRAX.php");

    //Wywietl dokument XML
    if ($diag == "1") {
        print("<b>Przetwarzany XML:</b> <pre>" . 
               htmlentities(implode("", file("./podroze_SML.xml"))) . "</pre>");
    }

    //Utwrz nowy obiekt klasy RAX
    $rax = @new RAX();

    //Otwrz plik XML
    @$rax->openfile("./podroze_SML.xml");

    //Ustaw ogranicznik rekordu, penicy rol podobn do wiersza tabeli
    @$rax->record_delim = 'Turnus';

    //Rozpocznij parsowanie dokumentu
    @$rax->parse();

    //Odczytaj pierwszy rekord
    $rekord = @$rax->readRecord();

    //Nazwy pl
    if ($diag == "1") {
        print("<b>\$rekord->getFieldnames()</b>" . "<blockquote>" .  
               join("<br />", @$rekord->getFieldnames()) . "</blockquote>");
    }
    //Wartoci pl
    if ($diag == "1") {
        print("<b>\$rekord->getFields()</b>" . "<blockquote>" .  
               join("<br />", @$rekord->getFields()) . "</blockquote>");
    }

    echo("<table cellpadding=\"0\" border=\"0\">\n");

    while ($rekord) {
        $wiersz = @$rekord->getRow();
        echo("<tr><td>Kraj</td><td>" . 
              $wiersz["Kraj"] . "</td></tr>\n");
        echo("<tr><td>Miasto</td><td>" . $wiersz["Miasto"] . "</td></tr>\n");
        echo("<tr><td>Osrodek</td><td>" . $wiersz["Osrodek"] . "</td></tr>\n");
        echo("<tr><td>Osrodek_gwiazdki</td><td>" . 
              $wiersz["Osrodek_gwiazdki"] . "</td></tr>\n");
        echo("<tr><td>Osrodek_rodzajAtrakcji</td><td>" . 
              $wiersz["Osrodek_rodzajAtrakcji"] . "</td></tr>\n");
        echo("<tr><td>Osrodek_sportyWodne</td><td>" . 
              $wiersz["Osrodek_sportyWodne"] . "</td></tr>\n");
        echo("<tr><td>Osrodek_posilki</td><td>" . 
              $wiersz["Osrodek_posilki"] . "</td></tr>\n");
        echo("<tr><td>Osrodek_napoje</td><td>" . 
              $wiersz["Osrodek_napoje"] . "</td></tr>\n");
        echo("<tr><td colspan=2><hr></td></tr>\n");
        $rekord = @$rax->readRecord();
    }
    echo("</table>\n");
    ?>
  </body>
</html>
