<?php

//Interfejs aplikacji biblioteki sieciowej
//Funkcje tworzenia okien
 
function utworzOknoGlowne() 
{
    GLOBAL $okna;
    GLOBAL $widgety;
    GLOBAL $rozlacz_id;

    $okna['glowne'] = &new GtkWindow();
    $okna['glowne']->set_policy(true, false, true);
    $okna['glowne']->set_position(GTK_WIN_POS_CENTER);
    $okna['glowne']->set_title("Aplikacja biblioteki sieciowej");
    $rozlacz_id = $okna['glowne']->connect("destroy", "zamknij_okno");

    $widgety['glowny']['tabela'] = &new GtkTable(5, 2, false);
    
    $widgety['glowny']['identyfikator'] = &new GtkEntry();
    $widgety['glowny']['haslo'] = &new GtkEntry();
    $widgety['glowny']['haslo']->set_visibility(false);
    $widgety['glowny']['haslo']->connect('activate', 'loguj');

    $widgety['glowny']['ident_etkt'] = &new GtkLabel('Identyfikator: ');
    $widgety['glowny']['haslo_etkt'] = &new GtkLabel('Haslo: ');

    $widgety['glowny']['loguj_p'] = &new GtkButton('Zaloguj');
    $widgety['glowny']['loguj_p']->connect('clicked', 'loguj');

    $widgety['glowny']['tabela']->attach($widgety['glowny']['ident_etkt'], 0, 1, 1, 2);
    $widgety['glowny']['tabela']->attach($widgety['glowny']['haslo_etkt'], 0, 1, 3, 4);
    $widgety['glowny']['tabela']->attach($widgety['glowny']['identyfikator'], 1, 2, 1, 2);
    $widgety['glowny']['tabela']->attach($widgety['glowny']['haslo'], 1, 2, 3, 4);
    $widgety['glowny']['tabela']->attach($widgety['glowny']['loguj_p'], 0, 2, 4, 5);

    $okna['glowne']->add($widgety['glowny']['tabela']);
    $okna['glowne']->show_all();
}

function utworzOknoWyszukiwania()
{
    GLOBAL $okna;
    GLOBAL $widgety;

    $okna['szukaj'] = &new GtkWindow();
    $okna['szukaj']->set_title("Aplikacja biblioteki sieciowej");
    $okna['szukaj']->connect("destroy", "zamknij_okno");

    $widgety['szukaj']['tabela'] = &new GtkTable(8, 8, false);

    $widgety['szukaj']['szukaj_etkt'] = &new GtkLabel("Szukaj:");
    $widgety['szukaj']['serie_etkt'] = &new GtkLabel("Serie:");
    $widgety['szukaj']['kryteria_etkt'] = &new GtkLabel("Kryterium:");

    $widgety['szukaj']['szukany_ciag'] = &new GtkEntry();
    $widgety['szukaj']['szukany_ciag']->connect("activate", "szukaj");

    $tablica_serii = array("Od podstaw", "Vademecum Profesjonalisty", "Dla poczatkujacych");
    $widgety['szukaj']['serie'] = &new GtkCombo();
    $widgety['szukaj']['serie']->set_popdown_strings($tablica_serii);
   
    $kryt = array("ISBN", "Autor", "Tytul");
    $widgety['szukaj']['kryterium'] = &new GtkCombo();
    $widgety['szukaj']['kryterium']->set_popdown_strings($kryt);

    $widgety['szukaj']['szukaj_p'] = &new GtkButton("Szukaj");
    $widgety['szukaj']['szukaj_p']->connect("clicked", "szukaj");

    $tytuly = array("Tytul", "Autor", "ISBN",
                    "Seria", "Egzemplarzy", "Cena");
    $wpis_tmp = array("Wyniki...", "", "", "", "", "");


    $widgety['szukaj']['wyniki'] = &new GtkCList(6, $tytuly);
    $widgety['szukaj']['wyniki']->set_column_width(0, 200);
    $widgety['szukaj']['wyniki']->set_column_width(1, 150);
    $widgety['szukaj']['wyniki']->set_column_width(2, 100);
    $widgety['szukaj']['wyniki']->set_column_width(3, 100);
    $widgety['szukaj']['wyniki']->set_column_width(5, 50);
    $widgety['szukaj']['wyniki']->prepend($wpis_tmp);

    $widgety['szukaj']['tabela']->attach($widgety['szukaj']['szukaj_etkt'], 0, 1, 0, 1);
    $widgety['szukaj']['tabela']->attach($widgety['szukaj']['serie_etkt'], 0, 1, 1, 2);
    $widgety['szukaj']['tabela']->attach($widgety['szukaj']['kryteria_etkt'], 0,1, 2, 3);
    $widgety['szukaj']['tabela']->attach($widgety['szukaj']['szukany_ciag'], 1, 2, 0, 1);
    $widgety['szukaj']['tabela']->attach($widgety['szukaj']['serie'], 1, 2, 1, 2);
    $widgety['szukaj']['tabela']->attach($widgety['szukaj']['kryterium'], 1, 2, 2, 3);
    $widgety['szukaj']['tabela']->attach($widgety['szukaj']['szukaj_p'], 0, 2, 3, 4);
    $widgety['szukaj']['tabela']->attach($widgety['szukaj']['wyniki'], 0, 2, 4, 5);


    $okna['szukaj']->add($widgety['szukaj']['tabela']);
    $okna['szukaj']->show_all();
}

//Funkcje

function szukaj()
{
    GLOBAL $okna;
    GLOBAL $widgety;

    $szukany_ciag = $widgety['szukaj']['szukany_ciag']->get_text();
    $pole_serii = $widgety['szukaj']['serie']->entry;
    $serie = $pole_serii->get_text();
    $pole_kryterium = $widgety['szukaj']['kryterium']->entry;
    $kryterium = $pole_kryterium->get_text();

    switch($kryterium)
    {
        case "ISBN":
            $pole = 'tytuly.ISBN = "' . $szukany_ciag . '"';
            break;
        case "Autor":
            $pol = 'autorzy.autor LIKE "%' . $szukany_ciag . '%"';
            break;
        case "Tytul":
        default:
            $pole = 'tytuly.tytul LIKE "%' . $szukany_ciag . '%"';          
    }

    $zapytanie = 'SELECT  tytuly.tytul, szczegoly.ISBN, cena, liczba_egzemplarzy, seria,' .
          ' autorzy.autor FROM szczegoly LEFT JOIN tytuly ON tytuly.ISBN ' .
          '= szczegoly.ISBN LEFT JOIN serie ON szczegoly.id_serii = ' .
          'serie.id_serii LEFT JOIN autortytul ON tytuly.ISBN = ' .
          'autortytul.ISBN LEFT JOIN autorzy ON autortytul.id_autora = ' .
          'autorzy.id_autora WHERE ' . $pole .
          ' AND serie.seria LIKE "' . $serie .'"';

    $wynik = mysql_query($zapytanie) or die(mysql_error());

    if(!mysql_affected_rows())
    {
        $brak_wynikow = array("Brak wynikw.", "", "", "", "", "");
        $widgety['szukaj']['wyniki']->remove(0);
        $widgety['szukaj']['wyniki']->prepend($brak_wynikow);
    } 
    else
    {
        $widgety['szukaj']['wyniki']->clear();
        while ($wiersz = mysql_fetch_array($wynik))
        {
            $tablica_wstaw = array($wiersz['tytul'], $wiersz['autor'], 
                                  $wiersz['ISBN'], $wiersz['seria'],
                                  $wiersz['liczba_egzemplarzy'], number_format($wiersz['cena'], 2));
                             
            $widgety['szukaj']['wyniki']->append($tablica_wstaw);
        }
    }
}

function loguj()
{
    GLOBAL $okna;
    GLOBAL $widgety;
    GLOBAL $pol;
    GLOBAL $rozlacz_id;
    
    if(!$pol) // Brak poczenia z serwerem MySQL
    {
        $pol = mysql_connect('localhost');//, 'Jan','tajnehaslo' );
        if (!mysql_select_db('Biblioteka')) koniec("BLAD!");
        
    }

    $uzytkownik = $widgety['glowny']['identyfikator']->get_text();
    $haslo = $widgety['glowny']['haslo']->get_text();

    $zapytanie = 'SELECT COUNT(*) AS dopasowane FROM uzytkownicy WHERE identyfikator="'
           .$uzytkownik.'" AND haslo="'.$haslo.'"';
    $wynik = mysql_query($zapytanie);

    $tablica = mysql_fetch_array($wynik);
    $okna['glowne']->disconnect($rozlacz_id);
    $okna['glowne']->destroy();

    if($tablica['dopasowane'])
        utworzOknoWyszukiwania();
    else
        koniec("Bd uwierzytelnienia.");
}

//Funkcje obsugi sygnay i funkcje narzdziowe
 
function koniec($komunikat)
{
    printf($komunikat."\n");
    gtk::main_quit();
}

function zamknij_okno()
{
    gtk::main_quit();
}

//Waciwa aplikacja
 
dl('php_gtk.'.(strstr(PHP_OS, 'WIN')?'dll':'so')) || 
die("Nie mona zaadowa moduu PHP-GTK\n");

utworzOknoGlowne();

gtk::main();
?>
