<?php

class BD
{
    // parametry poczeniowe
    var $wezel = '';
    var $uzytkownik = '';
    var $haslo = '';
    var $bazadanych= '';
    var $trwale = false;

    // identyfikator poczenia z baz danych
    var $pol = NULL;

    // wynik zapytania
    var $wynik = false;
    var $wiersz = 0;

    function BD($wezel, $uzytkownik, $haslo, $bazadanych, $trwale = false)
    {
        $this->wezel = $wezel;
        $this->uzytkownik = $uzytkownik;
        $this->haslo = $haslo;
        $this->bazadanych = $bazadanych;
        $this->trwale = $trwale;
    }

    function otworz()
    {
        // wybierz waciw funkcj poczeniow
        if ($this->trwale) {
            $funkcja = 'pg_pconnect';
        } else {
            $funkcja = 'pg_connect';
        }

        // konstrukcja cigu poczeniowego
        $ciag_pol = '';
        if (!empty($this->wezel)) {
            $ciag_pol .= 'host=' . $this->wezel . ' ';
        }
        if (!empty($this->uzytkownik)) {
            $ciag_pol .= 'user=' . $this->uzytkownik . ' ';
        }
        if (!empty($this->haslo)) {
            $ciag_pol .= 'password=' . $this->haslo . ' ';
        }
        if (!empty($this->bazadanych)) {
            $ciag_pol .= 'dbname=' . $this->bazadanych. ' ';
        }

        // nawi poczenie z serwerem PostgreSQL
        $this->pol = $funkcja($ciag_pol);
        if (!$this->pol) {
            return false;
        }

        return true;
    }

    function zamknij()
    {
        return (pg_close($this->pol));
    }

    function blad()
    {
        return (pg_errormessage());
    }

    function zapytaj($zapytanie = '')
    {
        $this->wynik = pg_exec($this->pol, $zapytanie);
        $this->wiersz = 0;

        return ($this->wynik != false);
    }

    function liczbaZmienionychWierszy()
    {
        return (pg_cmdtuples($this->wynik));
    }

    function liczbaWierszy()
    {
        return (pg_numrows($this->wynik));
    }

    function pobierzObiekt()
    {
        if ($this->wiersz >= pg_numrows($this->wynik)) {
            return false;
        }
        return (pg_fetch_object($this->wynik, $this->wiersz++, PGSQL_ASSOC));
    }

    function pobierzTablice()
    {
        if ($this->wiersz >= pg_numrows($this->wynik)) {
            return false;
        }
        return (pg_fetch_array($this->wynik, $this->wiersz++, PGSQL_NUM));
    }

    function pobierzTabliceAsocjacyjna()
    {
        if ($this->wiersz >= pg_numrows($this->wynik)) {
            return false;
        }
        return (pg_fetch_array($this->wynik, $this->wiersz, PGSQL_ASSOC));
    }

    function zwolnijZbiorWynikowy()
    {
        $this->wiersz = 0;
        return (pg_freeresult($this->wynik));
    }
}
?>
