<?php

include_once("Koszyk.php");
include_once("MagazynUzytkownika.php");
include_once("AdresWysylki.php");
include_once("KartaKredytowa.php");
include_once("Wspolne.php");
include_once("Transakcja.php");
include_once("PozycjaKsiazka.php");
include_once("PozycjaAlbum.php");

class Uzytkownik
{
    var $imie;
    var $nazwisko;
    var $idUzytkownika;	
    var $haslo;
    var $plec;
    var $wiek;
    var $email;
    var $nrTelefonu;
    var $saldoKonta;
    var $adresWysylki;
    var $kartaKredytowa;
    var $magazynUzytkownika;
	
    function Uzytkownik($imie, $nazwisko, $idUzytkownika, $haslo, $plec,
				$wiek, $email, $nrTelefonu, $saldoKonta,
				$adresWysylki, $kartaKredytowa)
    {
        $this->imie = $imie;
        $this->nazwisko = $nazwisko;
        $this->idUzytkownika = $idUzytkownika;
        $this->haslo = $haslo;
        $this->plec = $plec;
        $this->wiek = $wiek;
        $this->email = $email;
        $this->nrTelefonu = $nrTelefonu;
        $this->saldoKonta = $saldoKonta;
        $this->adresWysylki = $adresWysylki;
        $this->kartaKredytowa = $kartaKredytowa;
        $this->magazynUzytkownika = new MagazynUzytkownika($idUzytkownika);
    }

    function pobierzImie() 
    {
        return $this->imie;
    }

    function pobierzNazwisko()
    {
        return $this->nazwisko;
    }

    function pobierzIdUzytkownika()
    {
        return $this->idUzytkownika;
    }

    function pobierzPlec() 
    {
        return $this->plec;
    }

    function pobierzWiek()
    {
        return $this->wiek;
    }

    function pobierzEmail()
    {
        return $this->email;
    }

    function pobierzNrTelefonu()
    {
        return $this->nrTelefonu;
    }

    function pobierzAdresWysylki()
    {
        return $this->adresWysylki;
    }

    function pobierzKarteKredytowa()
    {
        return $this->kartaKredytowa;
    }

    function pobierzSaldoKonta()
    {
        return $this->saldoKonta;
    }

    function sprawdzHaslo($haslo) 
    {
        $szyfrogram = crypt($haslo, CRYPT_STD_DES);
        if ($this->haslo == $szyfrogram) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function zatwierdz($koszyk)
    {
        $transakcje = array();
        $pozycjeKoszyka = $koszyk->pobierzZawartosc();
        for ($i = 0; $i < sizeof($pozycjeKoszyka); $i++) {
            $pozycja = $pozycjeKoszyka[$i];
            $poz = $pozycja->pobierzPozycje();
            $transakcje[] = new Transakcja($this->idUzytkownika, $poz, $pozycja->pobierzIlosc(), pobierzCiagDaty(), "W trakcie", null);
            $this->saldoKonta += $pozycja->pobierzIlosc()* $poz->pobierzCene();
        }

        $magazyn = $this->magazynUzytkownika;
        if (sizeof($transakcje) > 0) {
            $magazyn->zapiszTransakcje($this->saldoKonta, $transakcje);
            return TRUE;
        } else {
            return FALSE;
        }
    }

    function pobierzTransakcje()
    {
        $magazyn = $this->magazynUzytkownika;
        $wynikFunkcji = $magazyn->pobierzTransakcje();
        return $wynikFunkcji;
    }
}
?>