<?php

include_once("Wspolne.php");
include_once("Ksiegarnia.php");
include_once("SklepMuzyczny.php");

ustawObslugeSesji();
header("Content-Type: text/vnd.wap.wml" );
sprawdzUwierzytelnienieSesji();

// wykonaj zapytanie i odczytaj wyniki wyszukiwania w asortymencie ksigarni
if (!$wyniki) {
    $indeks = 0;
    $ksieg = new Ksiegarnia();
    $smuz = new SklepMuzyczny();
    if ($kryterium == "K wg Tytulu") {
        $wyniki = $ksieg->szukajTytulow($szukanyTekst);
    } else if ($kryterium == "K wg Autora") {
        $wyniki = $ksieg->szukajAutorow($szukanyTekst);
    } else if ($kryterium == "A wg Tytulu") {
        $wyniki = $smuz->szukajTytulow($szukanyTekst);
    } else if ($kryterium == "A wg Wykonawcy") {
        $wyniki = $smuz->szukajWykonawcow($szukanyTekst);
    } else {
        $wyniki1 = $smuz->szukaj($szukanyTekst);
        $wyniki2 = $ksieg->szukaj($szukanyTekst);
        $wyniki = array_merge($wyniki1, $wyniki2);
    }
}
?>

<!DOCTYPE wml PUBLIC "-//WAPFORUM//DTD WML 1.1//EN" 
				"http://www.wapforum.org/DTD/wml_1.1.xml">
<wml>
  <card id="glowna">
    <do type="options" label="GWNA">
      <go href="Sklep.php?<?php echo pobierzCiagIdSesji() ?>"/>
    </do>

    <p>
      <b> Wyniki wyszukiwania</b> <br/>
      <?php
      $rozmiar = sizeof($wyniki);
      if  ($rozmiar == 0) {
          printf("Nie znaleziono adnych pozycji!<br/>\n");
      } else {
          printf("<select>\n");
          $i = 0;
          while (($i < 3) && ($indeks < $rozmiar)) {
              generujElementOpcji("#a". $wyniki[$indeks]->pobierzNumerPozycji(),
              $wyniki[$indeks]->pobierzTytul());
              $generujKarteOpisu[] = $indeks;
              $indeks++;
              $i++;
          }
          if ($indeks < $rozmiar) {
              $nastepne = "Szukaj.php?indeks=" . 
              $indeks . "&amp;" . pobierzCiagIdSesji();
              generujElementOpcji($nastepne, "Kolejne pozycje");
          }
          printf("</select>\n");
      }
      ?>
    </p>
  </card>

  <?php
  if ($rozmiar > 0) {
      // wywietl karty opisu
      for($i = 0; $i < sizeof($generujKarteOpisu); $i++) {
          $nrPozycji = $wyniki[$generujKarteOpisu[$i]]->pobierzNumerPozycji();
      ?>
      <card id="<?php echo "a".$nrPozycji?>" >
      <do type="accept" label="DODAJ">
      <go href="DoKoszyka.php?wybranaPozycja=<?php echo $nrPozycji. 
	  "&amp;" . pobierzCiagIdSesji() ?>"/>
      </do>
      <do type="options" label="POWRT">
        <go href="#glowna" />
      </do>
      <p>

      <?php
      $poz = $wyniki[$generujKarteOpisu[$i]];

      printf("%s<br/>\n", $poz->pobierzTytul());
      if (strncasecmp($poz->pobierzTypPozycji(), 'KSIAZKA', 4) == 0) {
          printf("%s<br/>\n", $poz->pobierzAutora());
      } else {
          printf("%s<br/>\n", $poz->pobierzWykonawce());
      }
          printf("%s<br/>\n", $poz->pobierzTypPozycji());
          printf("PLN %2.2f\n",$poz->pobierzCene());
      ?>
      </p>
      </card>
      <?php
      } //koniec ptli for
  } //koniec if
  ?>
</wml>