<?php
	
include_once("PozycjaAlbum.php");
include_once("PozycjaKsiazka.php");

class Koszyk
{
    var $pozycjeKoszyka;

    function Koszyk() 
    {
        $this->pozycjeKoszyka = array();
    }

    function dodajPozycje($poz, $ilosc)
    {
        $nrPozycji = $poz->pobierzNumerPozycji();
        $pozycja = $this->pobierzPozycjeKoszyka($nrPozycji);
        if (!$pozycja) {
            $this->pozycjeKoszyka[] = new PozycjaKoszyka($poz, $ilosc);
        } else {
            $pozycjeKoszyka->zwiekszIlosc($ilosc);
        }
    }

    function &pobierzPozycjeKoszyka($nrPozycji) 
    {
        for($i = 0; $i < sizeof($this->pozycjeKoszyka); $i++) {
            $pozycja = & $this->pozycjeKoszyka[$i];
            $poz = $pozycja->pobierzPozycje();
            if ($poz->pobierzNumerPozycji() == $nrPozycji) {
                return $this->pozycjeKoszyka[$i];
            }
        }
        return null;
    }

    function usunPozycje($poz)
    {
        $pozycja= $this->pobierzPozycjeKoszyka($poz->pobierzNumerPozycji());
        if ($pozycja != null) {
            $pozycja->ustawIlosc(0);
        }
    }

    function zmienIlosc($poz, $nowaIlosc)
    {
        $pozycja = &$this->pobierzPozycjeKoszyka($poz->pobierzNumerPozycji());
        if ($pozycja != null) {
            $pozycja->ustawIlosc($nowaIlosc);
        }
        $pozycja = &$this->pobierzPozycjeKoszyka($poz->pobierzNumerPozycji());
    }

    function pobierzZawartosc()
    {
        $pozZwracane = array();
        for($i = 0; $i < sizeof($this->pozycjeKoszyka); $i++) {
            $pozycja = $this->pozycjeKoszyka[$i];
            if ($pozycja->pobierzIlosc() != 0) {
                $pozZwracane[] = $pozycja;
            }
        }
        return $pozZwracane;
    }

    function czysc()
    {
        $this->pozycjeKoszyka = array();
    }
}

class PozycjaKoszyka
{
    var $pozycja;
    var $ilosc;

    function PozycjaKoszyka($pozycja, $ilosc)
    {
        $this->pozycja = $pozycja;
        $this->ilosc = $ilosc;
    }

    function ustawIlosc($ilosc) 
    {
        $this->ilosc= $ilosc;
    }

    function zwiekszIlosc($ilosc) 
    {
        $this->ilosc += $ilosc;
    }

    function pobierzPozycje()
    {
         return $this->pozycja;
    }

    function pobierzIlosc()
    {
        return $this->ilosc;
    }
}
?>