<?php

// katprac_funkcje.php

// Plik zawiera podstawowe funkcje aplikacji
// Blokowanie wielokrotnego wstawiania tego pliku do kodu aplikacji
if (isset($KATPRAC_FUNKCJE)) {
    return;
} else {
    $KATPRAC_FUNKCJE = true;
}

function generujNaglowekHTML($komunikat) 
{
    printf ("<head> <title> BlaImpex - Katalog Pracownikw </title>
             </head>");
    printf("<body text=\"#000000\" bgcolor=\"#999999\" link=\"#0000EE\"
                  vlink=\"#551A8B\" alink=\"#FF0000\">\n");
    printf("<h1>Katalog pracownikw BlaImpex</h1><br><br>");
    printf("<table cellpadding=\"4\" cellspacing=\"0\" 
                   border=\"0\" width=\"600\">");
    printf("<tr bgcolor=\"#dcdcdc\"><td><font face=\"Arial\"><b>");
    printf("%s</b></font><br></td>", $komunikat);
    printf("<td align=\"right\">");
    printf("</font></td></tr>");
    printf("</table>");
    printf("<br>");
    printf("<br>");
}

function generujStroneGlowna()
{
    printf("<form method=\"post\" action=\"katprac_pierwszy.php\">");
    printf("<input type=\"submit\" name=\"wybor\" value=\"SZUKAJ\">");
    printf("&nbsp; &nbsp; &nbsp;");
    printf("<input type=\"submit\" name=\"wybor\" value=\"DODAJ\">");
    printf("<br>");
    printf("<br>");
    printf("<ul>");
    printf("<li> Wyszukiwanie pracownikw - kliknij <i>SZUKAJ PRACOWNIKA</i> </li>");
    printf("<li> Dodawanie nowego pracownika (tylko administrator) - kliknij <i>DODAJ NOWEGO PRACOWNIKA</i> </li>");
    printf("<li> Modyfikacja danych pracownika - kliknij <i>SZUKAJ PRACOWNIKW</i> i wybierz wpis do modyfikacji</li>");
    printf("<li> Usuwanie istniejcego wpisu (tylko administrator) - kliknij <i>SZUKAJ PRACOWNIKW</i> i wybierz wpis do usunicia</li>");
    printf("</form>");
}

function podajHaslo($email, $ou, $skrypt_akcji)
{
    printf("<form method=\"GET\" action=\"%s\">", $skrypt_akcji);
    printf("Haso administratora: <input type=\"password\" name=\"haslo_adm\">&nbsp;");
    printf("<input type=\"hidden\" name=\"email\" value=\"%s\">", urlencode($email));
    printf("<input type=\"hidden\" name=\"ou\" value=\"%s\">", urlencode($ou));
    printf("<input type=\"submit\" name=\"przeslij\" value=\"Przeslij\">");
    printf("</form>");
}

function wyswietlKomunikatBledu($komunikat)
{
    printf("<blockquote><blockquote><blockquote><h3><font
            color=\"#cc0000\">%s</font></h3></blockquote>
            </blockquote></blockquote>\n", $komunikat);
}

function podlaczDoSerwera($RDN_wiazania = 0, $haslo_wiazania = 0)
{
    global $serwerLDAP;
    global $portLDAP; 
    $id_polaczenia = ldap_connect($serwerLDAP);//, $portLDAP);
    if ($id_polaczenia) {
        if (!$RDN_wiazania && !$haslo_wiazania) {
            if (!@ldap_bind($id_polaczenia)) { 
                wyswietlKomunikatBledu("Nie udao si wykona wizania z serwerem LDAP!!");
                return 0;
            }
        } else {
            if (!ldap_bind($id_polaczenia, $RDN_wiazania, $haslo_wiazania)) { 
                wyswietlKomunikatBledu("Nie udao si wykona wizania z serwerem LDAP!!");
                return 0;
            }
        }
    } else {
        wyswietlKomunikatBledu("Nie udao si nawiza poczenia z serwerem LDAP!!");
        return 0;
    }
    return $id_polaczenia;
}

function tworzFiltrWyszukiwania($kryteria)
{
    $liczbaUstawionychPol = 0;
    if ($kryteria["cn"]) {
        $filtr = "(cn=*" . $kryteria["cn"] . "*)";
        ++$liczbaUstawionychPol;
    }
   
    if ($kryteria["sn"]) {
        $filtr .= "(sn=*" . $kryteria["sn"] . "*)";
        ++$liczbaUstawionychPol;
    }

    if ($kryteria["email"]) {
        $filtr .= "(mail=*" . $kryteria["email"] . "*)";
        ++$liczbaUstawionychPol;
    } 
  
    if ($kryteria["nrpracownika"]) {
        $filtr .= "(employeenumber=*" . $kryteria["nrpracownika"] . "*)";
        ++$liczbaUstawionychPol;
    }

    if ($kryteria["ou"]) {
        $filtr .= "(ou=*" . $kryteria["ou"] . "*)";
        ++$liczbaUstawionychPol;
    }

    if ($kryteria["nrtelefonu"]) {
        $filtr .= "(telephonenumber=*" . $kryteria["nrtelefonu"] . "*)";
        ++$liczbaUstawionychPol;
    }
    if ($liczbaUstawionychPol >= 2) {
        $filtr = "(&" .$filtr. ")";
    }
    return $filtr;
}

function szukajWKatalogu($id_polaczenia, $filtr) 
{
    global $bazowa_DN; 
    $wynik = ldap_search($id_polaczenia, $bazowa_DN, $filtr);
    if (ldap_count_entries($id_polaczenia, $wynik) <= 0) {
        wyswietlKomunikatBledu("Nie znaleziono adnych wpisw");
        return 0;
    } else { 
        $wpisy_wynikowe = ldap_get_entries($id_polaczenia, $wynik);
        return $wpisy_wynikowe;
   }
}

function wyswietlWyniki($wpisy_wynikowe) 
{
    printf("<table border width=\"100%%\" bgcolor=\"#dcdcdc\" nosave>\n");
    printf("<tr><td><b>Imi</b></td>
            <td><b>Nazwisko</b></td>
            <td><b>E-mail</b></td>
            <td><b>Nr Pracownika</b></td>
            <td><b>Dzia</b></td>
            <td><b>Telefon</b></td>
            <td><b>Edycja</b></td>
            </tr></b>\n");

    $liczba_wpisow = $wpisy_wynikowe["count"];
    for ($i = 0; $i < $liczba_wpisow; $i++) {
        if (!$wpisy_wynikowe[$i]["cn"] && !$wpisy_wynikowe[$i]["sn"])
            continue;
        $ciag_email = urlencode($wpisy_wynikowe[$i]["mail"][0]);
        $ciag_ou = urlencode($wpisy_wynikowe[$i]["ou"][0]);
        printf("<tr><td>%s</td>
                <td>%s</td>
                <td>%s</td>
                <td>%s</td>
                <td>%s</td>
                <td>%s</td>
                <td>
                <a href=\"katprac_zmien.php?email=%s&ou=%s&pierwsze=1\">
                  [Zmie]</a>
                <a href=\"katprac_usun.php?email=%s&ou=%s\">
                  [Usu]</a><td>
                </tr>\n", 
                $wpisy_wynikowe[$i]["cn"][0],
                $wpisy_wynikowe[$i]["sn"][0],
                $wpisy_wynikowe[$i]["mail"][0],  
                $wpisy_wynikowe[$i]["employeenumber"][0], 
                $wpisy_wynikowe[$i]["ou"][0], 
                $wpisy_wynikowe[$i]["telephonenumber"][0],
                $ciag_email, $ciag_ou,
                $ciag_email, $ciag_ou);
    }
    printf("</table>\n");
}

function generujFormularzHTML($wartosci, $skrypt_akcji, $etykieta)
{
    printf("<form method=\"post\" action=\"%s\"><pre>\n", $skrypt_akcji);
    printf("Imi:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type=\"text\" size=\"35\" 
                                    name=\"cn\" value=\"%s\"><br>\n", 
            ($wartosci) ? $wartosci[0]["cn"][0] : "");
    printf("Nazwisko:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type=\"text\" size=\"35\" 
                                               name=\"sn\"  
                                               value=\"%s\"><br>\n",
            ($wartosci) ? $wartosci[0]["sn"][0] : "");
    printf("E-mail:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type=\"text\" 
            size=\"35\" name=\"email\" value=\"%s\"><br>\n", ($wartosci) ? 
            $wartosci[0]["mail"][0] : "");
    printf("Nr Pracownika:<input type=\"text\" size=\"35\"  
                                name=\"nrpracownika\" 
                                value=\"%s\"><br>\n", 
            ($wartosci) ? $wartosci[0]["employeenumber"][0] : "");
    printf("Dzia:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type=\"text\" size=\"35\" 
                                          name=\"ou\" value=\"%s\"><br>\n", 
            ($wartosci) ? $wartosci[0]["ou"][0] : "");
    printf("Telefon:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type=\"text\" size=\"35\" 
            name=\"nrtelefonu\" value=\"%s\"><br>\n", ($wartosci) ? 
            $wartosci[0]["telephonenumber"][0] : "");
    if ($etykieta== "ZMIEN") {
        printf("Haso uytkownika:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type=\"password\" size=\"35\" 
                       name=\"haslo\"><br>\n");
    }
    if ($etykieta == "DODAJ") {
        printf("Haso administratora:&nbsp;<input type=\"password\" size=\"35\" name=\"haslo_adm\"><br>\n");
    }
    printf("<input type=\"submit\" value=\"%s\">", $etykieta);
    printf("</pre></form>");
}

function powrot() 
{
    printf("<br><form action=\"katprac_pierwszy.php\" method=\"post\">\n");
    printf("<input type=\"submit\" VALUE=\"Nacinij\">aby powrci do strony gwnej\n");
}

function zamknijPolaczenie($id_polaczenia)
{
    ldap_close($id_polaczenia);
}
?>

