<?php

class Resolver {
    var $nazwa_serwera;
    var $nazwa_domeny;
    var $adres_ip;
    var $serwer_pocztowy;
    var $port_serw;
    var $nazwa_serw;
    var $ip_z_kropkami;
    var $ip_dlugi;

    function Resolver() {
        resetuj_bufory();
    }

    function pobierz_mx($domena) {
        if (!$domena) {
            blad_do_dziennika("W celu uzyskania rekordw MX niezbdne jest podanie nazwy domeny");
            return -1;
        } elseif (($wynik = $serwer_pocztowy[$domena])) {
            return $wynik;
        } elseif (getmxrr($domena, $serwer_pocztowy) == false) {
            blad_do_dziennika("Nie mona znale rekordw MX dla " . $nazwa_domeny);
             return -1;
        } else {
            $nazwa_domeny[$domena] = $serwer_pocztowy;
            return $serwer_pocztowy;
        }
    }

    function pobierz_adres_ip($serwer) {
        if (!$serwer) {
            blad_do_dziennika("W celu odszukania adresu IP wymagane jest podanie nazwy hosta");	
            return -1;
        } elseif (($wynik = $adres_ip[$serwer])) {
            return $wynik;
        } elseif (($wynik = gethostbynamel($serwer)) == false) {
            blad_do_dziennika("Nie mona odnale adresu IP dla " . $serwer);
            return -1;
        } else {
            $adres_ip[$serwer] = $wynik;
            $nazwa_serwera[$wynik] = $serwer;
            return $wynik;
        }
    }

    function pobierz_nazwe_serwera($adr_ip) {
        if (!ereg("[1-254]\.[1-254]\.[1-254]\.[1-254]", $adr_ip)) {
            blad_do_dziennika("Nieprawidowy format adresu IP");
            return -1;
        } elseif (($wynik = $nazwa_serwera[$adr_ip])) {
            return $wynik;
        } elseif (($wynik = gethostbyaddr($adr_ip)) == false) {
            blad_do_dziennika("Nie mona odnale nazwy serwera dla " . $adr_ip);
            return -1;
        } else {
            $nazwa_serwera[$adr_ip] = $wynik;
            $adres_ip[$wynik] = $adr_ip;
            return $wynik;
        }
    }

    function pobierz_protokol_po_nazwie($nazwa) {
        if (!$nazwa) {
            blad_do_dziennika("W celu uzyskania numeru protokou naley poda jego nazw" );
            return -1;
        } elseif (($wynik = $numer_proto[$nazwa])) {
            return $wynik;
        } elseif (($wynik = getprotobyname($nazwa)) == false) {
            blad_do_dziennika("Nie mona odnale numeru protokou dla " . $nazwa);
            return -1;
        } else {
            $numer_proto[$nazwa] = $wynik;
            $nazwa_proto[$wynik] = $nazwa;
            return $wynik;
        }
    }

    function pobierz_protokol_po_numerze($liczba) { if (!$liczba) {
            blad_do_dziennika("W celu uzyskania nazwy protokou naley poda jego numer" );
            return -1;
        } elseif (($wynik = $nazwa_proto[$liczba])) {
            return $wynik;
        } elseif (($wynik = getprotobynumber($liczba)) == false) {
            blad_do_dziennika("Nie mona odnale nazwy protokou dla " . $liczba);
            return -1;
        } else {
            $nazwa_proto[$liczba] = $wynik;
            $numer_proto[$wynik] = $liczba;
            return $wynik;
        }
    }

    function pobierz_serwer_po_nazwie($nazwa, $protokol) {
        if (!($protokol != "TCP" || $protokol != "tcp" 
           || $protokol != "UDP" || $protokol != "udp")) {
            blad_do_dziennika("Akceptowane nazwy protokow to TCP oraz UDP");
            return -1;
        }
        if (!$nazwa) {
            blad_do_dziennika("W celu uzyskania numeru portu wymagane jest podanie nazwy serwisu" );
            return -1;
        } elseif (($wynik = $port_serw[$nazwa])) {
            return $wynik;
        } elseif (($wynik = getservbyname($nazwa)) == false) {
            blad_do_dziennika("Nie mona odnale portu usugi " . $nazwa . " dla protokou " . $protokol);
            return -1;
        } else {
            $port_serw[$nazwa] = $wynik;
            $nazwa_serw[$wynik] = $nazwa;
            return $wynik;
        }
    }

    function z_kropkami_do_ip($z_kropkami) {
        if (!$z_kropkami) {
            blad_do_dziennika("W celu uzyskania liczbowego adresu IP naley poda go w postaci z kropkami");
            return -1;
        } elseif (!ereg("[1-254]\.[1-254]\.[1-254]\.[1-254]", $z_kropkami)) {
            blad_do_dziennika("Nieprawidowy format adresu IP");
            return -1;
        } elseif ($wynik = $ip_dlugi[$z_kropkami]) {
            return $wynik;
        } elseif (($wynik = ip2long($z_kropkami)) == false) {
            blad_do_dziennika("Nie mona odnale dugiego adresu IP dla " . $z_kropkami);
            return -1;
        } else {
            $ip_dlugi[$z_kropkami] = $wynik;
            $ip_z_kropkami[$wynik] = $z_kropkami;
            return $wynik;
        }
    }

    function ip_na_kropki($dlugie_ip) {
        if (!$dlugie_ip) {
            blad_do_dziennika("W celu uzyskania adresu IP w postaci z kropkami naley poda go w postaci liczbowej");
            return -1;
        } elseif ($wynik = $ip_z_kropkami[$dlugie_ip]) {
            return $wynik;
        } elseif (($wynik = long2ip($dlugie_ip)) == false) {
            blad_do_dziennika("Nie mona uzyska adresu IP dla " . $dlugie_ip);
            return -1;
        } else {
            $ip_z_kropkami[$dlugie_ip] = $wynik;
            $ip_dlugi[$wynik] = $dlugie_ip;
            return $wynik;
        }
    }

    function resetuj_bufory() {
        $nazwa_serwera = 0;
        $nazwa_domeny = 0;
        $adres_ip = 0;
        $serwer_pocztowy = 0;
        $port_serw = 0;
        $nazwa_serw = 0;
        $ip_z_kropkami = 0;
        $ip_dlugi = 0;
    }

    function blad_do_dziennika($list) {
        echo $list . "<BR>";
    }
}
?>
