<?php

// webmail.php

include("./klasa_webmail-wersja_ostateczna.php");

class MojWebmail extends Webmail 
{
    var $klasa_pocztowa = 'KlasaPocztowaMIME';
    var $klasa_smtp = 'KlasaPocztowaMIME';
    var $klasa_nntp = 'KlasaNNTP';

    var $serwer_smtp = '';
    var $port_smtp = 24;
    var $skrzynka_wyslane = '';
    var $liczba_listow_na_strone = 10;

    var $TYTUL_HTML = 'Witamy w naszym serwisie pocztowym WWW!';
    var $ZESTAW_ZNAKOW = 'ISO-8859-2';

    var $BRAK_ZAWARTOSCI = 'Brak zawartoci.';
    var $BLAD_BRAK_NUMEROW_UID  = 'Nie wybrano listu!';

    function start($operacja) 
    {
        switch($operacja) {
        case 'odczytaj_pozycje':
            $lista = $this->odczytaj_pozycje();
            if(!$lista) return 0;
            return $this->interfejs('', $lista);
            break;
        case 'pobierz_zalacznik':
            if(!$this->pobierz_zalacznik()) return false;
            break;
        case 'utworz_skrzynke': 
            if(!$this->utworz_skrzynke()) return false;
            return $this->interfejs('', '');
            break;        
        case 'zmien_nazwe_katalogu': 
            if(!$this->zmien_nazwe_skrzynki()) return false;
            return $this->interfejs('', '');
            break;
        case 'usun_skrzynke':
            if(!$this->usun_skrzynke()) return false;
            return $this->interfejs('', '');
            break;
        case 'skopiuj_pozycje':
            if(!$this->skopiuj_pozycje()) return false;
            return $this->interfejs('', '');
             break;
        case 'przenies_pozycje':
            if(!$this->przenies_pozycje()) return false;
            return $this->interfejs('', '');
            break;
        case 'usun_list':
            if(!$this->usun_pozycje()) return false;
            return $this->interfejs('', '');
            break;
        case 'formularz_listu':
            return $this->interfejs('', $this->formularz_listu());
            break;
        case 'list':
            return $this->wyslij_webmail();
            break;
        default:
            return $this->interfejs('');
            break;
        }

        return true;
        }

    function interfejs($pierwsza_kolumna, $druga_kolumna='') 
    {

        $skrzynki = $this->wypisz_zawartosc_skrzynki();
        if(!$skrzynki) return false;

        $pierwsza_kolumna = $skrzynki . $this->formularz_utworz_skrzynke() . $this->menu() . $pierwsza_kolumna;

        if(empty($druga_kolumna)) {
            $listy = $this->wypisz_pozycje();
            if(!$listy) $listy = $this->BRAK_ZAWARTOSCI;
            $druga_kolumna = $listy;      
        }

        echo $this->naglowek_html($this->TYTUL_HTML,$this->ZESTAW_ZNAKOW);

        echo("<TABLE BORDER=\"0\" WIDTH=\"100%\" CELLSPACING=\"0\" CELLPADDING=\"0\">\n");
        echo("<TR>\n");
        echo("<TD WIDTH=\"30%\" VALIGN=\"TOP\">$pierwsza_kolumna</TD>\n");
        echo("<TD WIDTH=\"70%\" VALIGN=\"TOP\">$druga_kolumna</TD>\n");
        echo("</TR>\n");
        echo("</TABLE>\n");

        echo $this->stopka_html();

        return true;
    }

    function menu() {
        if($this->protokol == 'nntp') $tekst_menu = $this->zbuduj_adres_url("operacja=formularz_listu&tryb=artykul&skrzynka=$this->skrzynka", '[Opublikuj]');
        else $tekst_menu = $this->zbuduj_adres_url('operacja=formularz_listu&tryb=nowy', '[Wylij]');

        return $tekst_menu;
    }

    function formularz_listu() {
        global $PHP_SELF, $tryb, $adres_email;

        $jest_artykulem = false;

        if($tryb == 'odpowiedz') {
            $list = $this->pobierz_list('', '');
            if(!$list) $adres_odbiorcy = $adres_email;
            else {
                $data_listu = $list["data"];
                $adres_odbiorcy = $list["surowe_from"];
                $adres_kopii = $list["surowa_kopia"];
                $temat_listu = "Re: " . $list["temat"];
                $tresc_listu = "--- Original Message($data_listu) ---\r\n" . eregi_replace("<BR>", "\r\n", $list["tresc"]);
            }
        }
        else if($tryb == 'przeslij') {
            $list = $this->pobierz_list('', '');
            if(!$list) return false;
            $adres_nadawcy = $list["surowe_from"];
            $data_listu = $list["data"];
            $temat_listu = "Fwd: " . $list["temat"];
            $adres_zwrotny = $adres_nadawcy;
            $tresc_listu = "--- Original Message($data_listu) ---\r\n" . eregi_replace("<BR>", "\r\n", $list["tresc"]);
        }
        else if($tryb == 'artyku') {
            $adres_odbiorcy = $this->skrzynka;
            $jest_artykulem = true;
        }
        else if($tryb == 'odpowiedz_artykul') {
            $adres_odbiorcy = $this->skrzynka;
            $list = $this->pobierz_list('', '');
            $dotyczy = $list["dotyczy"] . " " . $list["id_pozycji"];
            $temat_listu = "Re: " . $list["temat"];
            $jest_artykulem = true;
        }

        $tekst_wynikowy ="<FORM NAME=\"MAIL_FORM\" ACTION=\"$PHP_SELF\" METHOD=\"POST\" ENCTYPE=\"MULTIPART/FORM-DATA\">\n";
        $tekst_wynikowy .= "<INPUT TYPE=\"HIDDEN\" VALUE=\"mail\" NAME=\"operacja\">\n";
        $tekst_wynikowy .= "<INPUT TYPE=\"HIDDEN\" VALUE=\"$tryb\" NAME=\"tryb\">\n";
        $tekst_wynikowy .= "<INPUT TYPE=\"HIDDEN\" VALUE=\"$this->uid_listu\" NAME=\"msg_uid\">\n";
        $tekst_wynikowy .= "<DIV ALIGN=\"CENTER\"><TABLE CELLSPACING=\"2\" CELLPADDING=\"5\" WIDTH=\"90%\" BORDER=\"1\">\n";

        if(!$jest_artykulem) {
            $tekst_wynikowy .= "<TR>\n";  
            $tekst_wynikowy .= "<TH WIDTH=\"100%\" COLSPAN=\"2\"><INPUT TYPE=\"CHECKBOX\" NAME=\"uzywanie_smtp\" VALUE=\"ON\">USE SMTP</TH>\n";   
            $tekst_wynikowy .= "</TR>\n";
            $tekst_wynikowy .= "<TR>\n";        
            $tekst_wynikowy .= "<TH WIDTH=\"30%\">Serwer SMTP</TH>\n";
            $tekst_wynikowy .= "<TD WIDTH=\"70%\"><INPUT TYPE=\"TEXT\" NAME=\"serwer_smtp\" SIZE=\"20\"></TD>\n";          
            $tekst_wynikowy .= "</TR>\n";
            $tekst_wynikowy .= "<TR>\n";   
            $tekst_wynikowy .= "<TH WIDTH=\"30%\">Port SMTP</TH>\n";
            $tekst_wynikowy .= "<TD WIDTH=\"70%\"><INPUT TYPE=\"TEXT\" NAME=\"port_smtp\" SIZE=\"5\" VALUE=\"25\"></TD>\n";     
            $tekst_wynikowy .= "</TR>\n";   
            $tekst_wynikowy .= "<TR>\n";
            $tekst_wynikowy .= "<TH WIDTH=\"30%\">Adresat</TH>\n";
            $tekst_wynikowy .= "<TD WIDTH=\"70%\"><INPUT TYPE=\"TEXT\" NAME=\"adres_odbiorcy\" VALUE=\"$adres_odbiorcy\" SIZE=\"20\"></TD>\n";
            $tekst_wynikowy .= "</TR>\n";       
            $tekst_wynikowy .= "<TR>\n";                
            $tekst_wynikowy .= "<TH WIDTH=\"30%\">Kopia</TH>\n";
            $tekst_wynikowy .= "<TD WIDTH=\"70%\"><INPUT TYPE=\"TEXT\" NAME=\"adres_kopii\" VALUE=\"$adres_kopii\" SIZE=\"20\"></TD>\n";
            $tekst_wynikowy .= "</TR>\n";
            $tekst_wynikowy .= "<TR>\n";
            $tekst_wynikowy .= "<TH WIDTH=\"30%\">Ukryta kopia</TH>\n";
            $tekst_wynikowy .= "<TD WIDTH=\"70%\"><INPUT TYPE=\"TEXT\" NAME=\"adres_ukrytej_kopii\" SIZE=\"20\"></TD>\n";
            $tekst_wynikowy .= "</TR>\n";
        }
        else {
            $tekst_wynikowy .= "<TR>\n";
            $tekst_wynikowy .= "<TH WIDTH=\"30%\">Grupy</TH>\n";
            $tekst_wynikowy .= "<TD WIDTH=\"70%\"><INPUT TYPE=\"TEXT\" NAME=\"adres_odbiorcy\" VALUE=\"$adres_odbiorcy\" SIZE=\"20\"></TD>\n";
            $tekst_wynikowy .= "</TR>\n";
        }

        if(!empty($dotyczy)) {
            $tekst_wynikowy .= "<TR>\n";
            $tekst_wynikowy .= "<TH WIDTH=\"30%\">Dotyczy</TH>\n";
            $tekst_wynikowy .= "<TD WIDTH=\"70%\">$dotyczy<INPUT TYPE=\"HIDDEN\" NAME=\"dotyczy\" VALUE=\"$dotyczy\" SIZE=\"20\"></TD>\n";
            $tekst_wynikowy .= "</TR>\n";       
        }

        $tekst_wynikowy .= "<TR>\n";
        $tekst_wynikowy .= "<TH WIDTH=\"30%\">Nadawca</TH>\n";
        $tekst_wynikowy .= "<TD WIDTH=\"70%\"><INPUT NAME=\"nadawca\" SIZE=\"20\"></TD>\n";
        $tekst_wynikowy .= "</TR>\n";
        $tekst_wynikowy .= "<TR>\n";
        $tekst_wynikowy .= "<TH WIDTH=\"30%\">Adres zwrotny</TH>\n";
        $tekst_wynikowy .= "<TD WIDTH=\"70%\"><INPUT NAME=\"adres_zwrotny\" VALUE=\"$adres_zwrotny\"SIZE=\"20\"></TD>\n";
        $tekst_wynikowy .= "</TR>\n";
        $tekst_wynikowy .= "<TR>\n";
        $tekst_wynikowy .= "<TH WIDTH=\"30%\">Zacznik</TH>\n";
        $tekst_wynikowy .= "<TD WIDTH=\"70%\"><INPUT TYPE=\"FILE\" NAME=\"userfile\"></TD>\n";
        $tekst_wynikowy .= "</TR>\n";
        $tekst_wynikowy .= "<TR>\n";
        $tekst_wynikowy .= "<TH WIDTH=\"30%\">Typ</TH>\n";
        $tekst_wynikowy .= "<TD WIDTH=\"70%\"><INPUT TYPE=\"RADIO\" CHECKED VALUE=\"text\" NAME=\"typ\">TEXT\n";
        $tekst_wynikowy .= "<INPUT TYPE=\"RADIO\" VALUE=\"html\" NAME=\"typ\">HTML\n";
        $tekst_wynikowy .= "</TD>\n";
        $tekst_wynikowy .= "</TR>\n";
        $tekst_wynikowy .= "<TR>\n";
        $tekst_wynikowy .= "<TH WIDTH=\"30%\">Kodowanie</TH>\n";
        $tekst_wynikowy .= "<INPUT TYPE=\"RADIO\" VALUE=\"8bit\" NAME=\"kodowanie\" CHECKED>8BIT\n";
        $tekst_wynikowy .= "<TD WIDTH=\"70%\"><INPUT TYPE=\"RADIO\" VALUE=\"7bit\" NAME=\"kodowanie\">7BIT\n";
        $tekst_wynikowy .= "</TD>\n";
        $tekst_wynikowy .= "</TR>\n";
        $tekst_wynikowy .= "<TR>\n";
        $tekst_wynikowy .= "<TH WIDTH=\"30%\">Zestaw znakw</TH>\n";
        $tekst_wynikowy .= "<INPUT TYPE=\"RADIO\" VALUE=\"iso-8859-2\" NAME=\"strona_kodowa\" CHECKED>ISO-8859-2\n";
        $tekst_wynikowy .= "<TD WIDTH=\"70%\"><INPUT TYPE=\"RADIO\" VALUE=\"us-ascii\" NAME=\"strona_kodowa\">US-ASCII\n";
        $tekst_wynikowy .= "</TD>\n";
        $tekst_wynikowy .= "</TR>\n";
        $tekst_wynikowy .= "<TR>\n";
        $tekst_wynikowy .= "<TH WIDTH=\"30%\">Temat</TH>\n";
        $tekst_wynikowy .= "<TD WIDTH=\"70%\"><INPUT SIZE=\"40\" NAME=\"temat\" VALUE=\"$temat_listu\"></TD>\n";
        $tekst_wynikowy .= "</TR>\n";
        $tekst_wynikowy .= "<TR>\n";
        $tekst_wynikowy .= "<TH WIDTH=\"30%\">Tresc</TH>\n";
        $tekst_wynikowy .= "<TD WIDTH=\"70%\"><TEXTAREA NAME=\"tresc\" ROWS=\"10\" COLS=\"60\">$tresc_listu</TEXTAREA></TD>\n";
        $tekst_wynikowy .= "</TR>\n";
        $tekst_wynikowy .= "<TR>\n";
        $tekst_wynikowy .= "<TH WIDTH=\"30%\" COLSPAN=\"2\"><INPUT TYPE=\"SUBMIT\" VALUE=\"Wylij\" NAME=\"SUBMIT\">\n";
        $tekst_wynikowy .= "<INPUT TYPE=\"RESET\" VALUE=\"Wyczy\" NAME=\"RESET\"></TH>\n";
        $tekst_wynikowy .= "</TR>\n";
        $tekst_wynikowy .= "</TABLE>\n";
        $tekst_wynikowy .= "</DIV>\n";
        $tekst_wynikowy .= "</FORM>\n";

        return $tekst_wynikowy;
    }

    function wyslij_webmail() {
        global $jest_artykulem, $uzywanie_smtp, $serwer_smtp, $port_smtp;
        global $adres_odbiorcy, $dotyczy, $adres_nadawcy, $adres_zwrotny, $adres_kopii, $adres_ukrytej_kopii;
        global $typ_listu, $zestaw_znakow, $temat_listu, $tresc_listu;
        global $plik_uzytkownika, $typ_pliku_uzytkownika, $nazwa_pliku_uzytkownika, $rozmiar_pliku_uzytkownika;

        if($jest_artykulem) {
            include ("./klasa_nntp.php");

            $moj_list = new $this->klasa_nntp();
            $moj_list->serwer_nntp = $serwer_nntp;
            $moj_list->port_nntp = $port_nntp;
            $moj_list->grupy_dyskusyjne = $adres_odbiorcy;
        }
        else {
            if($uzywanie_smtp) {
            include("./klasa_pocztowa_smtp_mime.php");

            $moj_list = new $this->klasa_smtp();
            $moj_list->serwer_smtp = $serwer_smtp;
            $moj_list->port_smtp = $port_smtp;
            }
            else {
               include("./klasa_pocztowa_mime.php");         
               $moj_list = new $this->klasa_pocztowa();
            }

            $moj_list->adresat = $adres_odbiorcy;
            $moj_list->kopia = $adres_kopii;
            $moj_list->ukryta_kopia = $adres_ukrytej_kopii;
        }       

        $moj_list->nadawca = $adres_nadawcy;
        $moj_list->typ = $typ_listu;
        $moj_list->zestaw_znakow = $zestaw_znakow;
        $moj_list->temat = $temat_listu;
        $moj_list->tresc = $tresc_listu;


        if($rozmiar_pliku_uzytkownika > 0) {
            $moj_list->pliki[0]["plik"] = $plik_uzytkownika;
            $moj_list->pliki[0]["nazwa_pliku"] = $nazwa_pliku_uzytkownika;
            $moj_list->pliki[0]["rozmiar_pliku"] = $rozmiar_pliku_uzytkownika;
            $moj_list->pliki[0]["typ_pliku"] = $typ_pliku_uzytkownika;
        }

        if(!$moj_list->wyslij()) {
            $this->utworz_komunikat_o_bledzie($moj_list->komunikat_o_bledzie());
            return 0;
        }

        $tresc_listu = $moj_list->wypisz_list();
        if(!$tresc_listu) return false;

        if(!empty($this->skrzynka_wyslane)) {
            if(!$this->dopisz_list($tresc_listu, $this->skrzynka_wyslane)) return false;         
        }

        if($jest_artykulem) $okreslenie = 'opublikowany';
        else $okreslenie = 'wysany';
        echo "<SCRIPT LANGUAGE=\"JavaScript\">alert(\"Successfully $okreslenie '$temat_listu'!\");history.go(-1);</SCRIPT>";

        return true;

    }

    function skopiuj_pozycje() {
        global $UID_ARTYKULOW;

        if(!is_array($UID_ARTYKULOW)) {
            $this->utworz_komunikat_o_bledzie($this->BLAD_BRAK_NUMEROW_UID);
            return false;
        }

        if(!$this->skopiuj_list(implode(",", $UID_ARTYKULOW))) return false; 
            return true;
    }

    function przenies_pozycje() {
        global $UID_ARTYKULOW;

        if(!is_array($UID_ARTYKULOW)) {
            $this->utworz_komunikat_o_bledzie($this->BLAD_BRAK_NUMEROW_UID);
            return false;
        }

        if(!$this->przenies_list(implode(",", $UID_ARTYKULOW))) return 0; 
        return true;
    }

    function usun_pozycje() {
        global $UID_ARTYKULOW;

        if(!is_array($UID_ARTYKULOW)) {
            $this->utworz_komunikat_o_bledzie($this->BLAD_BRAK_NUMEROW_UID);
            return true;
        }

        if(!$this->usun_list(implode(",", $UID_ARTYKULOW))) return 0; 
        return true;
    }

    function formularz_utworz_skrzynke() {
        global $PHP_SELF;

        if($this->protokol != 'imap') return;
        $tekst_wynikowy = "<FORM METHOD=\"POST\" ACTION=\"$PHP_SELF\">\n";
        $tekst_wynikowy .= "<INPUT TYPE=\"HIDDEN\" NAME=\"operacja\" VALUE=\"utworz_skrzynke\">\n";
        $tekst_wynikowy .= "<INPUT TYPE=\"TEXT\"NAME=\"nowa_skrzynka\" SIZE=\"10\"><BR>\n";
        $tekst_wynikowy .= "<INPUT TYPE=\"SUBMIT\" VALUE=\"Utwrz\" NAME=\"SUBMIT\">\n";
        $tekst_wynikowy .= "</FORM>\n";

        return $tekst_wynikowy;
    }

    function naglowek_tabeli_listow() {
        return "<TABLE BORDER=\"1\" WIDTH=\"90%\" CELLPADDING=\"2\" CELLSPACING=\"1\">\n";
    }

    function wiersz_tabeli_listow($szerokosc, $dane_komorki, $jest_naglowkiem=0, $kolor_tla='#FFFFFF', $wyrownanie='CENTER', $wyr_pionowe='TOP') {
        if(!$jest_naglowkiem) $znacznik_wiersza = 'TD';
        else $znacznik_wiersza = 'TH';

        return "<$znacznik_wiersza WIDTH=\"$szerokosc%\" ALIGN=\"$wyrownanie\" VALIGN=\"$wyr_pionowe\" BGCOLOR=\"$kolor_tla\" NOWRAP>$dane_komorki</$znacznik_wiersza>\n";
    }

    function stopka_tabeli_listow() {
        return "</TABLE>\n";
    }

    function wypisz_pozycje() {
        global $PHP_SELF, $biezaca_strona;
        $kolejnosc = $this->odwrocone;

        if($this->sortowanie == SORTDATE) $this->odwrocone = (integer)!$this->odwrocone;

        if($this->protokol =='imap') {
            $tekst_wynikowy = "<FORM METHOD=\"POST\" ACTION=\"$PHP_SELF\">\n";
            $tekst_wynikowy .= "<INPUT TYPE=\"HIDDEN\" NAME=\"skrzynka\" VALUE=\"$this->skrzynka\">\n";
        }
        else $tekst_wynikowy = '';

        $tekst_wynikowy .= $this->naglowek_tabeli_listow();

        $t_str = $this->wiersz_tabeli_listow(10,'NR',1,"#CECECE");

        $t_str .= $this->wiersz_tabeli_listow(50,$this->zbuduj_adres_url("operacja=wypisz_pozycje&skrzynka=$this->skrzynka&sortowanie=" . SORTSUBJECT . "&odwrocone=$kolejnosc", "TEMAT"),1,"#CECECE");

        $t_str .= $this->wiersz_tabeli_listow(20,$this->zbuduj_adres_url("operacja=wypisz_pozycje&skrzynka=$this->skrzynka&sortowanie=" . SORTFROM . "&odwrocone=$kolejnosc", "NADAWCA"),1,"#CECECE");

        $t_str .= $this->wiersz_tabeli_listow(20,$this->zbuduj_adres_url("operacja=wypisz_pozycje&skrzynka=$this->skrzynka&sortowanie=" . SORTDATE . "&odwrocone=$kolejnosc", "DATA"),1,"#CECECE");

        $tekst_wynikowy .= "<TR>\n$t_str</TR>\n";

        $listy = $this->pobierz_naglowki_listow('operacja=odczytaj_pozycje', 'operacja=formularz_listu&tryb=odpowiedz');

        if(!$listy) return 0;

        $liczba_listow = count($listy);

        if(!$biezaca_strona) $biezaca_strona = 1;

        if(!$liczba_listow) $liczba_stron = 1;
        else $liczba_stron = ceil($liczba_listow/$this->liczba_listow_na_strone);

        if($biezaca_strona >= $liczba_stron) $biezaca_strona = $liczba_stron;

        $skrzynki = $this->pobierz_zawartosc_skrzynki('', 1);

        if(!$skrzynki) return false;

        $numer_poczatkowy = ($biezaca_strona - 1) * $this->liczba_listow_na_strone;
        $numer_koncowy = $biezaca_strona * $this->liczba_listow_na_strone;

        if($numer_koncowy > $liczba_listow) $numer_koncowy = $liczba_listow;

        for($i = $numer_poczatkowy; $i < $numer_koncowy; $i++) {

            $numer_listu = $listy[$i]["nr"];
            $uid_listu = $listy[$i]["uid"];

            if(count($skrzynki) > 0 && $this->protokol =='imap') $pole_wyboru = "<INPUT TYPE=\"CHECKBOX\" NAME=\"uid_listu[]\" VALUE=\"$uid_listu\">";

            $temat_listu = $listy[$i]["temat"];
            $nadawca_listu = $listy[$i]["nadawca"];
            $data_listu = $listy[$i]["data"];
            if($listy[$i]["nieczytany"]) $jest_naglowkiem = 1;
            else $jest_naglowkiem = false;

            $t_str = $this->wiersz_tabeli_listow(10,$pole_wyboru . $numer_listu, $jest_naglowkiem, '#FFFFFF', 'LEFT');
            $t_str .= $this->wiersz_tabeli_listow(50,$temat_listu, $jest_naglowkiem, '#FFFFFF', 'LEFT');
            $t_str .= $this->wiersz_tabeli_listow(20,$nadawca_listu, $jest_naglowkiem, '#FFFFFF', 'LEFT');
            $t_str .= $this->wiersz_tabeli_listow(20,$data_listu, $jest_naglowkiem, '#FFFFFF', 'LEFT');

            $tekst_wynikowy .= "<TR>\n$t_str</TR>\n";
        }

        $tekst_wynikowy .= $this->stopka_tabeli_listow();

        if((count($skrzynki) > 1) && $this->protokol =='imap') {
            $tekst_wynikowy .= "USU<INPUT TYPE=\"RADIO\" VALUE=\"usun_pozycje\" NAME=\"operacja\">\n";
            $tekst_wynikowy .= "SKOPIUJ<INPUT TYPE=\"RADIO\" VALUE=\"skopiuj_pozycje\" NAME=\"operacja\">\n";
            $tekst_wynikowy .= "PRZENIE<INPUT TYPE=\"RADIO\" VALUE=\"przenies_pozycje\" CHECKED NAME=\"operacja\">\n";
            $tekst_wynikowy .= "DO<SELECT NAME=\"nowa_skrzynka\" SIZE=\"1\">\n";
            foreach($skrzynki as $skrz) {
                if($skrz != $this->skrzynka && (!(($skrz=='INBOX') && (empty($this->skrzynka)))))
                    $tekst_wynikowy .= "<OPTION VALUE=\"$skrz\">$skrz</OPTION>\n";

                }
            $tekst_wynikowy .= "</SELECT>\n";
            $tekst_wynikowy .= "<INPUT TYPE=\"Submit\" VALUE=\"Wykonaj!\">\n";

            $tekst_wynikowy .= "</FORM>\n";
            $tekst_wynikowy .= "<BR>\n";

        }
    $tekst_wynikowy .="<CENTER>\n";
        for($i = 1; $i <= $liczba_stron; $i++) {
            if($biezaca_strona == $i) $tekst_wynikowy .= "<STRONG>[$i]</STRONG>";
            else $tekst_wynikowy .= $this->zbuduj_adres_url("operacja=wypisz_pozycje&skrzynka=$this->skrzynka&sortowanie=$this->sortowanie&odwrocone=$kolejnosc&biezaca_strona=$i", "[$i]");
        }
        $tekst_wynikowy .= "</CENTER>\n";
        return $tekst_wynikowy;
    }

    function wypisz_zawartosc_skrzynki($skrzynka='') {      
        $tekst = "";

        $skrzynki = $this->pobierz_zawartosc_skrzynki($skrzynka);
        if(!$skrzynki) return false;

        foreach($skrzynki as $skrz=>$nieczytane) {
            if($this->protokol !='nntp' && $this->protokol !='pop3' && $skrz != 'INBOX') 
            $del_prefix = $this->zbuduj_adres_url("operacja=usun_skrzynke&usuwana_skrzynka=$skrz", "[X]", "if(!confirm('Jeste pewny?')) return false;");
            else $del_prefix = '';

            if($this->protokol == 'nntp') {
                $tekst .= $this->zbuduj_adres_url("operacja=wypisz_pozycje&skrzynka=$skrz", "$skrz($nieczytane)") . "<BR>\n";
            }
            else {
                $tekst .= $del_prefix . $this->zbuduj_adres_url("operacja=wypisz_zawartosc_skrzynki&skrzynka=$skrz", "$skrz($nieczytane)") . "<BR>\n";
            }
        }
        return $tekst;
    }

    function odczytaj_pozycje() { 
        $list = $this->pobierz_list('operacja=pobierz_zalacznik', 'operacja=formularz_listu&tryb=odpowiedz');

        if(!$list) return false;
        $tekst_wynikowy = "<STRONG>Data: </STRONG>" . $list["data"] . "<BR>\n";
        $tekst_wynikowy .= "<STRONG>Nadawca: </STRONG>" . $list["nadawca"] . "<BR>\n";
        if(!empty($list["kopia"])) $tekst_wynikowy .= "<STRONG>Kopia: </STRONG>" . $list["kopia"] . "<BR>\n";
        if(!empty($list["dotyczy"])) $tekst_wynikowy .= "<STRONG>Dotyczy: </STRONG>" . $list["dotyczy"] . "<BR>\n";
        $tekst_wynikowy .= "<STRONG>Temat: </STRONG>" . $list["temat"] . "<BR>\n";

        if($this->protokol == 'nntp') $tekst_wynikowy .= $this->zbuduj_adres_url("operacja=formularz_listu&skrzynka=$this->skrzynka&tryb=odpowiedz_artykul&uid_listu=$this->uid_listu", "[Odpowiedz na artyku]");
        else $tekst_wynikowy .= $this->zbuduj_adres_url("operacja=formularz_listu&skrzynka=$this->skrzynka&tryb=przeslij&uid_listu=$this->uid_listu", "[Przelij dalej]");
        $tekst_wynikowy .= "<BR><BR>\n";

        $tekst_wynikowy .= "<BLOCKQUOTE>" . $list["tresc"] . "</BLOCKQUOTE><BR>\n";

        if($list["liczba_czesci"] > 0) {
            $tekst_wynikowy .= "<CENTER><HR WIDTH=\"90%\" SIZE=\"1\"></CENTER>\n";
            for($i = 0; $i < count($list["czesci"]); $i++) $tekst_wynikowy .= $list["czesci"][$i] . "<BR>\n";
        }

        return $tekst_wynikowy;
    }

    function naglowek_html($tytul='', $zestaw_znakow='') {
        $tekst_wynikowy = "<HTML>\n";
        $tekst_wynikowy .= "<HEAD>\n";
        if(!empty($zestaw_znakow)) $tekst_wynikowy .= "<META HTTP-EQUIV=\"CONTENT-TYPE\" CONTENT=\"TEXT/HTML; CHARSET=$zestaw_znakow\">\n";
        $tekst_wynikowy .= "<TITLE>$tytul</TITLE>\n";
        $tekst_wynikowy .= "</HEAD>\n";
        $tekst_wynikowy .= "<BODY>\n";

        return $tekst_wynikowy;
    }

    function stopka_html() {
        $tekst_wynikowy = "</BODY>\n";
        $tekst_wynikowy .= "</HTML>\n";

        return $tekst_wynikowy;
    }

}

$serwer = "news.php.net";
$protokol = "nntp";
$port = 119;
$id_uzytkownika = "";
$haslo_uzytkownika = "";

$program_pocztowy = new MojWebmail();
if(!$program_pocztowy->inicjacja($serwer, $protokol, $port, $id_uzytkownika, $haslo_uzytkownika)) echo $program_pocztowy->komunikat_o_bledzie();

if(!$program_pocztowy->start($operacja)) echo $program_pocztowy->komunikat_o_bledzie();

$program_pocztowy->koniec();

?>

