<?php

//klasa_webmail-wersja4.php 

class Webmail {
    var $serwer = '';
    var $protokol = 'imap';
    var $obslugiwane_protokoly = array('imap', 'pop3', 'nntp');
    var $port = 143;
    var $id_uzytkownika = '';
    var $haslo_uzytkownika = '';
    var $strumien = 0;
    var $skrzynka = '';
    var $automatyczne_oczyszczanie = 1;

    var $sortowanie = 'SORTUJ_PO_DACIE';
    var $odwrocone = 0;

    var $numer_listu = 0;
    var $uid_listu = 0;
    var $numer_czesci = 0;
    var $nazwa_pliku = '';
        
    var $usuwana_skrzynka = '';
    var $stara_skrzynka = '';
    var $nowa_skrzynka = '';
        
    var $BLAD_NIE_MOZNA_UTWORZYC_FOLDERU = "Nie mona utworzy skrzynki!";
    var $BLAD_NIE_MOZNA_ZMIENIC_NAZWY_FOLDERU = "Nie mona zmieni nazwy skrzynki!";
    var $BLAD_NIE_MOZNA_USUNAC_FOLDERU = "Nie mona usun skrzynki!";  
        
    var $BLAD_NIEPOPRAWNY_NR_ARTYKULU = 'Nieprawidowy numer listu!';
    var $BLAD_MIEPOPRAWNY_UID_ARTYKULU   = 'Nieprawidowy UID listu!';
        
    var $BLAD_STANU_FOLDERA = 'Nie mona odczyta stanu skrzynki!';
    var $BRAK_TEMATU = 'BRAK TEMATU';
    var $BRAK_POLA_FROM = 'NIEZNANY';
        
    var $BLAD_SEPARATORA_ARGUMENTOW = " ";
    var $KOMUNIKAT_O_BLEDZIE = '';
        
    var $BLAD_POLACZENIE_NIEUDANE = 'Poczenie nieudane!';
    var $BLAD_NIEOBSLUGIWANY_PROTOKOL = 'Wybrany protok nie jest obsugiwany!';
    var $BLAD_ZAMKNIECIE_NIEUDANE = 'Bd zamknicia strumienia!';
    var $BLAD_FOLDER_NIEDOSTEPNY = 'Skrzynka niedostepna!';
    var $BLAD_NIEPRZESLONIETA_METODA_START = "Naley przesoni metod start()!";

    function inicjacja($serwer, $protokol='imap', $port=143, $id_uzytkownika='', $haslo_uzytkownika='') {
        $this->serwer = $serwer;
        $this->protokol = $protokol;
        $this->port = $port;
        $this->id_uzytkownika = $id_uzytkownika;
        $this->haslo_uzytkownika = $haslo_uzytkownika;
        $this->skrzynka = imap_utf7_encode($GLOBALS["skrzynka"]);
                
        $this->usuwana_skrzynka = imap_utf7_encode($GLOBALS["usuwana_skrzynka"]);
        $this->stara_skrzynka = imap_utf7_encode($GLOBALS["stara_skrzynka"]);
        $this->nowa_skrzynka = imap_utf7_encode($GLOBALS["nowa_skrzynka"]);

        $this->numer_listu = $GLOBALS["numer_pozycji"];
        $this->uid_listu = $GLOBALS["uid_pozycji"];
        $this->nazwa_pliku = $GLOBALS["nazwa_pliku"];
        $this->numer_czesci = $GLOBALS["nr_czesci"];

        if(isset($GLOBALS["sortuj"])) $this->sortowanie = $GLOBALS["sortuj"];
        if(isset($GLOBALS["odwrotnie"])) $this->odwrocone = $GLOBALS["odwrotnie"];
                
        if(!in_array($this->protokol, $this->obslugiwane_protokoly)) {
            $this->utworz_komunikat_o_bledzie($this->BLAD_NIEOBSLUGIWANY_PROTOKOL, $this->protokol);
            return false;
        }
                
        if($this->protokol == 'nntp' && empty($this->skrzynka)) $tryb = OP_HALFOPEN;
        else $tryb = false;
        $this->strumien = @imap_open("\{$this->serwer/$this->protokol:$this->port}$this->skrzynka", $this->id_uzytkownika, $this->haslo_uzytkownika, $tryb);
                
        if(!$this->strumien) {
            $this->utworz_komunikat_o_bledzie($this->BLAD_POLACZENIE_NIEUDANE, imap_last_error());
            return false;
        }
        
        return true;
    }

    function start() {
        $this->utworz_komunikat_o_bledzie($this->BLAD_NIEPRZESLONIETA_METODA_START);
        return false;
    }
        
    function pobierz_naglowki_listow($operacja_odczytu, $operacja_wysylki) {
        $listy = @imap_sort($this->strumien, $this->sortowanie, $this->odwrocone, SE_NOPREFETCH);
                
        if(!is_array($listy)) return false;
                
        for($i=0; $i < count($listy); $i++) {
            $lista = @imap_header($this->strumien, $numer_listu);
            $tab[$i]["no"] = $numer_listu = $listy[$i];
            $tab[$i]["uid"] = $uid_listu = imap_uid($this->strumien, $numer_listu);
                        
            if($lista->nieczytany == 'U' || $lista->nowy == 'R') $tab[$i]["nieczytany"] = true;
            else $tab[$i]["nieczytany"] = false;
                        
            $tab[$i]["data"] = gmstrftime("%b %d %Y", strtotime($lista->data));
                        
            $struktura = @imap_fetchstructure($this->strumien, $numer_listu);
            $liczba_czesci = count($struktura->czesci) - 1;
            if($liczba_czesci > 0) $przedrostek_listu = "@";
            else $przedrostek_listu = '';
                        
            if(empty($lista->temat)) $tab[$i]["temat"] = $this->zbuduj_adres_url("$operacja_odczytu&msg_uid=$uid_listu&mailbox=$this->skrzynka", $this->BRAK_TEMATU);
            else {
                $temat_listu = $this->odkoduj_naglowek($lista->temat);
                $tab[$i]["temat"] = $this->zbuduj_adres_url("$operacja_odczytu&msg_uid=$uid_listu&mailbox=$this->skrzynka", "$przedrostek_listu$temat_listu");
            }
                        
            if(empty($lista->nadawca)) $tab[$i]["nadawca"] = $this->BRAK_POLA_FROM;
            else $tab[$i]["nadawca"] = $this->utworz_adres($lista->nadawca, "$operacja_wysylki&msg_uid=$uid_listu&mailbox=$this->skrzynka"); 
        }
                
        return $tab;
    }   

    function utworz_adres($adresy_email, $operacja) 
    {
        if(!is_array($adresy_email)) return;
            foreach($adresy_email as $adres_email) {
                $osobiste = $this->odkoduj_naglowek($adres_email->osobiste);
                $adres = $adres_email->skrzynka . "@" . $adres_email->serwer;
                if(!empty($osobiste)) $tab[] = $this->zbuduj_adres_url("$operacja&email=$adres", $osobiste); 
                else $tab[] = $this->zbuduj_adres_url("$operacja&email=$adres", $adres);
            }
            return implode(',', $tab);
        }

        function odkoduj_naglowek($arg) 
        {
            $tabl_zdekodowana = imap_mime_header_decode($arg);
                
            foreach($tabl_zdekodowana as $obiekt) $tab[]= $obiekt->tekst;
            if(count($tab) >0) return implode('', $tab);
            else return $arg;
        }

        function pobierz_list($operacja_pobierania, $operacja_wysylki) 
        {
            if(!$this->uid_listu) {
                $this->utworz_komunikat_o_bledzie($this->BLAD_MIEPOPRAWNY_UID_ARTYKULU, imap_last_error());
                return false;
            }
                
            $numer_listu = imap_msgno($this->strumien, $this->uid_listu);
                
            $naglowki = @imap_header($this->strumien, $numer_listu);
            if(!$naglowki) {
                $this->utworz_komunikat_o_bledzie($this->BLAD_NIEPOPRAWNY_NR_ARTYKULU, imap_last_error());
                return false;
             }
                
             $tab["data"] = gmstrftime ("%b %d %Y %H:%M:%S", strtotime($naglowki->data));
                
             $tab["surowe_from"] = $this->odkoduj_naglowek($naglowki->adres_nadawcy);
             $tab["surowa_kopia"] = $this->odkoduj_naglowek($naglowki->adres_ukrytej_kopii);
             $tab["nadawca"] = $this->utworz_adres($naglowki->nadawca, "$operacja_wysylki&msg_uid=$this->uid_listu&mailbox=$this->skrzynka");
             $tab["kopia"] = $this->utworz_adres($naglowki->kopia, "$operacja_wysylki&msg_uid=$this->uid_listu&mailbox=$this->skrzynka");
             $tab["temat"] = $this->odkoduj_naglowek($naglowki->temat);
                
             if(empty($tab["temat"])) $tab["temat"] = $this->BRAK_TEMATU;
             $tab["id_pozycji"] = $naglowki->id_listu;
             $tab["dotyczy"] = $naglowki->dotyczy;
                
             $struktura = @imap_fetchstructure($this->strumien, $this->uid_listu, FT_UID);
                
             $tab["liczba_czesci"] = count($struktura->czesci) - 1;
             $html = 0;
                
             if($struktura->czesci[0]->kodowanie == 3) {
                 $tab["tresc"] = imap_base64(imap_fetchbody($this->strumien, $this->uid_listu, 1, FT_UID));
                 if(strtolower($struktura->czesci[0]->podtyp) == 'html') $html = 1;
                 }
             else {
                  if($struktura->czesci[0]->kodowanie == 4) {
                      $tab["tresc"] = imap_qprint(imap_fetchbody($this->strumien, $this->uid_listu, 1, FT_UID));
                      if(strtolower($struktura->czesci[0]->podtyp) == 'html') $html = 1;
                  }
                  else if($struktura->kodowanie == 3) {
                  $tab["tresc"] = imap_base64(imap_fetchbody($this->strumien, $this->uid_listu, 1, FT_UID));
                  if(strtolower($struktura->podtyp) == 'html') $html = 1;
                  }
                  else if($struktura->kodowanie == 4) {
                      $tab["tresc"] = imap_qprint(imap_fetchbody($this->strumien, $this->uid_listu, 1, FT_UID));
                      if(strtolower($struktura->podtyp) == 'html') $html = 1;
                  }
              else {
                  $tab["tresc"] = imap_fetchbody($this->strumien, $this->uid_listu, 1, FT_UID);
                  if(strtolower($struktura->podtyp) == 'html') $html = 1;               
              } 
            }
                
            if(!$html) {
                  $tab["tresc"] = str_replace("\r\n", "<BR>", $tab["tresc"]);
                  $tab["tresc"] = eregi_replace( "http://([-a-z0-9\_\./~@?=%(&amp;)|]+)", "<A HREF=\"http://\\1\">http://\\1</A>", $tab["tresc"]);
                  $tab["tresc"] = eregi_replace( "ftp://([-a-z0-9\_\./~@?=%&amp;]+)", "<A HREF=\"ftp://\\1\">ftp://\\1</A>", $tab["tresc"]);
                  $tab["tresc"] = eregi_replace( "([-a-z0-9\_\.]+)@([-a-z0-9\_\.]+)", "<A HREF=\"$PHP_SELF?$operacja_wysylki&email=\\1@\\2\">\\1@\\2</A>", $tab["tresc"]);
                }
                
                
                for($i=0; $i< count($struktura->czesci); $i++) {
                
                
                foreach($struktura->czesci[$i]->parametry as $atr) 
                        if($atr->atrybut == 'NAME') {
                           $nazwa_pliku = $this->odkoduj_naglowek($atr->wartosc);
                           break;
                        }
                        $tab["czesci"][$i] = $this->zbuduj_adres_url("$operacja_pobierania&mailbox=$this->skrzynka&msg_uid=$this->uid_listu&part_no=$i&filename=$nazwa_pliku", $nazwa_pliku);
            }
                
            return $tab;
        }   

        function pobierz_zalacznik() 
        {
            $struktura = @imap_fetchstructure($this->strumien, $this->uid_listu, FT_UID);
            if(!$struktura) {
                $this->utworz_komunikat_o_bledzie($this->BLAD_MIEPOPRAWNY_UID_ARTYKULU . $this->UID_listu, imap_last_error());
                return false;
            }
        
            switch ($struktura->czesci[$this->numer_czesci]->typ) {
            case 0: $typ = 'text';
                break;
                case 1: $typ = 'multipart';
                break;
            case 2: $typ = 'message';
                break;
            case 3: $typ = 'application';
                break;
            case4: $typ = 'audio';
                break;
            case 5: $typ = 'image';
                break;
            case 6: $typ = 'video';
                break;
            default: $typ = 'other';
                break;
            }
                
            $podtyp = $struktura->czesci[$this->numer_czesci]->podtyp;
            header("Content-Type: $typ/$podtyp");
            header("Content-Disposition: ;filename=$this->nazwa_pliku");
        
            if($struktura->czesci[$this->numer_czesci]->kodowanie == 3) { // Zakodowane BASE64
                echo @imap_base64(imap_fetchbody($this->strumien, $this->uid_listu, $this->numer_czesci+1, FT_UID));
            } else if($struktura->czesci[$this->numer_czesci]->kodowanie == 4) {  // QUOTED_PRINTABLE
                echo @imap_qprint(imap_fetchbody($this->strumien, $this->uid_listu, $this->numer_czesci+1, FT_UID));
            } else echo @imap_fetchbody($this->strumien, $this->uid_listu, $this->numer_czesci+1, FT_UID);
                
            return true;
        }

        function pobierz_zawartosc_skrzynki($ref='', $zwroc_postac_surowa=0) {
            if($this->protokol == 'pop3') {
                if($zwroc_postac_surowa) { 
                    return $surowa_tablica_skrzynki = array("\{$this->serwer}INBOX");
                } else {
                    $tablica_skrzynek['INBOX'] = 0;
                    return $tablica_skrzynek; 
                }
            }
                
            else if($this->protokol =='nntp') $skrzynki = @imap_listmailbox($this->strumien,"\{$this->serwer/$this->protokol:$this->port}", "*");
            else $skrzynki = @imap_listmailbox($this->strumien,"\{$this->serwer}$ref", "*");
                
            if(!$skrzynki) { 
                $this->utworz_komunikat_o_bledzie($this->BLAD_FOLDER_NIEDOSTEPNY, imap_last_error());
                return false;
            }
                
            foreach($skrzynki as $skrz) {
                $nazwa_skrzynki = imap_utf7_decode(eregi_replace("\{.*\}", "", $skrz));
                
                $surowa_tablica_skrzynki[] = $nazwa_skrzynki;
                
                if($this->protokol=='nntp') $stan = @imap_status($this->strumien, $skrz, SA_UNSEEN);
                else $stan = @imap_status($this->strumien, $skrz, SA_UNSEEN);
                if(!$stan) {
                    $this->utworz_komunikat_o_bledzie($this->BLAD_STANU_FOLDERA, imap_last_error());
                    return false;
                }
                
                $tablica_skrzynek[$nazwa_skrzynki] = $stan->nieczytany;
            }
                
            if($zwroc_postac_surowa) return $surowa_tablica_skrzynki;
            else return $tablica_skrzynek;
        }
        
        function utworz_skrzynke() {
            if($this->protokol == 'nntp' || $this->protokol == 'pop3' || $this->nowa_skrzynka == 'INBOX') {
                $this->utworz_komunikat_o_bledzie($this->BLAD_NIE_MOZNA_UTWORZYC_FOLDERU, $this->nowa_skrzynka);
                return false;
            }
            if(!@imap_createmailbox($this->strumien, "{\$this->serwer}$this->nowa_skrzynka")) {
                $this->utworz_komunikat_o_bledzie($this->BLAD_NIE_MOZNA_UTWORZYC_FOLDERU, imap_last_error());
                return false; 
            }
                
            return true;
        }
        
        function zmien_nazwe_skrzynki() {
            if($this->protokol == 'nntp' || $this->protokol == 'pop3' || $this->nowa_skrzynka == 'INBOX') {
                $this->utworz_komunikat_o_bledzie($this->BLAD_NIE_MOZNA_ZMIENIC_NAZWY_FOLDERU, $this->nowa_skrzynka);
                return false;
            }
                
            if(!@imap_renamemailbox($this->strumien, "{\$this->serwer}$this->stara_skrzynka", "{\$this->serwer}$this->nowa_skrzynka")) {
                $this->utworz_komunikat_o_bledzie($this->BLAD_NIE_MOZNA_ZMIENIC_NAZWY_FOLDERU, imap_last_error());
                return false; 
            }
                
            return true;
        }
        
        function usun_skrzynke() {
            if($this->protokol == 'nntp' || $this->protokol == 'pop3' || $this->usuwana_skrzynka == 'INBOX') {
                $this->utworz_komunikat_o_bledzie($this->BLAD_NIE_MOZNA_USUNAC_FOLDERU, $this->usuwana_skrzynka);
                return false;
            }
                
            if(!@imap_deletemailbox($this->strumien, "{\$this->serwer}$this->usuwana_skrzynka")) {
                $this->utworz_komunikat_o_bledzie($this->BLAD_NIE_MOZNA_USUNAC_FOLDERU, imap_last_error());             return false;     
            }
                
            return true;
        }       
           
        function zbuduj_adres_url($opcje, $lacze, $onclick='') 
        {
            global $PHP_SELF;
                
            if(!empty($onclick)) $onclick = " OnClick=\"$onclick\"";
        
            return "<A HREF=\"$PHP_SELF?$opcje\"$onclick>$lacze</A>" ;
        }

        function koniec() 
        {
            if($this->automatyczne_oczyszczanie) $wynik = @imap_close($this->strumien, CL_EXPUNGE);
            else $wynik = @imap_close($this->strumien);
                
            if(!$wynik) {
                $this->utworz_komunikat_o_bledzie($this->BLAD_ZAMKNIECIE_NIEUDANE, imap_last_error());
                return false;
            }
            return true;
        }

        function utworz_komunikat_o_bledzie($komunikat, $argument_komunikatu='') 
        {
            $this->KOMUNIKAT_O_BLEDZIE = $komunikat . $this->BLAD_SEPARATORA_ARGUMENTOW . $argument_komunikatu;
        }
        
        function komunikat_o_bledzie() 
        {
            return $this->KOMUNIKAT_O_BLEDZIE;
        }
}
?>
