<?php

//klasa_webmail-wersja2.php 

class Webmail {
    var $sortowanie = SORTDATE;
    var $odwrocone = 0;

    var $serwer = '';
    var $protokol = 'imap';
    var $obslugiwane_protokoly = array('imap', 'pop3', 'nntp');
    var $port = 143;
    var $id_uzytkownika = '';
    var $haslo_uzytkownika = '';
    var $strumien = 0;
    var $skrzynka = '';
    var $automatyczne_oczyszczanie = 1;

    var $BLAD_STANU_FOLDERA = 'Nie mona odczyta stanu skrzynki!';
    var $BRAK_TEMATU = 'BRAK TEMATU';
    var $BRAK_POLA_FROM = 'NIEZNANY';
    var $BLAD_POLACZENIE_NIEUDANE = 'Poczenie nieudane!';
    var $BLAD_NIEOBSLUGIWANY_PROTOKOL = 'Wybrany protok nie jest obsugiwany!';
    var $BLAD_ZAMKNIECIE_NIEUDANE = 'Bd zamknicia strumienia!';
    var $BLAD_FOLDER_NIEDOSTEPNY = 'Skrzynka niedostepna!';
    var $BLAD_NIEPRZESLONIETA_METODA_START = "Naley przesoni metod start()!";       
    var $BLAD_SEPARATORA_ARGUMENTOW = " ";
    var $KOMUNIKAT_O_BLEDZIE = '';
        
    function inicjacja($serwer, $protokol='imap', $port=143, $id_uzytkownika='', $haslo_uzytkownika='') {
        $this->serwer = $serwer;
        $this->protokol = $protokol;
        $this->port = $port;
        $this->id_uzytkownika = $id_uzytkownika;
        $this->haslo_uzytkownika = $haslo_uzytkownika;
        $this->skrzynka = $GLOBALS["skrzynka"];

        if(isset($GLOBALS["sortuj"])) $this->sortowanie = $GLOBALS["sortuj"];
        if(isset($GLOBALS["odwrotnie"])) $this->odwrocone = $GLOBALS["odwrotnie"];
    
        if(!in_array($this->protokol, $this->obslugiwane_protokoly)) {
            $this->utworz_komunikat_o_bledzie($this->BLAD_NIEOBSLUGIWANY_PROTOKOL, $this->protokol);
            return false;
        }
                
        if($this->protokol == 'nntp' && empty($this->skrzynka)) $tryb = OP_HALFOPEN;
        else $tryb = false;
        $this->strumien = @imap_open("\{$this->serwer/$this->protokol:$this->port}$this->skrzynka", $this->id_uzytkownika, $this->haslo_uzytkownika, $tryb);
                
        if(!$this->strumien) {
            $this->utworz_komunikat_o_bledzie($this->BLAD_POLACZENIE_NIEUDANE, imap_last_error());
            return false;
        }
        return true;
    }

    function start() {
            $this->utworz_komunikat_o_bledzie($this->BLAD_NIEPRZESLONIETA_METODA_START);
            return false;
    }

    function pobierz_naglowki_listow($operacja_odczytu, $operacja_wysylki) {
	// $this->strumien = imap_open("{news.php.net/nntp}php.test", '', '');
        $listy = @imap_sort($this->strumien, $this->sortowanie, $this->odwrocone, SE_NOPREFETCH);
        if(!is_array($listy)) return false;
                
        for($i=0; $i < count($listy); $i++) {
            $tab[$i]["no"] = $numer_listu = $listy[$i];
            $list = @imap_header($this->strumien, $numer_listu);
            $tab[$i]["uid"] = $uid_listu = imap_uid($this->strumien, $numer_listu);
        
            if($list->Unseen == 'U' || $list->Recent == 'R') $tab[$i]["nieczytany"] = true;
            else $tab[$i]["nieczytany"] = false;
                        
            $tab[$i]["data"] = gmstrftime("%b %d %Y", strtotime($list->Date));
        
            $struktura = @imap_fetchstructure($this->strumien, $numer_listu);
            $liczba_czesci = count($struktura->parts) - 1;
            
            if($liczba_czesci > 0) $przedrostek_listu = "@";
            else $przedrostek_listu = '';
                        
            if(empty($list->Subject)) {
                $tab[$i]["temat"] = $this->zbuduj_adres_url("$operacja_odczytu&msg_uid=$uid_listu&mailbox=$this->skrzynka", $this->BRAK_TEMATU);
            } else {
                $temat_listu = $this->odkoduj_naglowek($list->Subject);
                $tab[$i]["temat"] = $this->zbuduj_adres_url("$operacja_odczytu&msg_uid=$uid_listu&mailbox=$this->skrzynka", "$przedrostek_listu$temat_listu");
            }
                        
            if(empty($list->from)) 
                $tab[$i]["nadawca"] = $this->BRAK_POLA_FROM;
            else 
                $tab[$i]["nadawca"] = $this->utworz_adres($list->from, "$operacja_wysylki&msg_uid=$uid_listu&mailbox=$this->skrzynka"); 
            }
                
            return $tab;
    }   

    function utworz_adres($adresy_email, $operacja) {
        if(!is_array($adresy_email)) return;
        foreach($adresy_email as $adres_email) {
            $osobiste = $this->odkoduj_naglowek($adres_email->personal);
            $adres = $adres_email->mailbox . "@" . $adres_email->host;
            if(!empty($osobiste)) $tab[] = $this->zbuduj_adres_url("$operacja&email=$adres", $osobiste); 
            else $tab[] = $this->zbuduj_adres_url("$operacja&email=$adres", $adres);
        }
        return implode(',', $tab);
    }

    function odkoduj_naglowek($arg) {
        $tabl_zdekodowana = imap_mime_header_decode($arg);
                
        foreach($tabl_zdekodowana as $obiekt) $tab[]= $obiekt->text;
        if(count($tab) >0) return implode('', $tab);
        else return $arg;
    }
   
    function zbuduj_adres_url($opcje, $lacze, $onclick='') {
        global $PHP_SELF;
                
        if(!empty($onclick)) $onclick = " OnClick=\"$onclick\"";
                
        return "<A HREF=\"$PHP_SELF?$opcje\"$onclick>$lacze</A>" ;
    }

    function koniec() {
        if($this->automatyczne_oczyszczanie) $wynik = @imap_close($this->strumien, CL_EXPUNGE);
        else $wynik = @imap_close($this->strumien);
                
        if(!$wynik) {
            $this->utworz_komunikat_o_bledzie($this->BLAD_ZAMKNIECIE_NIEUDANE, imap_last_error());
            return false;
        }
        return true;
    }

    function utworz_komunikat_o_bledzie($komunikat, $argument_komunikatu='') {
        $this->KOMUNIKAT_O_BLEDZIE = $komunikat . $this->BLAD_SEPARATORA_ARGUMENTOW . $argument_komunikatu;
    }
        
    function komunikat_o_bledzie() {
        return $this->KOMUNIKAT_O_BLEDZIE;
    }
}
?>
