<?php

// klasa_webmail-test3.php

include("./klasa_webmail-wersja3.php");

class MojWebmail extends Webmail {
    function start($operacja) {
        switch($operacja) {
        case 'odczytaj_pozycje':
            $lista = $this->odczytaj_pozycje();
            if(!$lista) return false;
            echo $lista;
            break;
        case 'pobierz_zalacznik':
            if(!$this->pobierz_zalacznik()) return 0;
            break;
        default:
            $listy = $this->pobierz_naglowki_listow('operacja=odczytaj_pozycje','operacja=formularz_listu');
            if(!$listy) return false;
            foreach($listy as $lista) echo $lista["temat"] . " - " . $lista["nadawca"] . "<BR>";
            break;
        }
    }

    function odczytaj_pozycje() {
        $lista = $this->pobierz_list('operacja=pobierz_zalacznik', 'operacja=formularz_listu&tryb=odpowiedz');

        if(!$lista) return 0;
        $tekst_wynikowy = "<STRONG>Nadawca: </STRONG>" . $lista["nadawca"] . "<BR>\n";
        if(!empty($lista["kopia"])) $tekst_wynikowy .= "<STRONG>Kopia: </STRONG>" . $lista["kopia"] . "<BR>\n";
        $tekst_wynikowy .= "<STRONG>Temat: </STRONG>" . $lista["temat"] . "<BR>\n";
        $tekst_wynikowy .= "<BR><BR>\n";

        $tekst_wynikowy .= "<BLOCKQUOTE>" . $lista["tresc"] . "</BLOCKQUOTE><BR>\n";

        if($lista["liczba_czesci"] > 0) {
            $tekst_wynikowy .= "<CENTER><HR WIDTH=\"90%\" SIZE=\"1\"></CENTER>\n";
        for($i = 0; $i < count($lista["czesci"]); $i++) $tekst_wynikowy .= $lista["czesci"][$i] . "<BR>\n";
    }
    return $tekst_wynikowy;
    }

}

$serwer = "cokolwiek.com";
$protokol = "imap";
$port = 143;
$id_uzytkownika = "jkowalski";
$haslo_uzytkownika = "12345";

$program_pocztowy = new MojWebmail();

if(!$program_pocztowy->inicjacja($serwer, $protokol, $port, $id_uzytkownika, $haslo_uzytkownika)) echo $program_pocztowy->komunikat_o_bledzie();

if(!$program_pocztowy->start($operacja)) echo $program_pocztowy->komunikat_o_bledzie();

$program_pocztowy->koniec();
?>
