<?php

// klasa_pocztowa_smtp.php

include("./klasa_pocztowa.php");

class KlasaPocztowaSMTP extends KlasaPocztowa 
{
    var $serwer_smtp = '';
    var $port_smtp = 25;
    var $gniazdo = 0;
	
    var $kod_odpowiedzi = 0;
    var $komunikat_odpowiedzi = '';
	
    var $BLAD_NIEUSTAWIONY_SERWER_SMTP = 'Serwer SMTP nie zosta ustawiony!';
    var $BLAD_POLACZENIA_SMTP = 'Poczenie z okreslonym serwerem SMTP zakoczyo si niepowodzeniem!';
    var $BLAD_BRAK_POLACZENIA_SMTP = 'Przed wykonaniem operacji naley nawiza poczenie z serwerem SMTP!';
	
    var $BLAD_NIEROZPOZNANE_POLECENIE = 'Nierozpoznane polecenie!';
    var $BLAD_POLECENIE_HELO_BEZ_ARGUMENTU = 'Polecenie HELO wymaga argumentu!';
    var $BLAD_POLECENIE_MAIL_BEZ_ARGUMENTU = 'Polecenie MAIL FROM wymaga argumentu!';
    var $BLAD_POLECENIE_RCPT_BEZ_ARGUMENTU = 'Polecenie RCPT TO wymaga argumentu!';
    var $BLAD_POLECENIE_DATA_BEZ_ARGUMENTU = 'Wywoanie polecenia DATA z pust treci listu!';
	
    var $BLAD_NIEROZPOZNANA_ODPOWIEDZ_SERWERA = 'Nierozpoznana odpowied serwera!';
    var $BLAD_NIEUDANE_POLECENIE_HELO = 'Polecenie HELO zakoczone niepowodzeniem!';
    var $BLAD_NIEUDANE_POLECENIE_MAIL = 'Polecenie MAIL FROM zakoczone niepowodzeniem!';
    var $BLAD_NIEUDANE_POLECENIE_RCPT = 'Polecenie RCPT TO zakoczone niepowodzeniem!';
    var $BLAD_NIEUDANE_POLECENIE_DATA = 'Polecenie DATA zakoczyo si niepowodzeniem!';
    var $BLAD_NIEUDANE_POLECENIE_QUIT = 'Polecenie QUIT zakoczone niepowodzeniem!';
    var $BLAD_INICJACJI_GNIAZDA = "Nie mona zainicjowac gniazda komunikacyjnego!";

    function polacz() 
    {
        if(empty($this->serwer_smtp)) {
	    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEUSTAWIONY_SERWER_SMTP;
	    return false;
	}
		
	$this->gniazdo = fsockopen($this->serwer_smtp, $this->port_smtp, &$numer_bledu, &$komunikat_o_bledzie);
	
	if(!$this->gniazdo) {
            if(!$numer_bledu) {
	        $komunikat_o_bledzie = $this->BLAD_INICJACJI_GNIAZDA;
	    }	
	    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_POLACZENIA_SMTP . " $numer_bledu: $komunikat_o_bledzie";
	    return false;
	}

        if(!$this->pobierz_odpowiedz()) {
	    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEROZPOZNANA_ODPOWIEDZ_SERWERA . ":" . $this->komunikat_odpowiedzi;
	    return false;
	}
		
	if($this->kod_odpowiedzi != 220) {
			$this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_POLACZENIA_SMTP . " " . $this->kod_odpowiedzi . " " . $this->komunikat_odpowiedzi;
			return false;
	}
	return true;
    }

    function pobierz_odpowiedz() 
    {
        if(!$this->gniazdo) {
	    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_BRAK_POLACZENIA_SMTP;
	    return false;
	}
	
	$odpowiedz_serwera = fgets($this->gniazdo, 1024);
	if(ereg("^([0-9]{3}) (.*)$", $odpowiedz_serwera, $dopasowanie)) {
	    $this->kod_odpowiedzi = $dopasowanie[1];
	    $this->komunikat_odpowiedzi = $dopasowanie[2];
	    return true;
	}

	$this->komunikat_odpowiedzi = $odpowiedz_serwera;
	return false;
    }

    function polecenie($polecenie, $arg='') 
    {
        if(!$this->gniazdo) {
	    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_BRAK_POLACZENIA_SMTP;
	    return false;
	}
	
	switch ($polecenie) {
		
        case "HELO":
	    if(empty($arg)) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_POLECENIE_HELO_BEZ_ARGUMENTU;
		return false;
	    }
	    $polecenie_smtp = "HELO $arg\r\n";
	    fwrite($this->gniazdo, $polecenie_smtp);
	    if(!$this->pobierz_odpowiedz()) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEROZPOZNANA_ODPOWIEDZ_SERWERA . ":" . $this->komunikat_odpowiedzi;
		return false;
	    }
				
	    if($this->kod_odpowiedzi != 250) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEUDANE_POLECENIE_HELO . " " . $this->kod_odpowiedzi . " " . $this->komunikat_odpowiedzi;
		return false;
	    }
	    break;
			
        case "MAIL":
            if(empty($arg)) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_POLECENIE_MAIL_BEZ_ARGUMENTU;
	        return false;
	    }
	    $polecenie_smtp = "MAIL FROM: $arg\r\n";
	    fwrite($this->gniazdo, $polecenie_smtp);
				
	    if(!$this->pobierz_odpowiedz()) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEROZPOZNANA_ODPOWIEDZ_SERWERA . ":" . $this->komunikat_odpowiedzi;
	        return false;
	    }
				
	    if($this->kod_odpowiedzi != 250) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEUDANE_POLECENIE_MAIL . " " . $this->kod_odpowiedzi . " " . $this->komunikat_odpowiedzi;
		return false;
	    }
			
	    break;
			
			
        case "RCPT":
	    if(empty($arg)) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_POLECENIE_RCPT_BEZ_ARGUMENTU;
	        return false;
	    }
		
            $adresy_adresatow = explode(",", $arg);
				
	    foreach($adresy_adresatow as $adres_email) {
	        $polecenie_smtp = "RCPT TO: $adres_email\r\n";
	        fwrite($this->gniazdo, $polecenie_smtp);
				
		if(!$this->pobierz_odpowiedz()) {
		    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEROZPOZNANA_ODPOWIEDZ_SERWERA . ":" . $this->komunikat_odpowiedzi;
		    return false;
		}
					
		if($this->kod_odpowiedzi != 250) {
		    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEUDANE_POLECENIE_RCPT . " " . $this->kod_odpowiedzi . " " . $this->komunikat_odpowiedzi;
		    return false;
		}
            }
				
	    break;
			
        case "DATA":
	    if(empty($arg)) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_POLECENIE_DATA_BEZ_ARGUMENTU;
		return false;
	    }
		
            $polecenie_smtp = "DATA\r\n";
	    fwrite($this->gniazdo, $polecenie_smtp);;
		
	    if(!$this->pobierz_odpowiedz()) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEROZPOZNANA_ODPOWIEDZ_SERWERA . ":" . $this->komunikat_odpowiedzi;
		return false;
	    }
				
	    if($this->kod_odpowiedzi != 354) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEUDANE_POLECENIE_DATA . " " . $this->kod_odpowiedzi . " " . $this->komunikat_odpowiedzi;
		return false;
	    }
				
	    $polecenie_smtp = "$arg\r\n" . "." . "\r\n";
	    fwrite($this->gniazdo, $polecenie_smtp);
		
	    if(!$this->pobierz_odpowiedz()) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEROZPOZNANA_ODPOWIEDZ_SERWERA . ":" . $this->komunikat_odpowiedzi;
		return false;
	    }
	    
            if($this->kod_odpowiedzi != 250) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEUDANE_POLECENIE_DATA . " " . $this->kod_odpowiedzi . " " . $this->komunikat_odpowiedzi;
		return false;
	    }
				
	    break;
			
	case "QUIT":
	    $polecenie_smtp = "QUIT\r\n";
	    fwrite($this->gniazdo, $polecenie_smtp);
		
	    if(!$this->pobierz_odpowiedz()) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEROZPOZNANA_ODPOWIEDZ_SERWERA . ":" . $this->komunikat_odpowiedzi;
		return false;
	    }
				
	    if($this->kod_odpowiedzi != 221) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEUDANE_POLECENIE_QUIT . " " . $this->kod_odpowiedzi . " " . $this->komunikat_odpowiedzi;
		return false;
	    }
				
	    break;
			
        default:
	    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEROZPOZNANE_POLECENIE;
	    return false;
		
	    break;
	    }

            return true;

    }

    function wyslij() 
    {

        if(!$this->sprawdz_pola()) return false;
		
	$this->utworz_naglowek();
		
	if(!$this->polacz()) return false;
		
	if(!$this->polecenie("HELO", $GLOBALNE["SERVER_NAME"])) return false;
	if(!$this->polecenie("MAIL", $this->nadawca)) return false;
	if(!$this->polecenie("RCPT", $this->adresat)) return false;
		
	if(!empty($this->adresat)) $this->naglowki[] = "To: $this->adresat";
	if(!empty($this->temat)) $this->naglowki[] = "Subject: $this->temat";
		
	if(!$this->polecenie("DATA", implode("\r\n", $this->naglowki) . "\r\n\r\n" . $this->tresc)) return false;
	if(!$this->polecenie("QUIT")) return false;
		
	fclose($this->gniazdo);
		
	return true;
   }
}
?>
