<?php

// klasa_pocztowa_mime.php

include("./klasa_pocztowa.php");

class KlasaPocztowaMIME extends KlasaPocztowa 
{
    var $typ = 'text/plain';
    var $zestaw_znakow = 'iso8859-2';
	
    var $kodowanie = '8bit';
	
    var $ma_zalaczniki = 0;
    var $pliki = array();
	
    var $typ_mime = 'application/octet-stream';
    var $wersja_mime = "MIME-Version: 1.0";
    var $list_mime = "This is a multi-part message in MIME format.";
	
    var $program_pocztowy = 'Aplikacja Pocztowa MIME 1.0';
	
    var $ogranicznik = '';
	
    var $BLAD_NIE_MOZNA_OTWORZYC_PLIKU = 'Nie mona otworzy okrelonego pliku!';

    function utworz_naglowek_mime() 
    {
        $this->naglowki[] = "X-Mailer: " . $this->program_pocztowy;
        $this->naglowki[] = $this->wersja_mime;
		
        if($this->ma_zalaczniki) {
            $this->ogranicznik = md5(uniqid(time()));
  	    $this->naglowki[] = "Content-Type: multipart/mixed; boundary=\"$this->ogranicznik\"\r\n";
	    $this->naglowki[] = $this->list_mime . "\r\n";
	    $this->naglowki[] = "--" . $this->ogranicznik;
        }
	
        $this->naglowki[] = "Content-Type: $this->typ; charset=$this->zestaw_znakow";
        $this->naglowki[] = "Content-Transfer-Encoding: $this->kodowanie";
	
    }


    function utworz_czesci_tresci() 
    {
        if(!$this->ma_zalaczniki) return true;
        $czesci_tresci[0] .= $this->tresc . "\r\n\r\n"; 
	
        for($i=0; $i < count($this->pliki); $i++) {
            if(!($uchwyt = @fopen($this->pliki[$i]["plik"], "r"))) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIE_MOZNA_OTWORZYC_PLIKU . " " . $this->pliki[$i]["plik"];
	        return false;
	    }
			
	$zawartosc_pliku = fread($uchwyt, filesize($this->pliki[$i]["plik"]));
	$zawartosc_pliku = chunk_split(base64_encode($zawartosc_pliku));
			
	$czesci_tresci[$i+1] = "--" . $this->ogranicznik . "\r\n";
			
	if(!empty($this->pliki[$i]["typ_pliku"])) $this->typ_mime = $this->pliki[$i]["typ_pliku"];
			
	    $czesci_tresci[$i+1] .= "Content-Type: " . $this->typ_mime . ";name=" . basename($this->pliki[$i]["nazwa_pliku"]) .  "\r\n";
	    $czesci_tresci[$i+1] .= "Content-Transfer-Encoding: base64\r\n\r\n";
	    $czesci_tresci[$i+1] .= $zawartosc_pliku . "\r\n\r\n";
	}
	
	$czesci_tresci[$i+1] .= "--" . $this->ogranicznik . "--";
	$this->tresc = implode("", $czesci_tresci);
		
	return true;
	
    }

    function wypisz_list() 
    {
        if(count($this->pliki) > 0) $this->ma_zalaczniki = true;
        if(!$this->sprawdz_pola()) return false;
		
        $this->naglowki = array();
        $this->utworz_naglowek();
		
        $this->naglowki[] = "From: $this->nadawca";
        $this->naglowki[] = "To: $this->adresat";
        $this->naglowki[] = "Subject: $this->temat";
		
        $this->utworz_naglowek_mime();
        if(!$this->utworz_czesci_tresci()) return false;
		
        $list = implode("\r\n", $this->naglowki);
		
        $list .= "\r\n\r\n";
        $list .= $this->tresc;
		
        return $list;
    }

    function wyslij() 
    {
        if(count($this->pliki) > 0) $this->ma_zalaczniki = true;
		
        if(!$this->sprawdz_pola()) return false;
		
        $this->temat = stripslashes(trim($this->temat));
        $this->tresc = stripslashes($this->tresc);
		
        $this->utworz_naglowek();
        $this->utworz_naglowek_mime();
        if(!$this->utworz_czesci_tresci()) return false;
		
        if(mail($this->adresat, $this->temat, $this->tresc, implode("\r\n", $this->naglowki))) return true;
        else {
            $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_WYSYLKI_LISTU;
            return false;
        }
    }
}
?>
