<?php

// klasa_pocztowa.php

class KlasaPocztowa 
{
    var $adresat = '';
    var $nadawca = '';
    var $adres_zwrotny = '';
    var $kopia = '';
    var $ukryta_kopia = '';
    var $temat = '';
    var $tresc = '';
	
    var $sprawdzenie_adresu = true;
    var $szczegolowe_sprawdzanie_adresow = false;

    var $dopuszczalny_pusty_temat = false;
    var $dopuszczalna_pusta_tresc = false;
	 
    var $naglowki = array();
	
    var $KOMUNIKAT_O_BLEDZIE;
	
    var $BLAD_PUSTE_POLE_ADRESATA = "Puste pole adresata!";
    var $BLAD_PUSTE_POLE_TEMATU = "Puste pole tematu!";
    var $BLAD_PUSTA_TRESC = "Puste pole treci!";
    var $BLAD_WYSYLKI_LISTU = "Bd podczas prby wysyki listu!";
    var $BLAD_NIEPRAWIDLOWE_POLE_ADRESATA = "Pole adresata zawiera nieprawidowe adresy e-mail!";
    var $BLAD_NIEPRAWIDLOWE_POLE_CC = "Pole Cc (kopia) zawiera nieprawidowe adresy e-mail!";
    var $BLAD_NIEPRAWIDLOWE_POLE_BCC = "Pole Bcc (kopia ukryta) zawiera nieprawidowe adresy e-mail!";
	
    var $BRAK_BLEDU = "Do tej pory nie wystpi aden bd.";

    function sprawdz_pola() 
    {
        if(empty($this->adresat)) {
	    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_PUSTE_POLE_ADRESATA;
	    return false;
	}
		
	if(!$this->dopuszczalny_pusty_temat && empty($this->temat)) {
	    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_PUSTE_POLE_TEMATU;
	    return false;
	}
		
	if(!$this->dopuszczalna_pusta_tresc && empty($this->tresc)) {
	    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_PUSTA_TRESC;
	    return false;
	}
		
        $this->adresat = ereg_replace(";", ",", $this->adresat);
	$this->kopia = ereg_replace(";", ",", $this->kopia);
	$this->ukryta_kopia = ereg_replace(";", ",", $this->ukryta_kopia);
		
	if(!empty($this->nadawca)) $this->naglowki[] = "From: $this->nadawca";
	if(!empty($this->adres_zwrotny)) $this->naglowki[] = "Reply-To: $this->adres_zwrotny";
		
	// Sprawdzamy adresy e-mail.
	if($this->sprawdzenie_adresu) {
	    $adresy_adresatow = explode(",", $this->adresat);
	    if(!empty($this->kopia)) $adresy_kopii = explode(",", $this->kopia);
	    if(!empty($this->ukryta_kopia)) $adresy_ukrytej_kopii = explode(",", $this->ukryta_kopia);
		
	    // Szczegowe sprawdzenie adreswH e-mail poprzez sprawdzenie istnienia domeny.
	    if($this->szczegolowe_sprawdzanie_adresow) {
	        if(!$this->szczegolowo_sprawdz_adresy($adresy_adresatow)) {
	            $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEPRAWIDLOWE_POLE_ADRESATA;
	            return false;
	        } 
	        else if(is_array($adresy_kopii) && !$this->szczegolowo_sprawdz_adresy($adresy_kopii)) {
	            $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEPRAWIDLOWE_POLE_CC;
	            return false;
	        }
	        else if(is_array($adresy_ukrytej_kopii) && !$this->szczegolowo_sprawdz_adresy($adresy_ukrytej_kopii)) {
	            $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEPRAWIDLOWE_POLE_BCC;
                    return false;
	        }
	    }else {
		if(!$this->sprawdz_adresy($adresy_adresatow)) {
		    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEPRAWIDLOWE_POLE_ADRESATA;
		    return false;
		}
		else if(is_array($adresy_kopii) && !$this->sprawdz_adresy($adresy_kopii)) {
		    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEPRAWIDLOWE_POLE_CC;
		    return false;
		}
		else if(is_array($adresy_ukrytej_kopii) && !$this->sprawdz_adresy($adresy_ukrytej_kopii)) {
		    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEPRAWIDLOWE_POLE_BCC;
		    return false;
		}
	    }
	}
	
	    return true;
    }

    function sprawdz_adresy($adresy_email) 
    {
        foreach($adresy_email as $adres_email) {
	    if(eregi("<(.+)>", $adresy_email, $dopasowanie)) $adres_email = $dopasowanie[1];
	    if(!eregi("^[_\-\.0-9a-z]+@([0-9a-z][_0-9a-z\.]+)\.([a-z]{2,4}$)", $adres_email)) return false;			
	}
	return true;
    }  

    function szczegolowo_sprawdz_adresy($adresy_email) 
    {
        if(!$this->sprawdz_adresy($adresy_email)) return false;
	
        foreach($adresy_email as $adres_email) {
            list ($uzytkownik, $domena) = split ( "@", $adres_email, 2 );  
	    if(checkdnsrr( $domena, "ANY"))  return true;
	    else {
	        return false;
	    }
	}

    }

    function utworz_naglowek() 
    {
        if(!empty($this->kopia)) $this->naglowki[] = "Cc: $this->kopia";
	if(!empty($this->ukryta_kopia)) $this->naglowki[] = "Bcc: $this->ukryta_kopia";
	
    }

    function wypisz_list() 
    {
        if(!$this->sprawdz_pola()) return false;
		
	$this->naglowki = array();
		
	$this->utworz_naglowek();
		
	$this->naglowki[] = "From: $this->nadawca";
	$this->naglowki[] = "To: $this->adresat";
	$this->naglowki[] = "Subject: $this->temat";
	
	$list = implode("\r\n", $this->naglowki);
	$list .= "\r\n\r\n";
	$list .= $this->tresc;
		
	return $list;
    }
   
    function wyslij() 
    {
        if(!$this->sprawdz_pola()) return 0;
		
	$this->utworz_naglowek();
		
	if(mail($this->adresat, stripslashes(trim($this->temat)), stripslashes($this->tresc), implode("\r\n", $this->naglowki))) return true;
	
        else {
	    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_WYSYLKI_LISTU;
	    return false;
	}
    }

    function komunikat_o_bledzie() 
    {
        if(empty($this->KOMUNIKAT_O_BLEDZIE)) 
        {
            return $this->BRAK_BLEDU;
	    return $this->KOMUNIKAT_O_BLEDZIE;
        }

    }
}
?>
