<?php

// klasa_nntp.php

include("./klasa_pocztowa_mime.php");

class KlasaNNTP extends KlasaPocztowaMIME
{
    var $serwer_nntp = '';
    var $port_nntp = 119;
    var $grupy_dyskusyjne = ''; 
	
    var $dotyczy = '';
	
    var $BLAD_NIEUSTAWIONY_SERWER_NNTP = 'Serwer NNTP nie zosta ustawiony!';
    var $BLAD_NIEUDANE_POLACZENIE_NNTP = 'Poczenie z okreslonym serwerem NNTP zakoczyo si niepowodzeniem!';
    var $BLAD_BRAK_POLACZENIA_NNTP = 'Przed wykonaniem operacji naley nawiza poczenie z serwerem NNTP!';
	
    var $BLAD_PUSTE_POLE_NADAWCY = "Puste pole nadawcy!";
    var $BLAD_PUSTE_POLE_GRUP_DYSKUSYJNYCH = "Nie okrelono grup dyskusyjnych!";
	
    var $BLAD_POLECENIE_GROUP_BEZ_ARGUMENTU = 'Polecenie GROUP wymaga argumentu!';
    var $BLAD_POLECENIE_POST_BEZ_ARGUMENTU = 'POlecenie POST zostao wywoane z pustum polem treci artykuu!';
	
    var $BLAD_NIEROZPOZNANA_ODPOWIEDZ_SERWERA = 'Nierozpoznana odpowied serwera!';
    var $BLAD_NIEDOZWOLONE_UMIESZCZANIE_ARTYKULOW  = "Publikownaie na tym serwerze jest zabronione!";
    var $BLAD_NIEDOZWOLONE_UMIESZCZANIE_ARTYKULOW_W_GRUPIE = "Publikowanie na tej grupie dyskusyjnej jest zabronione!";
    var $BLAD_NIEUDANE_POLECENIE_GROUP = 'Polecenie GROUP zakoczone niepowodzeniem!';
    var $BLAD_NIE_MA_TAKIEJ_GRUPY = 'Okrelona grupa nie istnieje!';
    var $BLAD_NIEUDANE_POLECENIE_POST = 'Polecenie POST zakoczone niepowodzeniem!';
    var $BLAD_NIEUDANE_POLECENIE_QUIT = 'Polecenie QUIT zakoczone niepowodzeniem!';

    function polacz() 
    {
        if(empty($this->serwer_nntp)) {
            $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEUSTAWIONY_SERWER_NNTP;
	    return false;
        }
		
        $this->gniazdo = fsockopen($this->serwer_nntp, $this->port_nntp, &$numer_bledu, &$komunikat_o_bledzie);
		
        if(!$this->gniazdo) {
            if(!$numer_bledu) $komunikat_o_bledzie = $this->BLAD_INICJACJI_GNIAZDA;
	    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEUDANE_POLACZENIE_NNTP . " $numer_bledu: $komunikat_o_bledzie";
	    return false;
        }
        if(!$this->pobierz_odpowiedz()) {
            $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEROZPOZNANA_ODPOWIEDZ_SERWERA . ":" . $this->komunikat_odpowiedzi;
	    return false;
        }
        if($this->kod_odpowiedzi == 200) return true;
        else if($this->kod_odpowiedzi == 201) {
            $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEDOZWOLONE_UMIESZCZANIE_ARTYKULOW; 
            return false;
        } else {
	    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEUDANE_POLACZENIE_NNTP;
	    return false;
        }
		
        return true;
    }

    function pobierz_odpowiedz() 
    {
        if(!$this->gniazdo) {
	    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_BRAK_POLACZENIA_NNTP;
	    return false;
	}
		
	$odpowiedz_serwera = fgets($this->gniazdo, 1024);
	if(ereg("^([0-9]{3}) (.*)$", $odpowiedz_serwera, $dopasowanie)) {
	    $this->kod_odpowiedzi = $dopasowanie[1];
	    $this->komunikat_odpowiedzi = $dopasowanie[2];
	    return true;
	}
		
	$this->komunikat_odpowiedzi = $odpowiedz_serwera;
	return false;
    }


    function polecenie($polecenie, $arg='') 
    {
        if(!$this->gniazdo) {
	    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_BRAK_POLACZENIA_NNTP;
	    return false;
	}

	switch ($polecenie) {
		
	case "GROUP":
            if(empty($arg)) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_POLECENIE_GROUP_BEZ_ARGUMENTU;
		return false;
	    }
            $polecenie_nntp = "GROUP $arg\r\n";
	    fwrite($this->gniazdo, $polecenie_nntp);
	    if(!$this->pobierz_odpowiedz()) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEROZPOZNANA_ODPOWIEDZ_SERWERA . ":" . $this->komunikat_odpowiedzi;
		return false;
	    }
	    if($this->kod_odpowiedzi != 211 && $this->kod_odpowiedzi != 411) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEUDANE_POLECENIE_GROUP . " " . $this->kod_odpowiedzi . " " . $this->komunikat_odpowiedzi;
		return false;
            }
	    if($this->kod_odpowiedzi == 411) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIE_MA_TAKIEJ_GRUPY . " " . $this->kod_odpowiedzi . " " . $this->komunikat_odpowiedzi . " " . $arg;
		return false;
	    }
			
	    break;
		
        case "POST":
	    if(empty($arg)) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_POLECENIE_POST_BEZ_ARGUMENTU;
		return false;
	    }
	    $polecenie_nntp = "POST\r\n";
	    fwrite($this->gniazdo, $polecenie_nntp);;
	    if(!$this->pobierz_odpowiedz()) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEROZPOZNANA_ODPOWIEDZ_SERWERA . ":" . $this->komunikat_odpowiedzi;
                return false;
	    }
	    if($this->kod_odpowiedzi != 340 && $this->kod_odpowiedzi != 440) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEUDANE_POLECENIE_POST . " " . $this->kod_odpowiedzi . " " . $this->komunikat_odpowiedzi;
	        return false;
	    }
		
	    if($this->kod_odpowiedzi == 440) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEDOZWOLONE_UMIESZCZANIE_ARTYKULOW_W_GRUPIE . " " . $this->kod_odpowiedzi . " " . $this->komunikat_odpowiedzi;
	        return false;
	    }
		
	    $polecenie_nntp = "$arg\r\n" . "." . "\r\n";
	    fwrite($this->gniazdo, $polecenie_nntp);
	    if(!$this->pobierz_odpowiedz()) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEROZPOZNANA_ODPOWIEDZ_SERWERA . ":" . $this->komunikat_odpowiedzi;
	        return false;
	    }
		
	    if($this->kod_odpowiedzi != 240) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEUDANE_POLECENIE_POST . " " . $this->kod_odpowiedzi . " " . $this->komunikat_odpowiedzi;
	        return false;
            }
		
	     break;

        case "QUIT":
	    $polecenie_nntp = "QUIT\r\n";
	    fwrite($this->gniazdo, $polecenie_nntp);
	    if(!$this->pobierz_odpowiedz()) {
                $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEROZPOZNANA_ODPOWIEDZ_SERWERA . ":" . $this->komunikat_odpowiedzi;
                return false;
	    }
	    if($this->kod_odpowiedzi != 205) {
	        $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEUDANE_POLECENIE_QUIT . " " . $this->kod_odpowiedzi . " " . $this->komunikat_odpowiedzi;
	        return false;
	    }
	    break;
	default:
	    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_NIEROZPOZNANE_POLECENIE;
	    return false;
	    break;
        }
		
    return true;
	
    }

    function utworz_naglowek() 
    {
        if(empty($this->nadawca)) {
            $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_PUSTE_POLE_NADAWCY;
	    return false;
	}
	else if(empty($this->temat)) {
	    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_PUSTE_POLE_TEMATU;
	    return false;      
	}
	else if(empty($this->tresc)) {
	    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_PUSTA_TRESC;
	    return false;
	}
	else if(empty($this->grupy_dyskusyjne)) {
	    $this->KOMUNIKAT_O_BLEDZIE = $this->BLAD_PUSTE_POLE_GRUP_DYSKUSYJNYCH;
	    return false;
	}
		
	$this->naglowki[]  = "From: $this->nadawca";
	if(!empty($this->adres_zwrotny)) $this->naglowki[]  = "Reply-To: $this->adres_zwrotny";
		
	if(!empty($this->dotyczy)) $this->naglowki[]  = "References: $this->dotyczy";
		
	$this->naglowki[]  = "Grupy: " . ereg_replace("[ ;]", ",", $this->grupy_dyskusyjne);
	$this->naglowki[] = "Subject: $this->temat";
	return true;
    }

    function wypisz_list() 
    {
        if(count($this->pliki) > 0) $this->ma_zalaczniki = true;
		
	$this->naglowki = array();
	$this->utworz_naglowek();
	
	$this->utworz_naglowek_mime();
		
	if(!$this->utworz_czesci_tresci()) return false;
		
	$list = implode("\r\n", $this->naglowki);
		
	$list .= "\r\n\r\n";
	$list .= $this->tresc;
		
	return $list;
    }

    function wyslij() 
    {
        if(count($this->pliki) > 0) $this->ma_zalaczniki = true;
		
	if(!$this->utworz_naglowek()) return false;
		
	$this->utworz_naglowek_mime();
	if(!$this->utworz_czesci_tresci()) return false;
		
	if(!$this->polacz()) return false;
		
	$this->grupy_dyskusyjne = ereg_replace("[ \t]", "", $this->grupy_dyskusyjne);
	
	$grupy_dyskusyjne = explode(",", $this->grupy_dyskusyjne);
		
	foreach ($grupy_dyskusyjne as $group) if(!$this->polecenie("GROUP", $group)) return false;
		
	if(!$this->polecenie("POST", implode("\r\n", $this->naglowki) . "\r\n\r\n" . $this->tresc)) return false;
		if(!$this->polecenie("QUIT")) return false;
		
	fclose($this->gniazdo);
		
	return true;
    }
}
?>
