<?php

set_time_limit(0);
// ieli zmienna rodowiska jest ustawiona, stosujemy j
if (getenv('SERVER_ADMIN')) {
    // staa definiujca haso poczenia anonimiowego
    define(
        'SERVER_ADMIN',
        getenv('SERVER_ADMIN')
    );
} else {
    // tworzymy rozsdn warto domyln
    define(
        'SERVER_ADMIN',
        'root@'  . getenv('SERVER_NAME')
    );
}


class WebowyKlientFtp 
{
    var 
        // poczenie FTP
        $polaczenie,
        // katalog biecy na serwerze FTP
        $biezaca_sciezka,
        // maksymalny rozmiar przesyanych plikw
        $maksymalny_rozmiar_pliku,
        // tryb transmisji (ASCII lub BINARY)
        $tryb,
        // typ systemu operacyjnego serwera FTP
        $typ_systemu,
        // systemowy katalog na pliki tymczasowe
        $katalog_tymczasowy = '/tmp';

    // konstruktor klasy
    function WebowyKlientFtp(
        // serwer, z ktrym nawizujemy poczenie
        $serwer,
        // nazwa uytkownika na zdalnym serwerze
        $uzytkownik = 'anonymous',
        // haso
        $haslo = SERVER_ADMIN,
        // port, z ktrym nawizujemy poczenie
        $port = 21
        ) {
        // czymy si z serwerem
        $uchwyt = ftp_connect(
            $serwer,
            $port
        );

        // poczenie nie udao si
        if (! $uchwyt) {
            user_error("Nie mona poczy si z serwerem '$serwer:$port'");
            return FALSE;
        }

        // prbujemy uwierzytelni poczenie
        $zalogowany = ftp_login(
            $uchwyt,
            $uzytkownik,
            $haslo
        );

        // uwierzytelnienie nie udao si
        if (! $zalogowany) {
            user_error("Nie mona uwierzytelni poczenia z serwerem '$serwer:$port'.\n");
            return FALSE;
        }

        // zapisujemy uchwyt udanego poczenie
        $this->polaczenie = $uchwyt;

        // rejestrujemy funkcje zamykajc poczenie
        // register_shutdown_function(create_function('', "ftp_quit($uchwyt);"));

        // pobieramy katalog biecy serwera FTP
        $this->biezaca_sciezka = ftp_pwd($this->polaczenie);

        // ustalamy maksymalny rozmiar przesyanych plikw
        $this->maksymalny_rozmiar_pliku = 1024 * 1024;
                        
        // ustawiamy domylny tryb transmisji na binarny
        $this->tryb = FTP_BINARY;
            
        // pobieramy typ systemu operacyjnego serwera FTP
        $this->typ_systemu = ftp_systype($this->polaczenie);
            
    }

    // zmiana katalogu na serwerze FTP
    function cd($katalog) {          
        $wynik = ftp_chdir($this->polaczenie, $katalog);

        // aktualizujemy zawarto atrybutu $this->biezaca_sciezka
        if ($wynik) {
            $this->biezaca_sciezka = ftp_pwd($this->polaczenie);
        } else {
            user_error("Nie mona zmieni katalogu na '$katalog'.");
        }

        return $wynik;
    }

    // pobieramy list plikw i podkatalogw z podanego katalogu
    function ls($katalog = '.') {     
        $temp = ftp_rawlist(
            // pobieramy list zawartoci katalogu w postaci surowej
            $this->polaczenie,
            $katalog
        );

        if (FALSE == $temp) {
            // zgaszamy bd, jeli nie uda si pobra listy zawartoci
            user_error("Lista zawartoci katalogu nie moe zosta pobrana.");
            return array();
        }

        // rozkadamy list zawartoci katalogu na poszczeglne pola informacyjne
        switch ($this->typ_systemu) {
        // serwery na Windows NT
        case 'Windows_NT':
            $re = '/^'.                 
            // czas ostatniej modyfikacji
            '([0-9-]+\s+'.
            // data ostatniej modyfikacji
            '\d\d:\d\d..)\s+'.
            // rozmiar pliku lub informacja o podkatalogu
            '(\S+)\s+'.
            // nazw apliku lub podkatalogu
            '(.+)$/';
            break;

        // serwery na systemach UNIX
        case 'UNIX':
            // UNIX jest domylnym typem systemu
            default:
            // informacja o katalogu biecym
            $re = '/' .
            // informacja o typie pozycji (plik, katalog itp.)
            '^(.)' .
            // uprawnienia
            '(\S+)\s+' .
            // liczba dowiza
            '(\S+)\s+' .
            // nazwa waciciela
            '(\S+)\s+' .
            // nazwa grupy
            '(\S+)\s+' .
            // rozmiar
            '(\S+)\s+' .
            // czas ostatniej modyfikacji
            '(\S+\s+\S+\s+\S+)\s+'.
            // nazw apliku lub podkatalogu
            '(.+)$/';
            break;
        }

        //  UWAGA
        // powysze wyraenia regularne nie obsuguj wszystkich moliwych
        // styli formatowania listy informacji o katalogach. By moe trzeba
        // bdzie zmodyfikowa wyraenia regularne w celu dostosowania ich 
        // do specyficznych serwerw FTP
    

        $typ = array(
        // dopasowujemy identyfikatory znakowy do typw plikw
            '-' => 'plik',
            'd' => 'katalog'
        );

        $lista_pozycji = array();

        // pomijamy pierwsz pozycj na licie
        array_shift($temp);

        // odczytujemy kolejne pozycje listy zawartoci katalogu
        foreach ($temp as $pozycja) {
            // wczytujemy surowe dane do zawartoci pl
            $dopasowane = preg_match(
                $re,
                $pozycja,
                $dopasowania
            );


            // nie mona wczyta zawartoci
            if (! $dopasowane) {
                user_error("Zawarto katalogw nie moe zostac wczytana.");
                return array();
            }

            // nadajemy polom rozsdne nazwy
            switch ($this->typ_systemu) {
                // obsugujemy list katalogw w stylu Windows NT
                case 'Windows_NT':
                    $lista_pozycji[] = array 
                    (
                        'typ' => is_numeric($dopasowania[2]) ? 'plik' :  'katalog',
                        'uprawnienia' => NULL,
                        'dowiazania' => NULL,
                        'wlasciciel' => NULL,
                        'grupa' => NULL,
                        'rozmiar' => (int) $dopasowania[2],
                        'ostatnia modyfikacja' => $dopasowania[1],
                        'nazwa' => $dopasowania[3]
                    );
                    break;
                // obsugujemy list katalogw w stylu UNIX
                case 'UNIX':
                    // UNIX jest domylnym typem systemu
                    default:
                    $lista_pozycji[] = array(
                        'typ' => $typ[$dopasowania[1]],
                        'uprawnienia' => $dopasowania[2],
                        'dowiazania' => $dopasowania[3],
                        'wlasciciel' => $dopasowania[4],
                        'grupa' => $dopasowania[5],
                        'rozmiar' => $dopasowania[6],
                        'ostatnia modyfikacja' => $dopasowania[7],
                        'nazwa' => $dopasowania[8]
                    );
                    break;
            }
        }

        return $lista_pozycji;
    }

    // pobieranie plikw
    function get($plik)
    {                   
        // tworzymy tymczasow nazw pliku
        $nazwa_tymczasowa = $this->katalog_tymczasowy
                    .  '/klient_ftp_'
                    .  md5 ($plik . microtime());

        // pobieramy plik na nazw tymczasow
        $wynik = ftp_get(
            $this->polaczenie,
            $nazwa_tymczasowa,
            $this->biezaca_sciezka . "/$plik",
            $this->tryb
        );


    // przesyamy uytkownikowi pobrany plik
    if ($wynik) {
        // wysyamy nagwki HTTP
        header("Content-Type: application/octet-stream");
        // uswtawiamy w nagwku nazwe pliku
        header('Content-Disposition: inline; ' . 'filename=' . urlencode($plik));
        readfile($nazwa_tymczasowa);
        unlink($nazwa_tymczasowa);
        // Prevent rest of page from showing
        exit();
    } else {
        // pobieranie zakoczyo si niepowodzeniem
        $nazwa = htmlentities($plik);
        user_error("Nie mona pobra pliku '$nazwa'.");
        return FALSE;
    }

    // transmisja na serwer pliku wysanego przez uytkownika
    function put(
        // nazwa przesyanego pliku
        $nazwa,
        // nazwa tymczasowa przesyanego pliku
        $tmp,
        // rozmiar przesyanego pliku
        $rozmiar
        ) 
    {
        // pomijamy zbyt due pliki
        if($rozmiar > $this->maksymalny_rozmiar_pliku) {
            $kb = $this->maksymalny_rozmiar_pliku / 1024;
            user_error('Przesyane pliki nie mog by wiksze ni ' .$kb . 'kb.');
            return FALSE;
        }

        // prbujemy wysa plik
        $wynik = ftp_put(
            $this->polaczenie,
            $nazwa,
            $tmp,
            $this->tryb
        );

        // usuwamy plik tymczasowy
        unlink($tmp);
        // wysyka zakoczyo si niepowodzeniem
        if (! $wynik) {
            $nazwa = htmlentities($nazwa);
            user_error("Nie mona przesa pliku '$nazwa'.");
        }

        return $wynik;
        }
    }
}

$serwer = 'ftp.helion.pl';
$ftp = new WebowyKlientFtp($serwer);      

if ('Przejd do wybranego katalogu' == $_POST['operacja']) {
    $ftp->cd($_POST['katalog']);
} else if (isset($_POST['katalog_biezacy'])) {
    $ftp->cd($_POST['katalog_biezacy']);
}

if ('Pobierz wybrany plik' == $_POST['operacja']) {
    if (isset($_POST['wybrany_plik'])) {
        $ftp->get($_POST['wybrany_plik']);
    } else {
        user_error("Please select a file to download!");
    }
}

if ('Wylij plik' == $_POST['operacja']) {
    if (isset($_FILES['wyslany_plik'])) {
        $ftp->put(
            $_FILES['wyslany_plik']['nazwa'],
            $_FILES['wyslany_plik']['tmp_name'],
            $_FILES['wyslany_plik']['rozmiar']
        );

    } else {
        $error[] = "Naley wybra plik do wysyki!";
    }
}

$katalogi = array();
$pliki = array();
foreach ($ftp->ls($ftp->biezaca_sciezka) as $pozycja) {
    switch ($pozycja['typ']) {
    case 'katalog':
        $katalogi[$pozycja['nazwa']] = $pozycja['nazwa'];
        break;
    
    default:
    // obsugujemy pliki oraz dowizania symboliczne
        $pliki[$pozycja['nazwa']] =
            sprintf("%s (%0.2f kb)",
                $pozycja['nazwa'],
                $pozycja['rozmiar'] / 1024
            );
        break;
    }
}
?>

<form action="<?php echo getenv('SCRIPT_NAME'); ?>" enctype="multipart/form-data" method="POST">
  <input type="hidden" name="katalog_biezacy" value="<?php echo htmlentities(stripslashes($ftp->biezaca_sciezka)); ?>"/>
  <input type="hidden" name="maksymalny_rozmiar_pliku" value="<?php echo $ftp->maksymalny_rozmiar_pliku; ?>"/>

  <p><b>Serwer:</b> <?php echo $serwer ?></p>
  <p><b>Biecy katalog roboczy:</b> <?php echo $ftp->biezaca_sciezka ?></p>
  <p>
    <select name="katalog">
      <?php
      if ('/' == $ftp->biezaca_sciezka) {
          echo("<option>/</option>");
      } else {
          echo("<option value=\"{$ftp->biezaca_sciezka}\"> . ({$ftp->biezaca_sciezka})</option>\n" .
              "<option value=\"{$ftp->biezaca_sciezka}/..\"> .. </option>\n");
      }

      foreach ($katalogi as $nazwa => $pozycja) {
          printf(
              '<option value="%s">%s</option>'."\n",
              "{$ftp->biezaca_sciezka}/$nazwa",
              $nazwa
          );
      }
      ?>
    </select>
    <input type="submit" name="operacja" value="Przejd do wybranego katalogu"/>
  </p>

  <p>
    <select name="wybrany_plik" size="12">
      <?php
      foreach ($pliki as $nazwa => $pozycja) {
          echo("<option value=\"$nazwa\">$pozycja</option>\n");
      }
      ?>
    </select><br/>
    <input type="submit" name="operacja" value="Pobierz wybrany plik"/><br/><br/>
    <input type="file" name="wyslany_plik"/>
    <input type="submit" name="operacja" value="Wylij plik"/>
  </p>
</form>

