<?php
// definiujemy stae pomocnicze
define('LOKALNY', 1 << 0);
define('ZDALNY', 1 << 1);
define('NA_LOKALNY', LOKALNY);
define('NA_ZDALNY', ZDALNY);
define('Z_LOKALNEGO', LOKALNY << 2);
define('ZE_ZDALNEGO', ZDALNY << 2);

class PolaczenieFtp
{
    // lista otwartych pocze
    var $polaczenia,
    // systemowy katalog na pliki tymczasowe
    $kat_tymcz = 'C:/',
    // tryb transmisji (ASCII lub binarny)
    $tryb;

    // konstruktor klasy
    function PolaczenieFtp() {
        // inicjujemy tablic pocze
        $this->polaczenia = array();
        // wywoanie destruktora klasy po zakoczeniu dziaania skryptu
        register_shutdown_function(array($this, '_destruktor'));
        // domylny tryb transmisji (binarny)
        $this->tryb = FTP_BINARY;
    }

    // ustawiamy tryb transmisji
    function tryb($tryb = NULL) {
        if (NULL !== $tryb)
            $this->tryb = $tryb;
        // zwracamy biece ustawnienie
        return $this->tryb;
    }

    // metoda kopiujca pliki
    function kopiuj(
               // pooenie pliku rdowego
               $zrodlo,
               // pooenie piku docelowego
               $przeznaczenie) {
        $zrodlo = $this->_wczytaj_adres($zrodlo);
        // pooenie pliku rdowego rozbijamy na elementy:
        // uytkownik, haso, serwer, port oraz cieka do pliku
        $przeznaczenie = $this->_wczytaj_adres($przeznaczenie);
        if (! $zrodlo || ! $przeznaczenie) {
            // jeli _wczytaj_adres() zakoczyo si niepowodzeniem,
            // wychodzimy z kodem bdu
            return FALSE;
        }
        // czymy si z adresem rdowym:
        if (! $this->_polacz($zrodlo)) {
            // jeli poczenie zakoczyo si niepowodzeniem,
            // wychodzimy z kodem bdu
            return FALSE;
        }
        // poczenie z adresem przeznaczenia
        if (! $this->_polacz($przeznaczenie)) {
            // jeli poczenie zakoczyo si niepowodzeniem,
            // wychodzimy z kodem bdu
            return FALSE;
        }
        // okrelamy sposb obsugi operacji kopiowania
        // na podstawie typ rda oraz przeznaczenia (lokalne lub zdalne)
        switch ($zrodlo['typ'] << 2 | $przeznaczenie['typ']) {
            case (Z_LOKALNEGO | NA_LOKALNY):
                // kopiowanie plikw lokalnych za pomoc funkcji wbudowanej copy()
                return copy(
                    $zrodlo['sciezka'],
                    $przeznaczenie['sciezka']
                    );
                break;

            // kopiowanie pliku lokalnego na serwer zdalny
            case (Z_LOKALNEGO | NA_ZDALNY):
                return copy(
                    $this->_polaczenie($przeznaczenie),
                    $przeznaczenie['sciezka'],
                    $zrodlo['sciezka'],
                    $this->tryb()
                );
                break;

            // kopiowanie pliku ze zdalnego serwera na lokalny system
            case (ZE_ZDALNEGO | NA_LOKALNY):
                $tymczas = $przeznaczenie['sciezka'];

                // przeksztacenie nazwy katalogu na pen ciek
                if (@ is_dir($tymczas)) {
                    if (substr($tymczas, 0, -1) != '/')
                        $tymczas .= '/';
                    $tymczas .= basename($zrodlo['sciezka']);
                }

                // lokalny uchwyt pliku dla potrzeb funkcji ftp_fget()
                $uchwyt = fopen($tymczas, 'w');

                // jeli uchwyt pliku nie moe zosta otwarty,
                // wychodzimy z kodem bdu
                if (! $uchwyt) {
                    user_error("Nie mona otworzy pliku '{$przeznaczenie['sciezka']}' do zapisu.");
                    return FALSE;
                }

                // kopiujemy plik z serwera FTP
                $wynik_transmisji = ftp_fget(
                   $this->_polaczenie($zrodlo),
                   $uchwyt,
                   $zrodlo['sciezka'],
                  $this->tryb()
                );

                // zamykamy uchwyt pliku
                fclose($uchwyt);

                return $wynik_transmisji;
                break;

            // kopiujemy plik pomidzy dwoma serwerami zdalnymi
            case (ZE_ZDALNEGO | NA_ZDALNY):
                // definiujemy nazw pliku tymczasowego
                $tmp = $this->kat_tymcz
                    . '/ftpcp_'
                    . md5($zrodlo['adres_oryginalny']
                    . $przeznaczenie['adres_oryginalny']);

                // tworzymy pusty plik
                touch($tmp);
                // ograniczamy uprawnienia dostpu
                chmod($tmp, 0700);

                // kopiujemy plik ze rda na plik tymczasowy
                $wynik = $this->kopiuj(
                    $zrodlo['adres_oryginalny'],
                    $tmp
                );

                // kopiujemy plik tymczasowy na serwer przeznaczenia
                $wynik2 = $this->kopiuj(
                    $tmp,
                    $przeznaczenie['adres_oryginalny']
                );

                // usuwamy plik tymczasowy
                unlink($tmp);
                // zwracamy wynik operacji
                return(bool)(
                    $wynik &&
                    $wynik2
                );
                break;

            // jeli nie zostaa dopasowana adna z powyszych moliwoci
            // wychodzimy z kodem bdu
            default:
                user_error("Nie dopasowano znacznika operacji. Niedopuszczalna sytuacja!");
                return FALSE;
                break;
        }
    }


    // wyszukiwanie zbuforowanego poczenia
    function &_polaczenie($dane_polaczenia)
    {
        // liczymy sum kontroln poczenia w oparciu o
        // serwer, haso, port i uytkownika
        $md5 = md5(
            $dane_polaczenia['serwer'] .
            $dane_polaczenia['haslo'] .
            $dane_polaczenia['port'] .
            $dane_polaczenia['uzytkownik']
        );
        // w oparciu o wyliczon sum kontroln wyszukujemy
        // zbuforowane poczenie
        return $this->polaczenia[$md5];
    }

    // ciek pooenia pliku rozkadamy na elementy
    function _wczytaj_adres($adres)
    {
        $znaki = count_chars($adres);
        if (
          // poniej 2 znakw dwukropka i 1 znak @ oznaczaj, e $adres nie zawiera
          // informacji o serwerze, uytkowniku i hale
          $znaki[ord(':')] < 2
          && 0 == $znaki[ord('@')]) {
            return array(
                // zachowujemy oryginaln warto cieki na pniej
                'adres_oryginalny' => $adres,
                'uzytkownik' => FALSE,
                'haslo' => FALSE,
                'serwer' => FALSE,
                'port' => FALSE,
                'sciezka' => $adres
            );
        }

        // wystepowanie kilku znakw @ jest niedopuszczalne
        if ($znaki[ord('@')] > 1) {
            user_error(
               "Nie mona wczyta informacji o adresie siecowym i ciece " .
               "Naley zweryfikowa warto podanego adresu: '{$adres}'?"
           );
           return FALSE;
        }

        // sprawdzamy, czy cieka da si rozoy na elementy
        // uytkownik, haso, serwer, port i cieka
        $jest_numer_portu = preg_match(
            '/^([^:]+):(.+)@(.+):([0-9]+):([^:]+)$/',
            $adres,
            $dopasowanie
            );

        // jeli udao si wydoby dane ze cieki, zapisujemy je
        // w tablicy informacyjnej
        if ($jest_numer_portu) {
            return array(
            'adres_oryginalny' => $adres,
            'typ' => ZDALNY,
            'uzytkownik' => $dopasowanie[1],
            'haslo' => $dopasowanie[2],
            'serwer' => $dopasowanie[3],
            'port' => $dopasowanie[4],
            'sciezka' => $dopasowanie[5]
            );
        }

        // sprawdzamy, czy cieka da si rozoy na elementy
        // uytkownik, haso, serwer i cieka
        $nie_ma_numeru_portu = preg_match(
            '/^([^:]+):(.+)@(.+):([^:]+)$/',
            $adres,
            $dopasowanie
        );
        if ($nie_ma_numeru_portu) {
            return array(
            'adres_oryginalny' => $adres,
            'typ' => ZDALNY,
            'uzytkownik' => $dopasowanie[1],
            'haslo' => $dopasowanie[2],
            'serwer' => $dopasowanie[3],
            // element portu ustawiamy na warto domyln protokou FTP
            'port' => 21,
            'sciezka' => $dopasowanie[4]
            );
        }
        // wypisujemy informacj o bdzie
        user_error(
            "Z podanego adresu nie mona odczyta informacji o serwerze, " .
            "uytkowniku i hale."
        );

        return FALSE;
    }

    // prbujemy poczy si z adresem
    function _polacz($dane_polaczenia) {
        // sprawdzamy, czy poczenie nie zostao zbuforowane
        $polaczenie =& $this->_polaczenie($dane_polaczenia);
        // jeli zbuforowane poczenie zostao odnalezione, zwracamy je
        if (isset($polaczenie)) {
            return $polaczenie;
        }
        foreach ($dane_polaczenia as $k => $v) {
            // przeksztacamy wartoci tablicy na zmienne lokalne
            ${$k} =& $dane_polaczenia[$k];
        }

        // jeli nie istnieje nazwa serwera, oznacza, e adres okrela
        // pooenie pliku w lokalnym systemie
        if (! $serwer) {
            return TRUE;
        }

        // czymy si z serwerem FTP
        $uchwyt = ftp_connect($serwer, $port);

        // jeli poczenie nie udao si, koczymy dziaanie metody
        // z komunikatem o bdzie
        if (! $uchwyt) {
            user_error("Nie mona poczy si z serwerem '$serwer:$port'");
            return FALSE;
        }

        // podejmujemy prb zalogowania si
        $zalogowany = ftp_login($uchwyt,$uzytkownik,$haslo);

        // jeli logowanie nie udao si, koczymy dziaanie metody
        // z komunikatem o bdzie
        if (! $zalogowany) {
            user_error("Nie mona uwierzytelni uytkownika na serwerze '$serwer:$port'.\n");
            return FALSE;
        }

        // jeli poczenie i logowanie uday si, buforujemy poczenie
        // i koczymy dziaanie metody
        $polaczenie = $uchwyt;
        return TRUE;
    }

    // zwalniamy zbuforowane poczenia
    function _destruktor()
    {
        foreach ($this->polaczenia as $k => $v)
            if (is_resource($v))
                ftp_quit($this->polaczenia[$k]);
        $this = NULL;
    }
}
?>
