<?php
// katalog przechowujcy dane
$katalog_glowny="c:\\system_plikow_online";
// separator plikw - w systemach UNIX powinien to by znak "/",
// w systemach Windows "\\"
$separator_katalogow="\\";
// katalog przechowujcy profile uytkownikw
$katalog_profili = $katalog_glowny . $separator_katalogow . "profile";

// funkcja zwracajca bezwzgldn ciek do katalogu
function pobierz_sciezke_bezwzgledna($katalog) 
{
    global $katalog_glowny, $separator_katalogow;
    $elem_sciezki = split("/", $katalog);
    $nazwa_katalogu = $katalog_glowny;
    for($i=0; $i < sizeof($elem_sciezki); $i++) {
        $nazwa_katalogu = $nazwa_katalogu . $separator_katalogow . $elem_sciezki[$i];
    }
    return $nazwa_katalogu;
}

// tworzenie cza HTML
function lacze_html($href, $opis) 
{
    $str="<a href=".$href."> ". $opis. "</a>";
    sprintf($str,"<a href=\"%s\"> %s </a>", $href, $opis);
    return $str;
}

// utworzenie katalogu
function utworz_katalog($katalog_biezacy, $nazwa_katalogu)
{
    return mkdir(pobierz_sciezke_bezwzgledna($katalog_biezacy."/".$nazwa_katalogu), 0700);
}

// rekurencyjne usuwanie katalogu
function usun_katalog($katalog_biezacy, $nazwa_katalogu) 
{
    global $separator_katalogow;
    if (($kat = opendir(pobierz_sciezke_bezwzgledna($katalog_biezacy . "/" . $nazwa_katalogu))) < 0) {
        return $kat;
    }
    while (($plik = readdir($kat)) != null) {
        $absFilePath = pobierz_sciezke_bezwzgledna($katalog_biezacy . "/" . $nazwa_katalogu) . $separator_katalogow . $plik;
        if (is_dir($absFilePath)) {
            if (($plik != ".") && ($plik != "..")) {
                if (($res = usun_katalog($katalog_biezacy . "/" . $nazwa_katalogu, $plik)) < 0) {
                    return $res;
                }
            }
        } else {
            if (($res = usun_plik($katalog_biezacy . "/" . $nazwa_katalogu, $plik)) < 0) {
                return $res;
            }
        }
    } 
    closedir($kat);
                                
    return rmdir(pobierz_sciezke_bezwzgledna($katalog_biezacy."/".$nazwa_katalogu));
}
                
// usuwanie pliku
function usun_plik($katalog_biezacy, $nazwa_pliku) 
{
    return unlink(pobierz_sciezke_bezwzgledna($katalog_biezacy."/".$nazwa_pliku));
}

// wysanie strony komunikatu o bdzie
function wyslij_komunikat_o_bledzie($komunikat) 
{
    printf("<html>");
    printf("<head></head>");
    printf("<body>");
    printf("<h1>%s</h1>", $komunikat);
    printf("</body>");
    printf("</html>");
}

function sesja_jest_uwierzytelniona() 
{
    global $jest_uwierzytelniona;
    session_start();
    if (session_is_registered("jest_uwierzytelniona") && $jest_uwierzytelniona) {
        return true;
    } else {
        return false;
    }
}
?>
