<?php

include("wspolne.php");

// sprawdzamy, czy zmienne formularza nie maj pustej zawartoci
$imie = trim($imie);
$nazwisko = trim($nazwisko);
$adres_email = trim($adres_email);
$nazwa_uzytkownika = trim($nazwa_uzytkownika);
$haslo = trim($haslo);
$potw_hasla = trim($potw_hasla);

if (($imie == "") || ($nazwisko == "") || ($adres_email == "") || ($nazwa_uzytkownika == "") || ($haslo == "") || ($potw_hasla == "")) {
    wyslij_komunikat_o_bledzie("BD: nie zostay wypenione wszystkie pola formularza!");
    exit;
}

if ($haslo != $potw_hasla) {
    wyslij_komunikat_o_bledzie("BD: haso i potwierdzenia hasa nie zgadzaj si!"); 
    exit;
}

// sprawdzamy istnienie nazwy uytkownika
$plik_profilu_uzytkownika = $katalog_profili . $separator_katalogow . $nazwa_uzytkownika;
if (file_exists($plik_profilu_uzytkownika)) {
    wyslij_komunikat_o_bledzie("BD: uytkownik o nazwie " . $nazwa_uzytkownika . " ju istnieje");
    exit;
} 

// tworzymy plik profilu uytkownika
if (($fp = fopen($plik_profilu_uzytkownika, "w+")) < 0) {
    wyslij_komunikat_o_bledzie("Bd wewntrzny: nie mona utworzy pliku " . $plik_profilu_uzytkownika);
    exit;
}

fwrite($fp, "imie:" . $imie . "\n");
fwrite($fp, "nazwisko:" . $nazwisko . "\n");
fwrite($fp, "adres_email:" . $adres_email . "\n");
fwrite($fp, "nazwa_uzytkownika:" . $nazwa_uzytkownika . "\n");

// zaszyfrowane haso
fwrite($fp, "haslo:" . crypt($haslo, CRYPT_STD_DES) . "\n");
fclose($fp);

// utworzenie katalogu macierzystego uytkownika
if (utworz_katalog("/", $nazwa_uzytkownika) <= 0) {
    wyslij_komunikat_o_bledzie("Bd wewntrzny: nie mona utworzy katalogu " . $nazwa_uzytkownika);
    exit;
}

// tworzymy plik typw MIME
$plik_typow_mime = $nazwa_uzytkownika . "/" . "mimeTypes";
if (!fopen(pobierz_sciezke_bezwzgledna($plik_typow_mime), "w+")) {
    wyslij_komunikat_o_bledzie("Bd wewntrzny: nie mona utworzy pliku " . $plik_typow_mime);
    exit;
}

?>

<html>
  <head>
  </head>
  <body>
    <h1> Uytkownik <?php echo $nazwa_uzytkownika ?> zosta pomylnie dodany do systemu. Przejd do strony <a href="login.html">logowania do systemu</a>.</h1>
  </body>
</html>
