<?php

include_once("wspolne.php");

$nazwa_uzytkownika = trim($nazwa_uzytkownika);
$haslo = trim($haslo);

// uwierzytelneinie uytkownika
if (($nazwa_uzytkownika == "") || ($haslo == "")) {
    wyslij_komunikat_o_bledzie("Wprowadzona nazwa uytkownka oraz haso sa nieprawidowe. Sprbuj ponownie.");
    exit;
}

$plik_profilu_uzytkownika = $katalog_profili . $separator_katalogow . $nazwa_uzytkownika;

// sprawdzenie istnienia pliku profilu uytkownika
if (!file_exists($plik_profilu_uzytkownika)) {
    wyslij_komunikat_o_bledzie("Wprowadzona nazwa uytkownka oraz haso sa nieprawidowe. Sprbuj ponownie.");
    exit;
}

// odczyt pliku profilu
if (($zawartosc_pliku = file($plik_profilu_uzytkownika)) == null) {
    wyslij_komunikat_o_bledzie("Bd wewntrzny: nie mona odczyta pliku " . $plik_profilu_uzytkownika);
    exit;
}

// pobranie nazwy uytkownka oraz hasa
for($i=0; $i < sizeof($zawartosc_pliku); $i++) {
    $wiersz = trim($zawartosc_pliku[$i]);
    list ($nazwa, $wartosc) = split(":", $wiersz);
    if ($nazwa == "nazwa_uzytkownika") {
        $nazwa_u = $wartosc;
    } else if ($nazwa == "haslo") {
        $haslo_u = $wartosc;
    }
}

if (($nazwa_u != $nazwa_uzytkownika) || ($haslo_u != crypt($haslo, CRYPT_STD_DES))) {
    wyslij_komunikat_o_bledzie("Wprowadzona nazwa uytkownka oraz haso sa nieprawidowe. Sprbuj ponownie.");
    exit;
}

// pomyslne uwierzytelnienie
// tworzenie sesji uytkownika oraz ustawienie znacznika sesji jest_uwierzytelniona
if (!session_start()) {
    wyslij_komunikat_o_bledzie("Bd wewntrzny: nie mona zainicjowac sesji.");
    exit;
}

if (!session_register("jest_uwierzytelniona")) {
    wyslij_komunikat_o_bledzie("Bd wewntrzny: nie mona zarejestrowac w sesji zmiennej jest_uwierzytelniona.");
    exit;
}

$jest_uwierzytelniona=true;

if (!session_register("nazwa_uzytkownika")) {
    wyslij_komunikat_o_bledzie("Bd wewntrzny: nie mona zarejestrowac w sesji zmiennej nazwa_uzytkownika.");
    exit;
}

if (!session_register("katalog_biezacy")) {
    wyslij_komunikat_o_bledzie("Bd wewntrzny: nie mona zarejestrowac w sesji zmiennej katalog_biezacy.");
    exit;
}

$katalog_biezacy = $nazwa_uzytkownika;

include_once("glowna.php");
exit;
?>
