<?php

require_once 'Zend/Tool/Project/Provider/Abstract.php';
require_once 'Zend/Tool/Project/Provider/Exception.php';

class DaneProvider extends Zend_Tool_Project_Provider_Abstract
{

    public function wstaw()
    {


        // Define path to application directory
        defined('APPLICATION_PATH')
            || define('APPLICATION_PATH', realpath(dirname(__FILE__) . '/../application'));

        // Define application environment
        defined('APPLICATION_ENV')
            || define('APPLICATION_ENV', (getenv('APPLICATION_ENV') ? getenv('APPLICATION_ENV') : 'development'));

        // Ensure library/ is on include_path
        set_include_path(implode(PATH_SEPARATOR, array(
            realpath(APPLICATION_PATH . '/../library'),
            get_include_path(),
        )));

        /** Zend_Application */
        require_once 'Zend/Application.php';

        // Create application, bootstrap, and run
        $application = new Zend_Application(
            APPLICATION_ENV,
            APPLICATION_PATH . '/configs/application.ini'
        );
        $application->bootstrap('db');


        $Zawodnik = new Application_Model_DbTable_Zawodnik();
        $Panstwo = new Application_Model_DbTable_Panstwo();
        $Turniej = new Application_Model_DbTable_Turniej();

        $Zawodnik->delete('');
        $Panstwo->delete('');
        $Turniej->delete('');

        $tcs = simplexml_load_file('data/tcs.xml');

        foreach ($tcs->turniej as $turniej) {

            $dane = (array)$turniej;

            $turniej_id = $Turniej->createRow($dane)->save();

            foreach ($turniej->miejsce as $miejsce) {


                $dane_panstwa = array(
                    'nazwa'  => $miejsce->sportowiec->panstwo
                );

                $panstwo_id = $Panstwo->insertIfNotExists($dane_panstwa);


                $dane_zawodnika = array(
                    'imie'     =>  $miejsce->sportowiec->imie,
                    'nazwisko' => $miejsce->sportowiec->nazwisko,
                    'panstwo_id' => $panstwo_id,
                );

                $zawodnik_id = $Zawodnik->insertIfNotExists($dane_zawodnika);

                $TurniejHasZawodnik = new Application_Model_DbTable_TurniejHasZawodnik();
                $dane = array(
                    'turniej_id'  => $turniej_id,
                    'zawodnik_id' => $zawodnik_id,
                    'miejsce'     => $miejsce->numer
                );
                $TurniejHasZawodnik->createRow($dane)->save();

            }
        }
    }
}

