<?php

class KontynentController extends My_Crud_Controller
{

    public function preDispatch()
    {
        $auth = Zend_Auth::getInstance();
        if (!$auth->hasIdentity()) {
            return $this->_helper->redirector(
                'index',
                'auth',
                'default'
            );
        }
        $this->view->identity = $auth->getIdentity();
    }


    public function init()
    {
        $this->_db_table_class = 'Application_Model_DbTable_Kontynent';
        $this->_form_class = 'Application_Form_Kontynent';
    }

    public function createformAction()
    {
        $this->view->form = new $this->_form_class;
        $this->view->form->dodajKontrolkePanstwa();

        $url = $this->view->url(
            array(
                'action' => 'create',
                'controller' => $this->getRequest()->getControllerName(),
                'module' => $this->getRequest()->getModuleName(),
            ),
            'default',
            true
        );
        $this->view->form->setAction($url);
    }


    public function createAction()
    {
        if ($this->getRequest()->isPost()) {
            $form = new $this->_form_class;
            $form->dodajKontrolkePanstwa();
            if ($form->isValid($this->getRequest()->getPost())) {
                $data = $form->getValues();

                $DbTable = new $this->_db_table_class;
                $obj = $DbTable->createRow($data);
                $id = $obj->save();

                $obj->dodajPanstwa($data['panstwa']);

                return $this->_helper->redirector(
                    'edit',
                    $this->getRequest()->getControllerName(),
                    $this->getRequest()->getModuleName(),
                    array('id' => $id)
                );
            }
            $this->view->form = $form;
        } else {
            throw new Zend_Controller_Action_Exception('Bdny adres!', 404);
        }
    }


    public function showAction()
    {
        $slug = $this->_request->getParam('slug', 'brak');
        $Kontynent = new Application_Model_DbTable_Kontynent();
        $this->view->kontynent = $Kontynent->findOneBySlug($slug);
        if (!$this->view->kontynent) {
            throw new Zend_Controller_Action_Exception(sprintf('KontynentController/showAction: bdny slug: "%s" ', $slug), 404);
        }
        $this->view->tytul = 'Szczegowe dane kontynentu: ' . $this->view->kontynent['nazwa'];
    }

    public function editAction()
    {
        $id = $this->getRequest()->getParam('id');
        $DbTable = new $this->_db_table_class;
        $obj = $DbTable->find($id)->current();
        if (!$obj) {
            throw new Zend_Controller_Action_Exception('Bdny adres!', 404);
        }
        $this->view->form = new $this->_form_class;
        $this->view->form->populate($obj->toArray());

        $this->view->form->dodajKontrolkePanstwa($obj);

        $url = $this->view->url(
            array(
                'action' => 'update',
                'controller' => $this->getRequest()->getControllerName(),
                'id' => $id
            ),
            'default',
            true
        );
        $this->view->form->setAction($url);
        $this->view->object = $obj;
    }


    public function updateAction()
    {
        $id = $this->getRequest()->getParam('id');
        $DbTable = new $this->_db_table_class;
        $obj = $DbTable->find($id)->current();
        if (!$obj) {
            throw new Zend_Controller_Action_Exception('Bdny adres!', 404);
        }

        if ($this->getRequest()->isPost()) {
            $form = new $this->_form_class;
            $form->dodajKontrolkePanstwa($obj);
            if ($form->isValid($this->getRequest()->getPost())) {
                $data = $form->getValues();
                $obj->setFromArray($data);
                $obj->save();
                $obj->dodajPanstwa($data['panstwa']);

                return $this->_helper->redirector(
                    'edit',
                    $this->getRequest()->getControllerName(),
                    null,
                    array('id' => $id)
                );
            }
            $this->view->form = $form;
        } else {
            throw new Zend_Controller_Action_Exception('Bdny adres!', 404);
        }
    }


}
