<?php

// Define path to application directory
defined('APPLICATION_PATH')
    || define('APPLICATION_PATH', realpath(dirname(__FILE__) . '/../application'));

// Define application environment
defined('APPLICATION_ENV')
    || define('APPLICATION_ENV', (getenv('APPLICATION_ENV') ? getenv('APPLICATION_ENV') : 'development'));

// Ensure library/ is on include_path
set_include_path(implode(PATH_SEPARATOR, array(
    realpath(APPLICATION_PATH . '/../library'),
    get_include_path(),
)));

/** Zend_Application */
require_once 'Zend/Application.php';

// Create application, bootstrap, and run
$application = new Zend_Application(
    APPLICATION_ENV,
    APPLICATION_PATH . '/configs/application.ini'
);
$application->bootstrap('db');


$Kontynent = new Application_Model_DbTable_Kontynent();
$Panstwo = new Application_Model_DbTable_Panstwo();

$Panstwo->delete('');
$Kontynent->delete('');


$xml = simplexml_load_file('../data/kontynenty-panstwa.xml');
foreach ($xml->kontynent as $kontynent) {

    $dane = (array)$kontynent;

    try {
        $kontynent_id = $Kontynent->createRow($dane)->save();
    } catch (Zend_Db_Statement_Exception $e) {
        die($e->getMessage());
    }

    foreach ($kontynent->panstwa->panstwo as $panstwo) {

        $dane = (array)$panstwo;
        $dane['kontynent_id'] = $kontynent_id;

        try {
            $Panstwo->createRow($dane)->save();
        } catch (Zend_Db_Statement_Exception $e) {
            die($e->getMessage());
        }
    }

}
