<?php

class IndexController extends Zend_Controller_Action
{

    public function indexAction()
    {
        $Plik = new Application_Model_DbTable_Plik();
        $select = $Plik->select()->from('plik', array('slug'));
        $this->view->pliki = $Plik->fetchAll($select);
    }

    public function showAction()
    {
        $Plik = new Application_Model_DbTable_Plik();
        $slug = $this->getRequest()->getParam('slug');
        $select = $Plik->select()->where('slug = ?', $slug);
        $this->view->plik = $Plik->fetchRow($select);
        if (!$this->view->plik) {
            throw new Zend_Controller_Action_Exception('Bd #1!', 404);
        }

        $this->getResponse()
            ->setHeader('Content-Type', $this->view->plik['typmime'])
            ->appendBody($this->view->plik['dane']);

        $this->_helper->layout()->disableLayout();
        $this->_helper->viewRenderer->setNoRender();
    }

    public function createformAction()
    {
        $this->view->form = new Application_Form_Plik();
        $url = $this->view->url(array('action' => 'create'));
        $this->view->form->setAction($url);
    }


    public function createAction()
    {
        if ($this->getRequest()->isPost()) {
            $form = new Application_Form_Plik();
            if ($form->isValid($this->getRequest()->getPost())) {

                $dane = $form->getValues();

                $np = realpath(APPLICATION_PATH . '/../public/uploads/' . $dane['slug']);
                $contents = file_get_contents($np);
                $path_parts = pathinfo($np);

                unlink($np);
                
                $dane['dane'] = $contents;
                $dane['typmime'] = My_Mime::getMimetypeOnExt($path_parts['extension']);

                $Plik = new Application_Model_DbTable_Plik();
                $id = $Plik->createRow($dane)->save();

                return $this->_helper->redirector('index');
            }
            $this->view->form = $form;
        } else {
            throw new Exception('Bdny adres!', 404);
        }
    }

    public function deleteAction()
    {
        $slug = $this->getRequest()->getParam('slug');
        $Plik = new Application_Model_DbTable_Plik();
        $obj = $Plik->findOneBySlug($slug);
        if ($obj === null) {
            throw new Exception('Rekord nie istnieje!', 404);
        } else {
            $obj->delete();
            return $this->_helper->redirector('index');
        }
    }


}
