SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL';

DROP SCHEMA IF EXISTS `kontynenty` ;
CREATE SCHEMA IF NOT EXISTS `kontynenty` DEFAULT CHARACTER SET utf8 COLLATE utf8_polish_ci ;
USE `kontynenty` ;

-- -----------------------------------------------------
-- Table `kontynenty`.`kontynent`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `kontynenty`.`kontynent` (
  `kontynent_id` INT NOT NULL AUTO_INCREMENT ,
  `nazwa` VARCHAR(45) NULL ,
  `slug` VARCHAR(45) NOT NULL ,
  PRIMARY KEY (`kontynent_id`) ,
  UNIQUE INDEX `u_slug` (`slug` ASC) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `kontynenty`.`panstwo`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `kontynenty`.`panstwo` (
  `panstwo_id` INT NOT NULL AUTO_INCREMENT ,
  `nazwa` VARCHAR(45) NULL ,
  `slug` VARCHAR(45) NOT NULL ,
  `kontynent_id` INT NOT NULL ,
  PRIMARY KEY (`panstwo_id`) ,
  UNIQUE INDEX `u_slug` (`slug` ASC) ,
  INDEX `fk_panstwo_kontynent` (`kontynent_id` ASC) ,
  CONSTRAINT `fk_panstwo_kontynent`
    FOREIGN KEY (`kontynent_id` )
    REFERENCES `kontynenty`.`kontynent` (`kontynent_id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `kontynenty`.`user`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `kontynenty`.`user` (
  `user_id` INT NOT NULL AUTO_INCREMENT ,
  `username` VARCHAR(128) NOT NULL ,
  `password` VARCHAR(128) NULL ,
  `salt` VARCHAR(128) NULL ,
  `email` VARCHAR(128) NULL ,
  PRIMARY KEY (`user_id`) ,
  UNIQUE INDEX `username_UNIQUE` (`username` ASC) )
ENGINE = InnoDB;



SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;



grant all on kontynenty.* to redaktor@localhost identified by 'tajnehaslo';
flush privileges;
