<?php

/*
 * html.inc.php
 * ver 0.1
 * 2006/02/02
 * (c)2006 Wodzimierz Gajda, gajdaw
 * http://www.gajdaw.pl
 */


/*
 * Wycina zawarto elementu. Domylnie: body
 */
function htmlGetTagsContent($str, $tag = 'body')
{
    if (preg_match('|<' . $tag . '>(.*)</' . $tag . '>|Uis', $str, $matches)) {
        return $matches[1];
    } else {
        return false;
    }
}


/*
 *  Przyklad: '|(<p class="tytul">.*</p>)|Uis'
 *  Przyklad: '|<p class="tytul">(.*)</p>|Uis'
 */
function htmlGetFirstMatch($str, $regexp)
{
    if (preg_match($regexp, $str, $matches)) {
        return $matches[1];
    } else {
        return false;
    }
}


/*
 *  Przyklad: '|(<p class="tytul">.*</p>)|Uis'
 *  Przyklad: '|<p class="tytul">(.*)</p>|Uis'
 */
function htmlSetFirstMatch($str, $old_regexp, $new_str)
{
    if (preg_match($old_regexp, $str, $matches)) {
        return str_replace($matches[1], $new_str, $str);
    } else {
        return $str;
    }
}

function htmlDeleteTag($str, $tag)
{
    $re = '|(<' . $tag . '>.*</' . $tag . '>)|Usim';
    return htmlSetFirstMatch($str, $re, '');
}
