<?php

class Authorization_AuthController extends Zend_Controller_Action
{

    public function unauthorizedAction()
    {
        /*
         * Każdy ma dostęp do akcji.
         * Do widoku przekazujemy $identity lub false.
         *
         */
        $this->view->identity = false;

        $auth = Zend_Auth::getInstance();
        if ($auth->hasIdentity()) {
            $this->view->identity = $auth->getIdentity();
        }
    }

    public function indexAction()
    {
        /*
         * Zalogowany użytkownik nie ma dostępu do akcji.
         *
         */
        $auth = Zend_Auth::getInstance();
        if ($auth->hasIdentity()) {
            return $this->_helper->redirector(
                'unauthorized',
                'auth',
                'authorization'
            );
        }

        /*
         * Do widoku przekazujemy $identity oraz formularz.
         *
         */
        $this->view->identity = false;
        $this->view->form = false;

        $auth = Zend_Auth::getInstance();
        if ($auth->hasIdentity()) {
            $this->view->identity = $auth->getIdentity();
        } else {
            $this->view->form = new Authorization_Form_Login();
        }
    }

    public function loginAction()
    {
        /*
         * Zalogowany użytkownik nie ma dostępu do akcji.
         *
         */
        $auth = Zend_Auth::getInstance();
        if ($auth->hasIdentity()) {
            return $this->_helper->redirector(
                'unauthorized',
                'auth',
                'authorization'
            );
        }

        /*
         * Do widoku przekazujemy jako $identity false.
         *
         */
        $this->view->identity = false;


        $this->_helper->viewRenderer('index');
        $form = new Authorization_Form_Login();
        if ($form->isValid($this->getRequest()->getPost())) {

            $adapter = new Zend_Auth_Adapter_DbTable(
                null,
                'user',
                'username',
                'password',
                'SHA1(CONCAT(salt, ?, salt))'
            );

            $adapter->setIdentity($form->getValue('username'));
            $adapter->setCredential($form->getValue('password'));

            $auth = Zend_Auth::getInstance();

            $result = $auth->authenticate($adapter);

            if ($result->isValid()) {
                return $this->_helper->redirector(
                    'index',
                    'index',
                    'default'
                );
            }
            $form->password->addError('Błędna próba logowania!');
        }
        $this->view->form = $form;
    }

    public function logoutAction()
    {

        /*
         * Niezalogowany użytkownik nie ma dostępu do akcji.
         *
         */
        $auth = Zend_Auth::getInstance();
        if (!$auth->hasIdentity()) {
            return $this->_helper->redirector(
                'unauthorized',
                'auth',
                'authorization'
            );
        }

        $auth->clearIdentity();
        return $this->_helper->redirector(
            'index',
            'index',
            'default'
        );
    }


    public function registerformAction()
    {
        /*
         * Zalogowany użytkownik nie ma dostępu do akcji.
         *
         */
        $auth = Zend_Auth::getInstance();
        if ($auth->hasIdentity()) {
            return $this->_helper->redirector(
                'unauthorized',
                'auth',
                'authorization'
            );
        }

        /*
         * Do widoku przekazujemy jako $identity false.
         *
         */
        $this->view->identity = false;

        $this->view->form = new Authorization_Form_Register();
    }

    public function registerAction()
    {

        /*
         * Zalogowany użytkownik nie ma dostępu do akcji.
         *
         */
        $auth = Zend_Auth::getInstance();
        if ($auth->hasIdentity()) {
            return $this->_helper->redirector(
                'unauthorized',
                'auth',
                'authorization'
            );
        }

        /*
         * Do widoku przekazujemy jako $identity false.
         *
         */
        $this->view->identity = false;

        $this->_helper->viewRenderer('registerform');
        $form = new Authorization_Form_Register();

        if ($form->isValid($this->getRequest()->getPost())) {


            $User = new Authorization_Model_DbTable_User();

            $salt = My_Salt::getSalt3();

            $dane = array(
                'username' => $form->getValue('username'),
                'password' => sha1($salt . $form->getValue('password') . $salt),
                'salt'     => $salt,
                'email'    => $form->getValue('email')
            );

            $User->createRow($dane)->save();

            return $this->_helper->redirector(
                'index',
                'index',
                'default'
            );

        }
        $this->view->form = $form;
    }


    public function forgotpasswordformAction()
    {
        /*
         * Zalogowany użytkownik nie ma dostępu do akcji.
         *
         */
        $auth = Zend_Auth::getInstance();
        if ($auth->hasIdentity()) {
            return $this->_helper->redirector(
                'unauthorized',
                'auth',
                'authorization'
            );
        }

        /*
         * Do widoku przekazujemy jako $identity false.
         *
         */
        $this->view->identity = false;

        $this->view->form = new Authorization_Form_Forgotpassword();
    }

    public function forgotpasswordAction()
    {
        /*
         * Zalogowany użytkownik nie ma dostępu do akcji.
         *
         */
        $auth = Zend_Auth::getInstance();
        if ($auth->hasIdentity()) {
            return $this->_helper->redirector(
                'unauthorized',
                'auth',
                'authorization'
            );
        }

        /*
         * Do widoku przekazujemy jako $identity false.
         *
         */
        $this->view->identity = false;

        $this->_helper->viewRenderer('forgotpasswordform');
        $form = new Authorization_Form_Forgotpassword();

        if ($form->isValid($this->getRequest()->getPost())) {


            $User = new Authorization_Model_DbTable_User();
            $select = $User->select()->where('username = ?', $form->getValue('username'));
            $u = $User->fetchRow($select);


            $password = My_Salt::randomPassword();

            $salt = My_Salt::getSalt3();

            $u->salt     = $salt;
            $u->password = sha1($salt . $password . $salt);
            $u->save();

            $mail = new My_Mail_Gmail();
            $mail->mailNewPassword($u->email, $password);

            return $this->_helper->redirector(
                'index',
                'index',
                'default'
            );

        }
        $this->view->form = $form;
    }

    public function changepasswordformAction()
    {

        /*
         * Niezalogowany użytkownik nie ma dostępu do akcji.
         *
         */
        $auth = Zend_Auth::getInstance();
        if (!$auth->hasIdentity()) {
            return $this->_helper->redirector(
                'unauthorized',
                'auth',
                'authorization'
            );
        }

        /*
         * Do widoku przekazujemy jako $identity false.
         *
         */
        $this->view->identity = $auth->getIdentity();

        $this->view->form = new Authorization_Form_Changepassword();
    }

    public function changepasswordAction()
    {

        /*
         * Niezalogowany użytkownik nie ma dostępu do akcji.
         *
         */
        $auth = Zend_Auth::getInstance();
        if (!$auth->hasIdentity()) {
            return $this->_helper->redirector(
                'unauthorized',
                'auth',
                'authorization'
            );
        }

        /*
         * Do widoku przekazujemy jako $identity false.
         *
         */
        $this->view->identity = $auth->getIdentity();


        $User = new Authorization_Model_DbTable_User();
        $select = $User->select()->where('username = ?', $auth->getIdentity());
        $u = $User->fetchRow($select);

        $this->_helper->viewRenderer('changepasswordform');
        $form = new Authorization_Form_Changepassword();

        if ($u && $form->isValid($this->getRequest()->getPost())) {

            $password = $form->getValue('password');
            $salt = My_Salt::getSalt3();

            $u->salt     = $salt;
            $u->password = sha1($salt . $password . $salt);
            $u->save();

            $mail = new My_Mail_Gmail();
            $mail->mailNewPassword($u->email, $password);

            return $this->_helper->redirector(
                'index',
                'index',
                'default'
            );

        }
        $this->view->form = $form;
    }

}