/***************************************************************
 *
 * dvd_test_client.c - test code to verify RPC routines
 *
 * Demonstration code from 'Professional Linux Programming'
 *
 * Written by Neil Matthew, Rick Stones et. al.
 *
 * Copyright (C) 2000 Wrox Press.
 *
 * http://www.wrox.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 **************************************************************/

#include <stdio.h>
#include "dvd.h"

int main(int argc, char* argv[])
{
    int status;
    int member_id;
    int title_id;
    int disk_id;

    /***********************************************************************
     * TEST 1 - Test dvd_close_db bez ustanowienia polaczenia RPC
     *
     * to bedzie drukowac komunikat o bledzie na konsoli klienta
     * poniewaz dvd_open_db lub dvd_open_db_login nie wystapily
     * przed ustanowieniem polaczenia RPC do serwera
     ***********************************************************************/
    {
        printf("\nTEST 1 - Testing dvd_close_db without RPC connection setup\n");
        status = dvd_close_db(); 

        if (DVD_SUCCESS != status) {
            printf(" - passed\n");
        } else {
            printf(" - FAILED!\n");
        }
    }

    /***********************************************************************
     * TEST 2 - Test dvd_today bez wstepnie istniejacego polaczenia RPC
     ***********************************************************************/
    {
        char *date;

        printf("\nTEST 2 - Testing dvd_today without pre-existing RPC connection\n");
        status = dvd_today(&date);

        if (DVD_SUCCESS == status) {
            printf(" - Todays date is %s [YYYYMMDD]\n", date);
            printf(" - passed\n");
        } else {
            printf(" - FAILED!\n");
        }

    }

    /***********************************************************************
     * TEST 3 - Test dvd_open_db
     ***********************************************************************/
    {
        printf("\nTEST 3 - Testing dvd_open_db\n");
        status = dvd_open_db();

        if (DVD_SUCCESS == status) {
            printf(" - passed\n");
        } else {
            printf(" - FAILED!\n");
        }
    }

    /***********************************************************************
     * TEST 4 - Test dvd_today
     ***********************************************************************/
    {
        char *date;

        printf("\nTEST 4 - Testing dvd_today\n");
        status = dvd_today(&date);

        if (DVD_SUCCESS == status) {
            printf(" - Todays date is %s [YYYYMMDD]\n", date);
            printf(" - passed\n");
        } else {
            printf(" - FAILED!\n");
        }

    }

    /***********************************************************************
     * TEST 5 - Test dvd_err_text
     ***********************************************************************/
    {
        char *message_to_show;
        char msg_buf[30];
        int i;

        printf("\nTEST 5 - Testing dvd_err_text\n");

        for (i = 1; i > -17; i--) {
            status = dvd_err_text(i, &message_to_show);

            if (DVD_SUCCESS == status) {
                strncpy(msg_buf, message_to_show, 29);
                msg_buf[29] = '\0'; 

                printf(" - %03d : %s", i, msg_buf);
                printf(" - passed\n");
            } else {
                printf(" - %d - FAILED!\n");
                /* break; */
            }
        }
    }

    /***********************************************************************
     * TEST 6 - Test dvd_get_genre_list
     ***********************************************************************/
    {
        char **genre_list;
        int count;

        printf("\nTEST 6 - Testing dvd_get_genre_list\n");

        status = dvd_get_genre_list(&genre_list, &count);

        if (DVD_SUCCESS == status) {
            int i;

            printf(" - Number of genres - %03d\n", count);

            for (i = 0; i < count; i++) {
                printf(" - %03d : %s\n", i, genre_list[i]);
            }
            printf(" - passed\n");
        } else {
            printf(" - FAILED!\n");
        }
    }

    /***********************************************************************
     * TEST 7 - Test dvd_get_classification_list
     ***********************************************************************/
    {
        char **class_list;
        int count;

        printf("\nTEST 7 - Testing dvd_get_classification_list\n");

        status = dvd_get_classification_list(&class_list, &count);

        if (DVD_SUCCESS == status) {
            int i;

            printf(" - Number of classes - %03d\n", count);

            for (i = 0; i < count; i++) {
                printf(" - %03d : %s\n", i, class_list[i]);
            }
            printf(" - passed\n");
        } else {
            printf(" - FAILED!\n");
        }
    }

    /***********************************************************************
     * TEST 8 - Test dvd_member_create
     ***********************************************************************/
    {
        dvd_store_member new_member = { 0 };

        printf("\nTEST 8 - Testing dvd_member_create\n");

        strcpy(new_member.member_no, "B408");
        strcpy(new_member.title, "Mr");
        strcpy(new_member.fname, "Richard");
        strcpy(new_member.lname, "Stallman");
        strcpy(new_member.house_flat_ref, "Suite 330");
        strcpy(new_member.address1, "Free Software Foundation");
        strcpy(new_member.address2, "59 Temple Place");
        strcpy(new_member.town, "Boston");
        strcpy(new_member.state, "MA");
        strcpy(new_member.phone, "617-123-4567");
        strcpy(new_member.zipcode, "02111-1307");

        status = dvd_member_create(&new_member, &member_id);

        if (DVD_SUCCESS == status) {
            printf(" - assigned member id is #%d\n", member_id);
            printf(" - passed\n");
        } else {
           printf(" - FAILED!\n");
        }
    }

    /***********************************************************************
     * TEST X - Test dvd_member_search
     ***********************************************************************/
    {
        int count;
        int *result_ids;

        printf("\nTEST X - Testing dvd_member_search\n");

        status = dvd_member_search("Stallman", &result_ids, &count);
        if (DVD_SUCCESS == status) {
            int i;

            printf(" - count is %03d\n", count);
           
            for (i = 0; i < count; i++) {
                printf(" - result[%03d] is %03d\n", i, result_ids[i]);
            }

            printf(" - passed\n");
        } else {
           printf(" - FAILED!\n");
        }
    }

    /***********************************************************************
     * TEST X - Test dvd_member_get_id_from_number
     ***********************************************************************/
    {
        int id;
        char member_no[] = "B408";

        printf("\nTEST X - Testing dvd_member_get_id_from_number\n");

        status = dvd_member_get_id_from_number(member_no, &id);
        if (DVD_SUCCESS == status) {
            printf(" - returned member id %03d\n", id);
            printf(" - passed\n");
        } else if (DVD_ERR_NOT_FOUND == status) {
            printf(" - returned member not found\n", id);
            printf(" - passed\n");
        } else {
           printf(" - FAILED!\n");
        }
    }

    /***********************************************************************
     * TEST 9 - Test dvd_title_create
     ***********************************************************************/
    {
        dvd_title new_title = { 0 };

        printf("\nTEST 9 - Testing dvd_title_create\n");

        strcpy(new_title.title_text, "Silence of the Lambs");
        strcpy(new_title.asin, "0123456789");
        strcpy(new_title.director, "Stallman");
        strcpy(new_title.genre, "Horror");
        strcpy(new_title.classification, "18");
        strcpy(new_title.actor1, "Jeremy Irons");
        strcpy(new_title.actor2, "Salma Hayek");
        strcpy(new_title.release_date, "20001225");
        strcpy(new_title.rental_cost, "002.50");

        status = dvd_title_create(&new_title, &title_id);

        if (DVD_SUCCESS == status) {
            printf(" - assigned title id is #%d\n", title_id);
            printf(" - passed\n");
        } else {
           printf(" - FAILED!\n");
        }
    }

    /***********************************************************************
     * TEST 10 - Test dvd_disk_create
     ***********************************************************************/
    {
        dvd_disk new_disk = { 0 };

        printf("\nTEST 10 - Testing dvd_disk_create\n");
        new_disk.title_id = title_id;

        status = dvd_disk_create(&new_disk, &disk_id);

        if (DVD_SUCCESS == status) {
            printf(" - assigned disk id is #%d\n", disk_id);
            printf(" - passed\n");
        } else {
           printf(" - FAILED!\n");
        }
    }


    /***********************************************************************
     * TEST X - Test dvd_close
     ***********************************************************************/
    {
        printf("\nTEST X - Removing member, title, disk\n");

        printf(" - removing disk %d\n", disk_id);
        status = dvd_disk_delete(disk_id);

        if (DVD_SUCCESS == status) {
            printf(" - passed\n");
        } else {
           printf(" - FAILED!\n");
        }

        printf(" - removing title %d\n", title_id);
        status = dvd_title_delete(title_id);

        if (DVD_SUCCESS == status) {
            printf(" - passed\n");
        } else {
           printf(" - FAILED!\n");
        }

        printf(" - removing member %d\n", member_id);
        status = dvd_member_delete(member_id);

        if (DVD_SUCCESS == status) {
            printf(" - passed\n");
        } else {
           printf(" - FAILED!\n");
        }
    }

    /***********************************************************************
     * TEST X - Test dvd_close
     ***********************************************************************/
    printf("\nTEST X - Testing dvd_close\n");
    status = dvd_close_db();

    if (DVD_SUCCESS == status) {
        printf(" - passed\n");
    } else {
        printf(" - FAILED!\n");
    }
};
