/***************************************************************
 *
 * dvd_store.x -  DVD Store RPC Interface Definition
 *
 * Demonstration code from 'Professional Linux Programming'
 *
 * Written by Neil Matthew, Rick Stones et. al.
 *
 * Copyright (C) 2000 Wrox Press.
 *
 * http://www.wrox.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 **************************************************************/

/*
 * there is a slight issue in that some of the definitions in dvd.h
 * need also to be defined here in dvd_store.x to allow the rpcgen
 * compiler generate the RPC stubs correctly.
 * 
 * the problem occurs when dvd.h and dvd_store.h are both included
 * in the same C file -- the compiler complains about multiple definitions
 *
 * the solution is to use the % syntax in the .x file, which allows
 * code to be passed through to 'C' unmodified.  By protecting dvd.h
 * with a define (DVD_H) and ensuring that it is not defined here, we
 * safely include both in the same C source file.
 *
 * so, the workaround steps are:
 * 1.  added DVD_H to dvd.h to prevent multiple-inclusion, and also to give
 *     a suitable guard clause for the definitions in dvd_store.x
 * 2.  protected definitions in dvd_store.x with same guard cause (DVD_H)
 * 3.  ensure that dvd_store.h is included in a C file AFTER dvd.h
 */

%#ifndef DVD_H
/* Error definitions */
const DVD_SUCCESS = 0;
const DVD_ERR_NO_FILE = -1;
const DVD_ERR_BAD_TABLE = -2;
const DVD_ERR_NO_MEMBER_TABLE = -3;
const DVD_ERR_BAD_MEMBER_TABLE = -4;
const DVD_ERR_BAD_TITLE_TABLE = -5;
const DVD_ERR_BAD_DISK_TABLE = -6;
const DVD_ERR_BAD_SEEK = -7;
const DVD_ERR_NULL_POINTER = -8;
const DVD_ERR_BAD_WRITE = -9;
const DVD_ERR_BAD_READ = -10;
const DVD_ERR_NOT_FOUND = -11;
const DVD_ERR_NO_MEMORY = -12;
const DVD_ERR_BAD_RENTAL_TABLE = -13;
const DVD_ERR_BAD_RESERVE_TABLE = -14;
const DVD_ERR_BAD_DATABASE = -15;
const DVD_ERR_BAD_GENRE = -16;

/* size definitions */
const MEMBER_KNOWN_ID_LEN = 6;
const PERSON_TITLE_LEN = 4;
const NAME_LEN = 26;
const ADDRESS_LEN = 51;
const STATE_LEN = 3;
const PHONE_NO_LEN = 31;
const ZIP_CODE_LEN = 11;
const DVD_TITLE_LEN = 61;
const ASIN_LEN = 11;
const GENRE_LEN = 21;
const CLASS_LEN = 11;
const DAY_DATE_LEN = 9;
const COST_LEN = 7;

/* structures */
struct dvd_store_member {
    int member_id;
    char member_no[MEMBER_KNOWN_ID_LEN];
    char title[PERSON_TITLE_LEN];
    char fname[NAME_LEN];
    char lname[NAME_LEN];
    char house_flat_ref[NAME_LEN];
    char address1[ADDRESS_LEN];
    char address2[ADDRESS_LEN];
    char town[ADDRESS_LEN];
    char state[STATE_LEN];
    char phone[PHONE_NO_LEN];
    char zipcode[ZIP_CODE_LEN];
};

struct dvd_title {
    int title_id;
    char title_text[DVD_TITLE_LEN];
    char asin[ASIN_LEN];
    char director[NAME_LEN];
    char genre[GENRE_LEN];
    char classification[CLASS_LEN];
    char actor1[NAME_LEN];
    char actor2[NAME_LEN];
    char release_date[DAY_DATE_LEN];
    char rental_cost[COST_LEN];
};

struct dvd_disk {
    int disk_id;
    int title_id;
};

%#endif

struct dvd_open_db_login_arg {
    string user<>;
    string password<>;
};

struct dvd_member_get_res {
    int status;
    dvd_store_member completed_member_record;
};

struct dvd_member_create_res {
    int status;
    dvd_store_member updated_member_record;
    int member_id;
};

struct dvd_member_get_id_from_number_res {
    int status;
    int member_id;
};

typedef int int_array<>;

struct dvd_member_search_res {
    int status;
    int_array result_ids;
    int count;
};
    
struct dvd_title_get_res {
    int status;
    dvd_title completed_title_record;
};

struct dvd_title_create_res {
    int status;
    dvd_title updated_title_record;
    int title_id;
};

struct dvd_title_search_arg {
    string title<>;
    string name<>;
};

struct dvd_title_search_res {
    int status;
    int_array result_ids;
    int count;
};

struct dvd_disk_get_res {
    int status;
    dvd_disk completed_disk_record;
};

struct dvd_disk_create_res {
    int status;
    dvd_disk updated_disk_record;
    int disk_id;
};

struct dvd_disk_search_res {
    int status;
    int_array result_ids;
    int count;
};

typedef string string_array<>;

struct dvd_get_classification_list_res {
    int status;
    string_array class_list<>;
    int count;
};

struct dvd_get_genre_list_res {
    int status;
    string_array genre_list<>;
    int count;
};

struct dvd_err_text_res {
    int status;
    string message_to_show<>;
};

struct dvd_today_res {
    int status;
    string date<>;
};

struct dvd_rent_title_arg {
    int member_id;
    int title_id;
};

struct dvd_rent_title_res {
    int status;
    int disk_id;
};

struct dvd_rented_disk_info_res {
    int status;
    int member_id;
    string date_rented<>;
};

struct dvd_disk_return_res {
    int status;
    int member_id;
    string date<>;
};

struct dvd_overdue_disks_arg {
    string date1<>;
    string date2<>;
};

struct dvd_overdue_disks_res {
    int status;
    int_array disk_ids;
    int count;
};

struct dvd_reserve_title_query_by_member_res {
    int status;
    int title_id;
};

struct dvd_title_available_arg {
    int title_id;
    string date<>;
};

struct dvd_title_available_res {
    int status;
    int count;
};

struct dvd_reserve_title_arg {
    string date<>;
    int title_id;
    int member_id;
};

struct dvd_reserve_title_query_by_titledate_arg {
    int title_id;
    string date<>;
};

struct dvd_reserve_title_query_by_titledate_res {
    int status;
    int_array member_ids;
    int count;
};

program DVD_STORE_PROG {
    version DVD_STORE_VERS {
        int DVD_OPEN_DB() = 1;
        int DVD_OPEN_DB_LOGIN(dvd_open_db_login_arg) = 2;
        int DVD_CLOSE_DB() = 3;

        int DVD_MEMBER_SET(dvd_store_member) = 4;
        dvd_member_get_res DVD_MEMBER_GET(int) = 5;
        dvd_member_create_res DVD_MEMBER_CREATE(dvd_store_member) = 6;
        int DVD_MEMBER_DELETE(int) = 7;
        dvd_member_search_res DVD_MEMBER_SEARCH(string lname) = 8;
        dvd_member_get_id_from_number_res DVD_MEMBER_GET_ID_FROM_NUMBER(string member_no) = 9;

        int DVD_TITLE_SET(dvd_title) = 10;
        dvd_title_get_res DVD_TITLE_GET(int) = 11;
        dvd_title_create_res DVD_TITLE_CREATE(dvd_title) = 12;
        int DVD_TITLE_DELETE(int title_id) = 13;
        dvd_title_search_res DVD_TITLE_SEARCH(dvd_title_search_arg) = 14;

        int DVD_DISK_SET(dvd_disk) = 15;        
        dvd_disk_get_res DVD_DISK_GET(int) = 16;
        dvd_disk_create_res DVD_DISK_CREATE(dvd_disk) = 17;
        int DVD_DISK_DELETE(int disk_id) = 18;
        dvd_disk_search_res DVD_DISK_SEARCH(int) = 19;

        dvd_get_classification_list_res DVD_GET_CLASSIFICATION_LIST(void) = 20;
        dvd_get_genre_list_res DVD_GET_GENRE_LIST(void) = 21;
        dvd_err_text_res DVD_ERR_TEXT(int) = 22;
        dvd_today_res DVD_TODAY(void) = 23;

        dvd_rent_title_res DVD_RENT_TITLE(dvd_rent_title_arg) = 24;

        dvd_rented_disk_info_res DVD_RENTED_DISK_INFO(int) = 25;

        dvd_disk_return_res DVD_DISK_RETURN(int) = 26;

        dvd_overdue_disks_res DVD_OVERDUE_DISKS(dvd_overdue_disks_arg) = 27;

        dvd_title_available_res DVD_TITLE_AVAILABLE(dvd_title_available_arg) = 28;

        int DVD_RESERVE_TITLE(dvd_reserve_title_arg) = 29;
        int DVD_RESERVE_TITLE_CANCEL(int) = 30;
        dvd_reserve_title_query_by_member_res DVD_RESERVE_TITLE_QUERY_BY_MEMBER(int member_id) = 31;
        dvd_reserve_title_query_by_titledate_res DVD_RESERVE_TITLE_QUERY_BY_TITLEDATE(dvd_reserve_title_query_by_titledate_arg) = 32;

    } = 1;
} = 0x20000099;
