/***************************************************************
 *
 * dvd_server_wrapper.c - Server Side RPC to DVD wrappers
 *
 *
 * Demonstration code from 'Professional Linux Programming'
 *
 * Written by Neil Matthew, Rick Stones et. al.
 *
 * Copyright (C) 2000 Wrox Press.
 *
 * http://www.wrox.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 **************************************************************/

#include <stdio.h>
#include <rpc/rpc.h>
/*
 * because some of the #defines and structure typedefs are in both
 * dvd.h and the automatically rpcgen-generated dvd_store.h, it is 
 * important to ensure that the dvd_store.h is included AFTER
 * the dvd.h
 */
#include "dvd.h"
#include "dvd_store.h"    /* dvd_store.h will be generated by rpcgen */


int * dvd_open_db_1_svc(void *dummy_ptr, struct svc_req * svc_req_ptr)
{
    static int result = 0;
#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_open_db_1_svc() called\n");
#endif

    result =  dvd_open_db();

    return (&result);
}

int * dvd_open_db_login_1_svc(dvd_open_db_login_arg *open_db_login_arg_ptr, struct svc_req * svc_req_ptr)
{
    static int result = 0;
#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_open_db_login_1_svc() called\n");
#endif

    result = dvd_open_db_login(open_db_login_arg_ptr->user, open_db_login_arg_ptr->password);

    return (&result);
}

int * dvd_close_db_1_svc(void *dummy_ptr, struct svc_req * svc_req_ptr)
{
    static int result = 0;
#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_close_db_1_svc() called\n");
#endif

    result = dvd_close_db();

    return (&result);
}

int * dvd_member_set_1_svc(dvd_store_member *member_ptr, struct svc_req * svc_req_ptr)
{
    static int result = 0;
    dvd_store_member tmp_member;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_member_set_1_svc() called\n");
#endif

    /* get the existing record to ensure it exists */
    result = dvd_member_get(member_ptr->member_id, &tmp_member);
    if (DVD_SUCCESS == result)
    {
        result = dvd_member_set(member_ptr);
    }

    return (&result);
}

dvd_member_get_res * dvd_member_get_1_svc(int *member_id_ptr, struct svc_req * svc_req_ptr)
{
    static dvd_member_get_res result; 
    dvd_store_member tmp_member;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_member_get_1_svc() called\n");
#endif

    result.status = dvd_member_get(*member_id_ptr, &tmp_member);
    if (DVD_SUCCESS == result.status)
    {
        result.completed_member_record = tmp_member;
    }
    
    return (&result);
}

dvd_member_create_res * dvd_member_create_1_svc(dvd_store_member *member_ptr, struct svc_req * svc_req_ptr)
{
    static dvd_member_create_res result;
    result.updated_member_record = *member_ptr;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_member_create_1_svc() called\n");
#endif

    result.status = dvd_member_create(&(result.updated_member_record), &(result.member_id));

    return (&result);
}

int * dvd_member_delete_1_svc(int *member_id_ptr, struct svc_req * svc_req_ptr)
{
    static int result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_member_delete_1_svc() called\n");
#endif

    result = dvd_member_delete(*member_id_ptr);

    return (&result);
}

dvd_member_search_res * dvd_member_search_1_svc(char **lname_string_ptr, struct svc_req * svc_req_ptr)
{
    static dvd_member_search_res result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_member_search_1_svc() called\n");
#endif

    result.status = dvd_member_search(*lname_string_ptr,
        &(result.result_ids.int_array_val),
        &(result.count));
    result.result_ids.int_array_len = result.count;

    return (&result);
}

dvd_member_get_id_from_number_res * dvd_member_get_id_from_number_1_svc(char **member_no_string_ptr, struct svc_req * svc_req_ptr)
{
    static dvd_member_get_id_from_number_res result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_member_get_id_from_number_1_svc() called\n");
#endif

    result.status = dvd_member_get_id_from_number(*member_no_string_ptr,
        &(result.member_id));

    return (&result);
}

int * dvd_title_set_1_svc(dvd_title *title_ptr, struct svc_req * svc_req_ptr)
{
    static int result;
    dvd_title *tmp_title_ptr;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_title_set_1_svc() called\n");
#endif

    /* get the existing record to ensure it exists */
    result = dvd_title_get(title_ptr->title_id, tmp_title_ptr);
    if (DVD_SUCCESS == result)
    {
        result = dvd_title_set(title_ptr);
    }

    return (&result);
}

dvd_title_get_res * dvd_title_get_1_svc(int *title_id_ptr, struct svc_req * svc_req_ptr)
{
    static dvd_title_get_res result;
    dvd_title tmp_title;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_title_get_1_svc() called\n");
#endif

    result.status = dvd_title_get(*title_id_ptr, &tmp_title);
    if (DVD_SUCCESS == result.status)
    {
        result.completed_title_record = tmp_title;
    }

    return (&result);
}

dvd_title_create_res * dvd_title_create_1_svc(dvd_title *title_ptr, struct svc_req * svc_req_ptr)
{
    static dvd_title_create_res result;
    result.updated_title_record = *title_ptr;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_title_create_1_svc() called\n");
#endif

    result.status = dvd_title_create(&(result.updated_title_record), &(result.title_id));

    return (&result);
}

int * dvd_title_delete_1_svc(int *title_id_ptr, struct svc_req * svc_req_ptr)
{
    static int result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_title_delete_1_svc() called\n");
#endif

    result = dvd_title_delete(*title_id_ptr);

    return (&result);
}

dvd_title_search_res * dvd_title_search_1_svc(dvd_title_search_arg *title_search_arg_ptr,
    struct svc_req * svc_req_ptr)
{
    static dvd_title_search_res result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_title_search_1_svc() called\n");
#endif

    result.status = dvd_title_search(title_search_arg_ptr->title,
        title_search_arg_ptr->name,
        &(result.result_ids.int_array_val),
        &(result.count));
    result.result_ids.int_array_len = result.count;

    return (&result);
}

int * dvd_disk_set_1_svc(dvd_disk *disk_ptr, struct svc_req * svc_req_ptr)
{
    static int result;
    dvd_disk tmp_disk;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_disk_set_1_svc() called\n");
#endif
    result = dvd_disk_get(disk_ptr->disk_id, &tmp_disk);
    if (DVD_SUCCESS == result)
    {
        result = dvd_disk_set(disk_ptr);
    }

    return (&result);
}

dvd_disk_get_res * dvd_disk_get_1_svc(int *disk_id_ptr, struct svc_req * svc_req_ptr)
{
    static dvd_disk_get_res result;
    dvd_disk tmp_disk;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_disk_get_1_svc() called\n");
#endif

    result.status = dvd_disk_get(*disk_id_ptr, &tmp_disk);
    if (DVD_SUCCESS == result.status)
    {
        result.completed_disk_record = tmp_disk;
    }

    return (&result);
}

dvd_disk_create_res * dvd_disk_create_1_svc(dvd_disk *disk_ptr, struct svc_req * svc_req_ptr)
{
    static dvd_disk_create_res result;
    result.updated_disk_record = *disk_ptr;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_disk_create_1_svc() called\n");
#endif

    result.status = dvd_disk_create(&(result.updated_disk_record), &(result.disk_id));

    return (&result);
}

int * dvd_disk_delete_1_svc(int *disk_id_ptr, struct svc_req * svc_req_ptr)
{
    static int result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_disk_delete_1_svc() called\n");
#endif

    result = dvd_disk_delete(*disk_id_ptr);

    return (&result);
}

dvd_disk_search_res * dvd_disk_search_1_svc(int *disk_id_ptr, struct svc_req * svc_req_ptr)
{
    static dvd_disk_search_res result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_disk_search_1_svc() called\n");
#endif

    result.status = dvd_disk_search(*disk_id_ptr,
        &(result.result_ids.int_array_val),
        &(result.count));
    result.result_ids.int_array_len = result.count;

    return (&result);
}

dvd_get_genre_list_res * dvd_get_genre_list_1_svc(void *dummy_ptr, struct svc_req * svc_req_ptr)
{
    static dvd_get_genre_list_res result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_get_genre_list_1_svc() called\n");
#endif
    result.status = dvd_get_genre_list(&(result.genre_list.genre_list_val), &(result.count));
    result.genre_list.genre_list_len = result.count;

    return (&result);
}

dvd_get_classification_list_res * dvd_get_classification_list_1_svc(void *dummy_ptr, struct svc_req * svc_req_ptr)
{
    static dvd_get_classification_list_res result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_get_classification_list_1_svc() called\n");
#endif
    result.status = dvd_get_classification_list(&(result.class_list.class_list_val), &(result.count));
    result.class_list.class_list_len = result.count;

    return (&result);
}

dvd_err_text_res * dvd_err_text_1_svc(int *error_id_ptr, struct svc_req * svc_req_ptr)
{
    static dvd_err_text_res result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_err_text_1_svc() called\n");
#endif

    result.status = dvd_err_text(*error_id_ptr, &(result.message_to_show));

    return (&result);
}

dvd_today_res * dvd_today_1_svc(void *dummy_ptr, struct svc_req * svc_req_ptr)
{
    static dvd_today_res result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_today_1_svc() called\n");
#endif
    result.status = dvd_today(&(result.date));

    return (&result);
}

dvd_rent_title_res * dvd_rent_title_1_svc(dvd_rent_title_arg *rented_title_arg_ptr, struct svc_req * svc_req_ptr)
{
    static dvd_rent_title_res result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_rent_title_1_svc() called\n");
#endif

    result.status = dvd_rent_title(rented_title_arg_ptr->member_id, rented_title_arg_ptr->title_id,
        &(result.disk_id));

    return (&result);
}

dvd_rented_disk_info_res * dvd_rented_disk_info_1_svc(int *disk_id_ptr, struct svc_req * svc_req_ptr)
{
    static dvd_rented_disk_info_res result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_rented_disk_info_1_svc() called\n");
#endif

    result.status = dvd_rented_disk_info(*disk_id_ptr,
        &(result.member_id),
        result.date_rented);

    return (&result);
}

dvd_disk_return_res * dvd_disk_return_1_svc(int *disk_id, struct svc_req * svc_req_ptr)
{
    static dvd_disk_return_res result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_disk_return_1_svc() called\n");
#endif

    result.status = dvd_disk_return(*disk_id, &(result.member_id),
        result.date);

    return (&result);
}

dvd_overdue_disks_res * dvd_overdue_disks_1_svc(dvd_overdue_disks_arg *overdue_disks_arg_ptr, struct svc_req * svc_req_ptr)
{
    static dvd_overdue_disks_res result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_overdue_disks_1_svc() called\n");
#endif

    result.status = dvd_overdue_disks(overdue_disks_arg_ptr->date1, overdue_disks_arg_ptr->date2,
        &(result.disk_ids.int_array_val), &(result.count));
    result.disk_ids.int_array_len = result.count;

    return (&result);
}

dvd_title_available_res * dvd_title_available_1_svc(dvd_title_available_arg *title_available_arg_ptr, struct svc_req * svc_req_ptr)
{
    static dvd_title_available_res result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_title_available_1_svc() called\n");
#endif

    result.status = dvd_title_available(title_available_arg_ptr->title_id, title_available_arg_ptr->date,
        &(result.count));

    return (&result);
}

int * dvd_reserve_title_1_svc(dvd_reserve_title_arg *reserve_title_arg_ptr, struct svc_req * svc_req_ptr)
{
    static int result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_open_db_login_1_svc() called\n");
#endif

    result = dvd_reserve_title(reserve_title_arg_ptr->date, reserve_title_arg_ptr->title_id,
        reserve_title_arg_ptr->member_id);

    return (&result);
}

int * dvd_reserve_title_cancel_1_svc(int *member_id_ptr, struct svc_req * svc_req_ptr)
{
    static int result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_reserve_title_cancel_1_svc() called\n");
#endif

    result = dvd_reserve_title_cancel(*member_id_ptr);

    return (&result);
}

dvd_reserve_title_query_by_member_res * dvd_reserve_title_query_by_member_1_svc(int * member_id_ptr,
    struct svc_req * svc_req_ptr)
{
    static dvd_reserve_title_query_by_member_res result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_reserve_title_query_by_member_1_svc() called\n");
#endif

    result.status = dvd_reserve_title_query_by_member(*member_id_ptr, &(result.title_id));

    return (&result);
}

dvd_reserve_title_query_by_titledate_res *
    dvd_reserve_title_query_by_titledate_1_svc(dvd_reserve_title_query_by_titledate_arg
        *reserve_title_query_by_titledate_arg_ptr,
        struct svc_req * svc_req_ptr)
{
    static dvd_reserve_title_query_by_titledate_res result;

#ifdef RPC_DEBUG
    fprintf(stderr, "RPC_SERVER: dvd_reserve_title_query_by_titledate_1_svc() called\n");
#endif

    result.status = dvd_reserve_title_query_by_titledate(reserve_title_query_by_titledate_arg_ptr->title_id,
        reserve_title_query_by_titledate_arg_ptr->date,
        &(result.member_ids.int_array_val), 
        &(result.count));
    result.member_ids.int_array_len = result.count;

    return (&result);
}
