%module sysinfo
%{
#include <linux/kernel.h>
#include <linux/sys.h>
#include <string.h>
#include <errno.h>
%}

%include "pointer.i"
%include "linux/kernel.h"
%include "exception.i"

%typemap(python,except) unsigned long {
        $function
        if(PyErr_Occurred()) {
                $cleanup
                return NULL;
        }
}

%addmethods sysinfo {
        unsigned long getload(int index) {
                if(index >= (sizeof(self->loads)/sizeof(unsigned long)) ||
                   index < 0) {
                        _SWIG_exception(SWIG_ValueError,"Index out of range");
                        return 0;
                }
                return self->loads[index];
        }
}


%typemap(python,except) int {
        $function
        if( $source < 0) {
                _SWIG_exception(SWIG_RuntimeError,strerror(errno));
                $cleanup
                return NULL; 
        }
}

%name(getsysinfo) int sysinfo(struct sysinfo *info);

%typemap(python,ignore)
     STRINGOUT (char _temp[255]) {
        _temp[0] = 0;
        $target = _temp;
    }

%typemap(python,argout)
    STRINGOUT  {
    PyObject *o;

    o = Py_BuildValue("s",$source);
    if (!$target) {
      $target = o;
    } else {
      $target = t_output_helper($target, o);
    }
}

%apply STRINGOUT {char *name};
%apply STRINGLEN {int len};
int getdomainname(char *name, int len);
%clear STRINGOUT, char *name;
%clear STRINGLEN, int len;
