%module servtyp
%{
#include <string.h>
#include <errno.h>
#include <netdb.h>

struct servent_alias {
        char **aliases;
};

struct ServentIterator {
        int isopen;
};

%}


%include "exception.i"
%include "typemaps.i"

%typemap(python,except) struct servent *, char *, PyObject *,int {
     $function
     if(PyErr_Occurred()) {
          $cleanup
          return NULL;
     }
}

%wrapper %{
#define MAX_MY_ALIASES 10
struct my_servent {
        struct servent s;
        char    *aliases[MAX_MY_ALIASES];
        char    data[1024];
        char    name[255];
        char    proto[16];
};
struct servent *CopyServent(struct servent *res)
{
        struct my_servent *copy;
        char *cp,**icp;
        int     index;

        copy = (struct my_servent *) calloc(1,sizeof(struct my_servent));
                      
        if(NULL == copy) {
                SWIG_exception(SWIG_MemoryError,"out of memory");
        }
        memcpy(copy,res,sizeof(*res));
        strcpy(copy->name,res->s_name);
        copy->s.s_name = copy->name;
        strcpy(copy->proto,res->s_proto);
        copy->s.s_proto = copy->proto;
        /* now fixup aliases */
        index = 0;
        copy->aliases[0] = NULL;
        cp = copy->data;
        copy->s.s_aliases = copy->aliases;
        icp = res->s_aliases;
        while(icp && *icp && index < MAX_MY_ALIASES &&
                (cp - copy->data) < sizeof(copy->data)-255) {
                copy->aliases[index++] = cp;
                strcpy(cp,*icp);
                cp = cp + strlen(cp)+1;
                icp++;
        }
        copy->aliases[index] = NULL;
        return (struct servent *) copy;
}
%}

struct servent_alias {
        %addmethods {
                char *__getitem__(int index) {
                        char **i = self->aliases;
                        while(i && *i) {
                                if(0 == index)
                                        return *i;
                                index--;
                                i++;
                        }
                        SWIG_exception(SWIG_IndexError,"index out of bounds");
                }
        }       /* end addmethods */
}

struct servent {
   %addmethods {
      servent(PyObject *name_or_port,char *proto="tcp") {
         struct servent *res = NULL;

         if(PyInt_Check(name_or_port)) 
            res = getservbyport(ntohs(PyInt_AsLong(name_or_port)),
               proto);
         else if(PyString_Check(name_or_port))
            res = getservbyname(PyString_AsString(name_or_port),
               proto);
         else {
            SWIG_exception(SWIG_ValueError,"Invalid name or port\ type");
         }
         if(NULL == res) {
            SWIG_exception(SWIG_RuntimeError,strerror(errno));
         }
         return res;
         return CopyServent(res);
      } /* end servent constructor /
      ~servent() { } / do nothing in destructor */
      int port_get() {
         return ntohs(self->s_port);
      }
      %new struct servent_alias *aliases_get() {
         struct servent_alias *i = malloc(sizeof(*i));
         i->aliases = self->s_aliases;
         return i;
      }

      int __cmp__(PyObject *other_obj) {
         /* compare to other object */
         struct servent *other;
         PyObject *temp_obj;

           if(NULL != (temp_obj = PyObject_GetAttrString(other_obj,"this")))
	      other_obj = temp_obj;
           else
              PyErr_Clear();
           if(!PyString_Check(other_obj) ||
           SWIG_GetPtr(PyString_AsString(other_obj),
           (void **) &other, "_struct_servent_p")) {
              _SWIG_exception(SWIG_TypeError,
                              "other object must be type servent");
              return 0;
           }
           if(self->s_port < other->s_port)
              return -1;
           else if(self->s_port == other->s_port)
              return strcasecmp(self->s_proto,other->s_proto); 
           else
              return 1;

      }    /* end __cmp__ */

      int __hash__() {
         unsigned long v = self->s_port;
         if(!strcasecmp(self->s_proto,"udp"))
         v = v + 0x100000;
         return v;
      } /* end __hash__ */


      PyObject *__str__() {
         char info[128];
         
         sprintf(info,"servent %s port %d proto %s",
            self->s_name,ntohs(self->s_port),self->s_proto);
         return PyString_FromString(info);
      }
   }   /* end addmethods */
%readonly
   %name(name) char *s_name;
   %name(aliases) struct servent_alias *s_aliases;
   %name(aliases) char **s_aliases;
   %name(port) int s_port;
   %name(proto) char *s_proto;
%readwrite
}

struct ServentIterator {
     %addmethods {
       %new struct servent *__getitem__(int index) {
            struct servent *res;

            if(!self->isopen) {
              self->isopen++;
              setservent(1);
            }
            res = getservent();
            if(NULL == res) {
              endservent();
              self->isopen = 0;
              SWIG_exception(SWIG_IndexError,"no more entries");
            }
            return CopyServent(res);
       }    /* end __getitem__ */
       ~ServentIterator() {
            if(self->isopen)
              endservent();
            free(self);
       }
     } /* end addmethods */
};
