<?php
// dvdstorereserve.php3
// Reserve a title for this member

require( 'dvdstorecommon.php3' );



if ( $dateToReserve == 0 )
{
	//User has not yet specified a date to reserve the title
	//Prompt the user to enter a date
	GetReserveDate( $memberID, $titleID );
} else {

	// Begin the transaction
	dvd_begin_transaction();
	//We have the reservation date, member ID and the title ID now
	if ( dvd_reserve_title_query_by_member( $memberID, $tmpTitle ) == false )
		DisplayErrorMessage( "dvd_display_title_query_by_member failed" );
	else {
		if (  $tmpTitle > 0 )
			//Member already has a title reserved
			DisplayErrorMessage( "Sorry you already have a title reserved" );
		else {
			//Try reserving the title for this member
			$dateArray = split( '[/.-]', $dateToReserve );
			$absReserveTime = mktime( 0, 0, 0, $dateArray[0], $dateArray[1], $dateArray[2] );	
			$absToday = time( );	
			if (( $absReserveTime - $absToday ) > ( 24 * 60 * 60*7 ))
			{
				//Reservations can only be made 7 days in advance
				DisplayErrorMessage( "You can reserve a title only 7 days in advance" );
				GetReserveDate( $memberID, $title );
			} else {
				//Check if the title is available for the day
				if ( dvd_title_available( $title, $date, $disk ) == false )
					DisplayErrorMessage( "dvd_title_available failed" );
				else
					if (  $disk == 0)
						DisplayErrorMessage( "The title is not available on this date" );
					else
						if ( dvd_reserve_title( $dateArray[2] . $dateArray[0] . $dateArray[1], $title, $disk, $memberID ) == false ) {
							DisplayErrorMessage( "dvd_reserve_title failed" );
						} else {
						printf( "<B>Reservation succeeded</B>" );
					}
			}
		}
		// End the transaction
		dvd_commit_transaction();
	}
}	
?>

