<?php
// dvdstorelogin.php3
// Process login with this script

require( 'dvdstorecommon.php3' );


if ( empty( $lastName ) && empty( $memberID ))
{
//First time this script is invoked
	GenerateHTMLHeader( "Login to DVD store online" );
	GenerateLoginForm( );
} else {
	if ( empty( $lastName ) || empty( $memberID ))
	{
		//User submitted an incomplete form
		GenerateHTMLHeader( "Login to DVD store online" );	
		DisplayErrorMessage( "Lastname and MemberID needs to be entered" );
		GenerateLoginForm( );
	} else {
		//We search for matching last names
		if (dvd_member_search( $lastName, $matches) == false) {
			DisplayErrorMessage("Error in dvd_member_search");
		} else if ( !$matches ||( count($matches) == 0) ) {
			//No matches for last name
			GenerateHTMLHeader( "Login Error" );
			DisplayErrorMessage( "No such User in the database" );
		} else {
			//Found atleast one match for lastname
			for ( $i = 0; $i < count($matches); $i++ )
			{
				if ( $matches[$i] == $memberID )
				{
					//Login succeded
					GenerateHTMLHeader( "Welcome to DVD store online" );
					DisplayUserMenu( $memberID );
					return;
				}
			}
			// Login Error
			GenerateHTMLHeader( "Login Error" );
			DisplayErrorMessage( "Last Name and the Member ID don't match!");
		}
	}
}
?>




